#include "Blast/Math/Vector3.h"

#include "Blast/Math/Matrix.h"

using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// (0, 0, 0)擾
const Vector3& Vector3::Zero()
{
	return mStKZero;
}

/// (1, 0, 0)擾
const Vector3& Vector3::UnitX()
{
	return mStKUnitX;
}

/// (0, 1, 0)擾
const Vector3& Vector3::UnitY()
{
	return mStKUnitY;
}

/// (0, 0, 1)擾
const Vector3& Vector3::UnitZ()
{
	return mStKUnitZ;
}

/// (1, 1, 1)擾
const Vector3& Vector3::One()
{
	return mStKOne;
}


/// 擾
float Vector3::Length(const Vector3& kRV)
{
	// MEMO:x߂double^ŎZoĂϊ܂B
	// Zo
	double squareLength = (kRV.mX * kRV.mX) + (kRV.mY * kRV.mY) + (kRV.mZ * kRV.mZ);
	double lengthDouble = sqrt(squareLength);

	// ^ϊ
	float length = static_cast<float>(lengthDouble);

	return length;
}

/// 擾
float Vector3::Distance(const Vector3& kRA, const Vector3& kRB)
{
	Vector3 sub;
	sub.mX = kRA.mX - kRB.mX;
	sub.mY = kRA.mY - kRB.mY;
	sub.mZ = kRA.mZ - kRB.mZ;

	float d = abs(sub.Length());

	return d;
}

/// Pʉ
Vector3 Vector3::Normalize(const Vector3& kRV)
{
	float length = kRV.Length();

	Vector3 n = kRV / length;

	return n;
}

/// 
float Vector3::Dot(const Vector3& kRVa, const Vector3& kRVb)
{
	float dot = (kRVa.mX * kRVb.mX) + 
				(kRVa.mY * kRVb.mY) +
				(kRVa.mZ * kRVb.mZ);

	return dot;
}

/// O
Vector3 Vector3::Cross(const Vector3& kRVa, const Vector3& kRVb)
{
	// MEMO: [(Y1 * Z2 - Y2 * Z1), (Z1 * X2 - Z2 * X1), (X1 * Y2 - X2 * Y1)]

	float x = kRVa.mY * kRVb.mZ - kRVb.mY * kRVa.mZ;
	float y = kRVa.mZ * kRVb.mX - kRVb.mZ * kRVa.mX;
	float z = kRVa.mX * kRVb.mY - kRVb.mX * kRVa.mY;

	Vector3 v(x, y, z);

	return v;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// ftHgRXgN^
Vector3::Vector3() :
mX(0),
mY(0),
mZ(0)
{
}

/// RXgN^Beɓl܂
Vector3::Vector3(float value) :
mX(value),
mY(value),
mZ(value)
{
}

/// RXgN^Beꂼݒ肵܂
Vector3::Vector3(float a, float b, float c) :
mX(a),
mY(b),
mZ(c)
{
}

/// fXgN^
Vector3::~Vector3()
{
}


/// eZ
void Vector3::Add(float a, float b, float c)
{
	mX += a;
	mY += b;
	mZ += c;
}

/// eZ
void Vector3::Add(const Vector3& kRV)
{
	Add(kRV.mX, kRV.mY, kRV.mZ);
}


/// eZ
void Vector3::Subtract(float a, float b, float c)
{
	mX -= a;
	mY -= b;
	mZ -= c;
}

/// eZ
void Vector3::Subtract(const Vector3& kRV)
{
	Subtract(kRV.mX, kRV.mY, kRV.mZ);
}


/// eZ
void Vector3::Multiply(float a, float b, float c)
{
	mX *= a;
	mY *= b;
	mZ *= c;
}

/// eɒlZ
void Vector3::Multiply(float a)
{
	Multiply(a, a, a);
}

/// eZ
void Vector3::Multiply(volatile const Vector3& kRV)
{
	Multiply(kRV.mX, kRV.mY, kRV.mZ);
}


/// sƏZ
void Vector3::Multiply(const Matrix& kRMatrix)
{
	// MEMO:xNg͍sxNgƂ݂Ȃ܂B

	// XZo
	float x =
		mX * kRMatrix.m11 +
		mY * kRMatrix.m21 +
		mZ * kRMatrix.m31 + 
		1 * kRMatrix.m41;

	// YZo
	float y =
		mX * kRMatrix.m12 +
		mY * kRMatrix.m22 +
		mZ * kRMatrix.m32 + 
		1 * kRMatrix.m42;
	
	// ZZo
	float z =
		mX * kRMatrix.m13 +
		mY * kRMatrix.m23 +
		mZ * kRMatrix.m33 + 
		1 * kRMatrix.m43;

	// WZo
	float w =
		mX * kRMatrix.m14 +
		mY * kRMatrix.m24 +
		mZ * kRMatrix.m34 + 
		1 * kRMatrix.m44;

	// l
	mX = x / w;
	mY = y / w;
	mZ = z / w;
}


/// eZ
void Vector3::Divide(float a, float b, float c)
{
	mX /= a;
	mY /= b;
	mZ /= c;
}

/// eɒlZ
void Vector3::Divide(float a)
{
	Divide(a, a, a);
}

/// eZ
void Vector3::Divide(const Vector3& kRV)
{
	Divide(kRV.mX, kRV.mY, kRV.mZ);
}


/// 擾
float Vector3::Length() const
{
	return Length(*this);
}


/// 擾
float Vector3::Distance(const Vector3& kRV) const
{
	return Distance(*this, kRV);
}


/// Pʉ
Vector3 Vector3::Normalize() const
{
	return Normalize(*this);
}


/// ςZo
float Vector3::Dot(const Vector3& kRV) const
{
	return Dot(*this, kRV);
}

/// OςZo
Vector3 Vector3::Cross(const Vector3& kRV) const
{
	return Cross(*this, kRV);
}

/// z擾
float* Vector3::GetArray()
{
	return m;
}

/// z擾
const float* Vector3::GetArray() const
{
	return m;
}


//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

/// +Zqł̉Z\
Vector3 Vector3::operator+ (const Vector3& kRV) const
{
	Vector3 v = *this;

	v.Add(kRV);

	return v;
}

/// -Zqł̌Z\
Vector3 Vector3::operator- (const Vector3& kRV) const
{
	Vector3 v = *this;

	v.Subtract(kRV.mX, kRV.mY, kRV.mZ);

	return v;
}

/// *Zqł̏Z\
Vector3 Vector3::operator* (volatile const Vector3& kRV) const
{
	Vector3 v = *this;

	v.Multiply(kRV);

	return v;
}


/// /Zqł̏Z\
Vector3 Vector3::operator/ (const Vector3& kRV) const
{
	Vector3 v = *this;

	v.Divide(kRV);

	return v;
}

/// /Zqł̏Z\
Vector3 Vector3::operator/ (float d) const
{
	Vector3 v = *this;

	v.Divide(d);

	return v;
}


/// +=Zqł̉Z\
void Vector3::operator+= (const Vector3& kRV)
{
	Add(kRV);
}

/// -=Zqł̌Z\
void Vector3::operator-= (const Vector3& kRV)
{
	Subtract(kRV);
}

/// *=Zqł̏Z\
void Vector3::operator*= (const Vector3& kRV)
{
	Multiply(kRV);
}

/// /=Zqł̏Z\
void Vector3::operator/= (const Vector3& kRV)
{
	Divide(kRV);
}

/// YZq[]ł̒l擾\
float& Vector3::operator[] (int index)
{
	// CfbNXŕ
	switch (index)
	{
		// 0Ȃ
		case 0:		return mX;

		// 1Ȃ
		case 1:		return mY;

		// 2Ȃ
		case 2:		return mZ;

		// ȊOȂ
		default:

			// HALT:ȓYwȂ̂Ŏ
			HALT(_T("Vector3ɑ΂YsłB^ꂽÝw%dxłB"), index);

			break;
	}

	// MEMO:QƕԂȂ̂ŃoϐԂKv܂B
	return mX;
}


#ifdef _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// o
void Vector3::DebugOutput() const
{
	PFL(_T("Vector3(% f, % f, % f)"), mX, mY, mZ);
}

/// o
void Vector3::DebugRender(int x, int y) const
{
	DP(x, y, 0xffffffff, _T("Vector3(% f, % f, % f)"), mX, mY, mZ);
}

#endif // _DEBUG


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// (0, 0, 0)
const Vector3 Vector3::mStKZero(0, 0, 0);

/// (1, 0, 0)
const Vector3 Vector3::mStKUnitX(1, 0, 0);

/// (0, 1, 0)
const Vector3 Vector3::mStKUnitY(0, 1, 0);

/// (0, 0, 1)
const Vector3 Vector3::mStKUnitZ(0, 0, 1);

/// (1, 1, 1)
const Vector3 Vector3::mStKOne(1, 1, 1);
