#include "Blast/Base/Timer.h"

using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Timer::Timer()
{
	mStartTime = 0;
	mEndTime = 0;
}

/// fXgN^
Timer::~Timer()
{
}


/// vJn
void Timer::Start(const TCHAR* kPMarkName)
{
	// }[Nێ
	mMarkNameStr = kPMarkName;

	// JntO𗧂Ă
	mIsStarting = true;

	// ݂̎ԂJnԂƂă}[N
	mStartTime = clock();
}

/// vI
void Timer::End()
{
	// ASSERT:StartĂłȂȂ痎Ƃ܂B
	ASSERT_PRINTF(mIsStarting, _T("StartĂ΂Ă܂B"));


	mIsStarting = false;

	// ݂̎ԂIԂƂă}[N
	mEndTime = clock();
}


/// vʂ擾
clock_t Timer::GetSpan() const
{
	// 
	clock_t result = 0;

	// IԂJnԂĂȂ
	if (mStartTime < mEndTime)
	{
		result = mEndTime - mStartTime;
	}

	return result;
}


/// bv^C擾
clock_t Timer::GetLapTime() const
{
	// ݂̎Ԃ擾
	clock_t currentTime = clock();

	// ݎԂJnԂĂȂ
	if (mStartTime < currentTime)
	{
		return (currentTime - mStartTime);
	}

	return 0;
}

/// bv^Co
void Timer::OutputLapTime(const TCHAR* kPLapName) const
{
	// o̓tH[}bg
	static const TCHAR* const kPFormat = _T("\"%s\"}[N%sbv^CF%ld[ms]");

	// bvȂ
	if (kPLapName)
	{
		PFL(kPFormat, mMarkNameStr.c_str(), kPLapName, GetLapTime());
	}
	// bvȂȂ
	else
	{
		PFL(kPFormat, mMarkNameStr.c_str(), _T(""), GetLapTime());
	}
}


/// vʂo
void Timer::OutputResult() const
{
	PFL(_T("\"%s\"}[ŇvʁF%ld[ms]"), mMarkNameStr.c_str(), Timer::GetSpan());
}
