#include "Blast/Graphic/DirectX9/SpriteDX9.h"

#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/DirectX9/MeshSpriteDX9.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Storage/Directory.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Storage;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SpriteDX9::SpriteDX9()
{
	ResourceManager* pRM = ResourceManager::GetInstance();


	// bV쐬
	mPMesh = SP<MeshSpriteDX9>(NEW MeshSpriteDX9());

	// VF[_[쐬
	const TCHAR* const kPShaderFilePath = ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_SPRITE2D);
	mPShaderEffect = pRM->Load<ShaderEffectDX9>(kPShaderFilePath);

#if _DEBUG
	// C[t[\Ă
	mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME);
#endif // _DEBUG


	// 
	Initialize();
}

/// fXgN^
SpriteDX9::~SpriteDX9()
{
}


/// 
void SpriteDX9::Initialize()
{
	mScale = Vector2::One();
	mPosition = Vector3::Zero();
	mRotation = Vector3::Zero();

	mWorld.Identity();

	// MEMO:ݒ肵ȂĂlĂ܂B
	mSize = Vector2::One() * 256.0f;
	mOrigin = Vector2::Zero();
	mColor = ColorCode::ToCode(ColorCode::eCOLOR_WHITE);

	// MEMO:ݒ肵ȂĂ\͂悤ȒlĂ܂B
	mSourceRectangle.Initialize();
	mSourceRectangle.SetWidth(mSize.mX);
	mSourceRectangle.SetHeight(mSize.mY);

	mUVMatrix.Identity();
}

/// XV
void SpriteDX9::Update(float delta)
{
	// [hsXV
	UpdateWorldMatrix();

	// eNX`ȂAUVϊsXV
	if (mPTexture)
	{
		UpdateUIMatrix();
	}
}

/// `
void SpriteDX9::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// ʕϐɐ錾
	HRESULT hr = S_OK;


	// [hϊsݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &MathHelperDX::ToD3DXMATRIX(mWorld));

	// JȂAr[ƎˉeȂǂ̕ϊsݒ
	ASSERT_PRINTF(mPCamera, _T("Jݒ肳Ă܂B"));
	if (mPCamera)
	{
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetViewMatrixRef()));
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetProjectionMatrixRef()));
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEWPORT, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetViewportMatrixRef()));
	}
	// JȂ
	else
	{
		// Pʍsݒ
		D3DXMATRIX mat;
		D3DXMatrixIdentity(&mat);

		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mat);
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mat);
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEWPORT, &mat);
	}

	// VF[_[ϐUVϊsݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_UV_TRANSFORM, &MathHelperDX::ToD3DXMATRIX(mUVMatrix));


	// ݒ
	mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, mColor.GetArray(), Color::mStKColorFactorCount - 1);

	// fBt[YJ[ɐݒ肷̂Ó̂͂AɊŏĂ̂łbŎcĂ
	mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_DIFFUSE_COLOR, mColor.GetArray(), Color::mStKColorFactorCount - 1);


	// VF[_[ϐɃeNX`ݒ
	Texture2DDX9* pTexture = dynamic_cast<Texture2DDX9*>(mPTexture.GetSource());
	if (pTexture)
	{
		mPShaderEffect->SetTexture(ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE, pTexture->GetTexturePtrRef().GetInterface());
	}

	
	// `Jn
	bool isBegan = mPShaderEffect->IsBegan();
	if (isBegan)
	{
		// bV̕`
		mPShaderEffect->CommitChanges();
		mPMesh->Render();
	}
	else
	{
		unsigned passCount = 0;
		mPShaderEffect->Begin(&passCount, 0);
		for (int i = 0; i < (int)passCount; ++i)
		{
			mPShaderEffect->BeginPass(i);

			// CommitChanges̓pXŕύXꂽlɑ΂ėLȂ̂ŁAɕύXł͖Ă
			//// ύXm
			//mPShaderEffect->CommitChanges();

			// bV̕`
			mPMesh->Render();

			mPShaderEffect->EndPass();
		}
		mPShaderEffect->End();
	}
}


/// TCYeNX`TCYɑ
void SpriteDX9::FitTextureSize()
{
	// eNX`Ȃ
	ASSERT_PRINTF(mPTexture.GetSource(), _T("eNX`ݒ肳Ă܂B"));
	if (mPTexture.GetSource())
	{
		Float32 width = static_cast<float>(mPTexture->GetWidth());
		Float32 height = static_cast<float>(mPTexture->GetHeight());

		SetSize(width, height);
	}
}

/// öeNX`TCYɑ
void SpriteDX9::FitTextureSourceRectangle()
{
	// eNX`Ȃ
	ASSERT_PRINTF(mPTexture.GetSource(), _T("eNX`ݒ肳Ă܂B"));
	if (mPTexture.GetSource())
	{
		Float32 width = static_cast<float>(mPTexture->GetWidth());
		Float32 height = static_cast<float>(mPTexture->GetHeight());

		SetSourceRectangle(0, 0, width, height);
	}
}


/// Jݒ
void SpriteDX9::SetCamera(SP<ICamera> pCamera)
{
	mPCamera = pCamera;
}


/// eNX`擾
SP<ITexture2D> SpriteDX9::GetTexture()
{
	return mPTexture;
}

/// eNX`擾
const SP<ITexture2D> SpriteDX9::GetTexture() const
{
	return mPTexture;
}

/// eNX`ݒ
void SpriteDX9::SetTexture(SP<ITexture2D> pTexture)
{
	mPTexture = pTexture;
}


/// TCY擾
Vector2& SpriteDX9::GetSize()
{
	return mSize;
}

/// TCY擾
const Vector2& SpriteDX9::GetSize() const
{
	return mSize;
}

/// TCYݒ
void SpriteDX9::SetSize(float width, float height)
{
	mSize.mX = width;
	mSize.mY = height;
}

/// TCYݒ
void SpriteDX9::SetSize(const Vector2& kRSize)
{
	mSize = kRSize;
}


/// öݒ
void SpriteDX9::SetSourceRectangle(float topX, float topY, float bottomX, float bottomY)
{
	mSourceRectangle.mTopX = topX;
	mSourceRectangle.mTopY = topY;
	mSourceRectangle.mBottomX = bottomX;
	mSourceRectangle.mBottomY = bottomY;
}

/// öݒ
void SpriteDX9::SetSourceRectangle(const Blast::Math::Vector2& kRLeftTop, const Blast::Math::Vector2& kRRightBottom)
{
	SetSourceRectangle(kRLeftTop.mX, kRLeftTop.mY, kRRightBottom.mX, kRRightBottom.mY);
}


/// ʒu擾
const Vector3& SpriteDX9::GetPosition() const
{
	return mPosition;
}

/// ʒu擾
Vector3& SpriteDX9::GetPosition()
{
	return mPosition;
}

/// ʒuݒ
void SpriteDX9::SetPosition(float x, float y, float z)
{
	mPosition.mX = x;
	mPosition.mY = y;
	mPosition.mZ = z;
}

/// ʒuݒ
void SpriteDX9::SetPosition(const Vector3& kRPosition)
{
	SetPosition(kRPosition.mX, kRPosition.mY, kRPosition.mZ);
}

/// ړ
void SpriteDX9::Move(float x, float y, float z)
{
	mPosition.mX += x;
	mPosition.mY += y;
	mPosition.mZ += z;
}

/// ړ
void SpriteDX9::Move(const Vector3& kRMove)
{
	Move(kRMove.mX, kRMove.mY, kRMove.mZ);
}


/// gk擾
const Vector2& SpriteDX9::GetScale() const
{
	return mScale;
}

/// gk擾
Vector2& SpriteDX9::GetScale()
{
	return mScale;
}

/// gkݒ
void SpriteDX9::SetScale(float x, float y)
{
	mScale.mX = x;
	mScale.mY = y;
}

/// gkݒ
void SpriteDX9::SetScale(const Vector2& kRScale)
{
	SetScale(kRScale.mX, kRScale.mY);
}

/// gk
void SpriteDX9::Scaling(float x, float y)
{
	mScale.mX += x;
	mScale.mY += y;
}

/// gk
void SpriteDX9::Scaling(const Vector2& kRScale)
{
	Scaling(kRScale.mX, kRScale.mY);
}


/// ]l擾
const Vector3& SpriteDX9::GetRotation() const
{
	return mRotation;
}

/// ]l擾
Vector3& SpriteDX9::GetRotation()
{
	return mRotation;
}

/// ]lݒ
void SpriteDX9::SetRotation(float x, float y, float z)
{
	mRotation.mX = x;
	mRotation.mY = y;
	mRotation.mZ = z;
}

/// ]lݒ
void SpriteDX9::SetRotation(const Vector3& kRRotation)
{
	SetRotation(kRRotation.mX, kRRotation.mY, kRRotation.mZ);
}

/// ]
void SpriteDX9::Rotate(float x, float y, float z)
{
	mRotation.mX += x;
	mRotation.mY += y;
	mRotation.mZ += z;
}

/// ]
void SpriteDX9::Rotate(const Vector3& kRRotation)
{
	Rotate(kRRotation.mX, kRRotation.mY, kRRotation.mZ);
}


/// _擾
const Vector2& SpriteDX9::GetOrigin() const
{
	return mOrigin;
}

/// _擾
Vector2& SpriteDX9::GetOrigin()
{
	return mOrigin;
}

/// _ݒ
void SpriteDX9::SetOrigin(float x, float y)
{
	mOrigin.mX = x;
	mOrigin.mY = y;
}

/// _ݒ
void SpriteDX9::SetOrigin(const Vector2& kROrigin)
{
	SetOrigin(kROrigin.mX, kROrigin.mY);
}

/// _ݒ
void SpriteDX9::SetOrigin(EOrigin eOrigin)
{
	Vector2 origin;
	const Vector2 kHalfSize = mSize * 0.5f;

	// _̎ނŕB
	// ł̐ݒ̓XN[Wł͂Ȃ[hWł邱ƂɗӁB
	switch (eOrigin)
	{
		case eORIGIN_UP_LEFT:		origin = Vector2(-kHalfSize.mX,	-kHalfSize.mY);	break;
		case eORIGIN_UP_CENTER:		origin = Vector2(0,				-kHalfSize.mY);	break;
		case eORIGIN_UP_RIGHT:		origin = Vector2(kHalfSize.mX,	-kHalfSize.mY);	break;
		case eORIGIN_LEFT:			origin = Vector2(-kHalfSize.mX,	0);				break;
		case eORIGIN_CENTER:		origin = Vector2::Zero();						break;
		case eORIGIN_RIGHT:			origin = Vector2(kHalfSize.mX,	0);				break;
		case eORIGIN_DOWN_LEFT:		origin = Vector2(-kHalfSize.mX,	kHalfSize.mY);	break;
		case eORIGIN_DOWN:			origin = Vector2(0,				kHalfSize.mY);	break;
		case eORIGIN_DOWN_RIGHT:	origin = Vector2(kHalfSize.mX,	kHalfSize.mY);	break;
		default:	break;
	};

	SetOrigin(origin);
}


/// _ړ
void SpriteDX9::MoveOrigin(float x, float y)
{
	mOrigin.mX += x;
	mOrigin.mY += y;
}

/// _ړ
void SpriteDX9::MoveOrigin(const Vector2& kRMoveOrigin)
{
	mOrigin += kRMoveOrigin;
}


/// UVWړ
void SpriteDX9::MoveUV(float moveU, float moveV)
{
	// eNX`Ȃ
	if (mPTexture.GetSource())
	{
		// eNX`̃TCY擾
		int texWidth = mPTexture->GetWidth();
		int texHeight = mPTexture->GetHeight();

		// UV̈ړʂZo
		float shiftU = moveU * texWidth;
		float shiftV = moveV * texHeight;

		// ̈ϓ
		mSourceRectangle.ShiftXY(shiftU, shiftV);
	}
}

/// UVWړ
void SpriteDX9::MoveUV(const Blast::Math::Vector2& kRUV)
{
	MoveUV(kRUV.mX, kRUV.mY);
}


/// [hsXV
void SpriteDX9::UpdateWorldMatrix()
{
	// MEMO:PʒlȂ̂Ŋgsŕ₦܂B
	// TCYɍ킹ׂ̍s쐬
	Matrix sizeMat;
	sizeMat.CreateScale(mSize.mX, mSize.mY, 1);

	// MEMO:l͋tɂ܂B
	// _ړs쐬
	Matrix centerMat;
	centerMat.CreateTranslate(-mOrigin.mX, -mOrigin.mY, 0);

	// gks쐬
	Matrix scaleMat;
	scaleMat.CreateScale(mScale.mX, mScale.mY, 1);

	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(mRotation);

	// sړs쐬
	Matrix transMat;
	transMat.CreateTranslate(mPosition);


	// [hsXV
	mWorld = sizeMat
		* centerMat
		* scaleMat
		* rotMat
		* transMat;
}

/// UVϊsXV
void SpriteDX9::UpdateUIMatrix()
{
	// eNX`̉Ac擾
	Int32 texWidth = mPTexture->GetWidth();
	Int32 texHeight = mPTexture->GetHeight();
	float texWidthF = static_cast<float>(texWidth);
	float texHeightF = static_cast<float>(texHeight);


	/* ö̃eNX`͈͊O */

	// XWeNX`̉𒴂Ȃ
	if (texWidth < mSourceRectangle.mTopX)
	{
		mSourceRectangle.ShiftX(-texWidthF);
	}
	// YWeNX`̏c𒴂Ȃ
	else if (texHeight < mSourceRectangle.mTopY)
	{
		mSourceRectangle.ShiftY(-texHeightF);
	}

	// EXW[Ȃ
	if (mSourceRectangle.mBottomX < 0)
	{
		mSourceRectangle.ShiftX(texWidthF);
	}
	// EYW[Ȃ
	else if (mSourceRectangle.mBottomY < 0)
	{
		mSourceRectangle.ShiftY(texHeightF);
	}


	/* UVϊsXV*/

	// ö̕S
	float scaleWidthRatio = mSourceRectangle.GetWidth() / texWidth;
	float scaleHeightRatio = mSourceRectangle.GetHeight() / texHeight;

	// UVgks쐬
	Matrix uvScaleMat;
	uvScaleMat.CreateScaleUV(scaleWidthRatio, scaleHeightRatio);


	// MEMO:ł͈Ă܂B
	// UV]s쐬
	Matrix uvRotMat;
	uvRotMat.CreateRotationUV(0.0f);


	// MEMO:̈̍p̈ʒuňړ܂B
	// ö̈ʒuS
	float transXRatio = mSourceRectangle.mTopX / texWidth;
	float transYRatio = mSourceRectangle.mTopY / texHeight;

	// UVsړs쐬
	Matrix uvTransMat;
	uvTransMat.CreateTranslateUV(transXRatio, transYRatio);


	// UVϊsXV
	mUVMatrix = uvScaleMat * uvRotMat * uvTransMat;
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// `tO擾
bool SpriteDX9::IsVisible()
{
	return mIsVisible;
}

/// `tOݒ
void SpriteDX9::SetVisible(bool value)
{
	mIsVisible = value;
}


#if _DEBUG
//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// \
void SpriteDX9::DebugRender(int x, int y) const
{
	// 1C̏c
	const int kLineHeight = 15;

	// CCfbNX
	int lineIndex = 0;


	// [hs`
	DP(x, y, 0xff00ff00, _T("<[hs>"));
	++lineIndex;
	mWorld.DebugRender(x, y + kLineHeight * lineIndex);
	lineIndex += 5;
}

/// o
void SpriteDX9::DebugOutput() const
{
	// ʒuo
	PF(_T("ʒu:"));
	mPosition.DebugOutput();

	// ]lo
	PF(_T("]l:"));
	mRotation.DebugOutput();

	// gko
	PF(_T("gk:"));
	mScale.DebugOutput();


	// _o
	PF(_T("_:"));
	mOrigin.DebugOutput();


	// eNX`̃X}[g|C^o
	mPTexture.DebugOutputSmartPointer();


	// TCYo
	PF(_T("TCY:"));
	mSize.DebugOutput();

	// öo
	PFL(_T("[ö]"));
	mSourceRectangle.DebugOutput();



	// ADD:ɂFX


}
#endif // _DEBUG
