#include "Blast/Graphic/SkeletonFbx.h"

#include "Blast/String/StringHelper.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Math;
using namespace Blast::Graphic;
using namespace Blast::String;

#define DUMP_SKELETON_FBX 0


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* {[ */

/// RXgN^
SkeletonFbx::SBone::SBone()
{
	mBindPoseMatrix.Identity();
	mCurrentPoseMatrix.Identity();
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SkeletonFbx::SkeletonFbx() :
mPFbxSdkManager(NULL),
mPDeformer(NULL),
mPSkin(NULL),
mBoneCount(-0)
{
	// KFbxSdkManager쐬
	mPFbxSdkManager = KFbxSdkManager::Create();

	// KFbxIOSettings쐬Aݒ
	KFbxIOSettings* pFbxIOSettings = KFbxIOSettings::Create(mPFbxSdkManager, IOSROOT);
	mPFbxSdkManager->SetIOSettings(pFbxIOSettings);
}

/// fXgN^
SkeletonFbx::~SkeletonFbx()
{
	// FBXSDKj
	mPFbxSdkManager->Destroy();
}


/// ǂݍ
bool SkeletonFbx::Load(const TCHAR* kPFullPath)
{
	// C|[^[쐬
	KFbxImporter* pFbxImporter = KFbxImporter::Create(mPFbxSdkManager, "Importer");

#ifdef UNICODE
	// pXCHAR^ɕϊ
	CHAR fullPath[StringHelper::mStKDefaultBufferSize];
	StringHelper::ToMultiByteChar(fullPath, sizeof(fullPath), kPFullPath);

	// C|[^[
	bool isSuceededImporterInitialize = pFbxImporter->Initialize(fullPath, -1, mPFbxSdkManager->GetIOSettings());
#else
	// C|[^[
	bool isSuceededImporterInitialize = pFbxImporter->Initialize(kPFullPath, -1, mPFbxSdkManager);
#endif // UNICODE

	// ASSERT:C|[^[̏ɎsȂ玀B
	ASSERT_PRINTF(isSuceededImporterInitialize, _T("KFbxImporteȑɎs܂B\nPath=%s\n%s"), kPFullPath, pFbxImporter->GetLastErrorString());

	// C|[^[̏ɎsȂ
	if (!isSuceededImporterInitialize)
	{
		return false;
	}


	// V[̍쐬
	KFbxScene* pFbxScene = KFbxScene::Create(mPFbxSdkManager, "Scene");

	// ASSERT:V[̍쐬ɎsȂ玀
	ASSERT_PRINTF(pFbxScene, _T("KFbxScene̍쐬Ɏs܂B"));
	
	// V[̍쐬ɎsȂ
	if (!pFbxScene)
	{
		return false;
	}


	// C|[g
	bool isSucceededImporterImport = pFbxImporter->Import(pFbxScene);

	// ASSERT:C|[gɎsȂ玀B
	ASSERT_PRINTF(isSucceededImporterImport, _T("C|[gɎs܂B"));

	// C|[gɎsȂ
	if (!isSucceededImporterImport)
	{
		return false;
	}
	

	// [gm[h擾
	KFbxNode* pRootNode = pFbxScene->GetRootNode();
	
	// bVm[h擾
	KFbxMesh* pMesh = NULL;
	FindMeshNode(pRootNode, &pMesh);


	// ftH[}[̐擾
	const int kDeformerCount = pMesh->GetDeformerCount(KFbxDeformer::eSKIN);
	PFL(_T("ftH[}[̐=%d"), kDeformerCount);

	// ftH[}[Ȃ
	if (kDeformerCount <= 0)
	{
		return false;
	}

	// MEMO:擪̃ftH[}[擾܂B
	// ftH[}[擾
	const int kTopDeformerIndex = 0;
	KFbxDeformer* pDeformer = pMesh->GetDeformer(kTopDeformerIndex, KFbxDeformer::eSKIN);

	mPDeformer = pDeformer;

	// XLɃLXg
	KFbxSkin* pSkin = KFbxCast<KFbxSkin>(pDeformer);

	mPSkin = pSkin;


	// NX^擾
	const int kClusterCount = pSkin->GetClusterCount();
	PFL(_T("NX^=%d"), kClusterCount);

	// ASSERT:pӂĂ{[zNX^Ȃ玀
	ASSERT_PF(kClusterCount <= mStKMaxBoneCount, _T("pӍς݂̃{[Af̃NX^łB\npӍς݃{[=%d, NX^=%d"), mStKMaxBoneCount, kClusterCount);

	// NX^z쐬
	mPClusters.SetPointer(NEW KFbxCluster*[kClusterCount], true);

#if _DEBUG && DUMP_SKELETON_FBX
	// NX^̐Ń[v
	for (int i = 0; i < kClusterCount; ++i)
	{
		// NX^擾
		const KFbxCluster* kPCluster = pSkin->GetCluster(i);
		PFL(_T("NX^[%d]"), i);

		mPClusters[i] = pSkin->GetCluster(i);


		// e^钸_o
		const int kPointIndicesCount = kPCluster->GetControlPointIndicesCount();
		PFL(_T("\te^钸_=%d"), kPointIndicesCount);

		// CfbNXz擾
		const int* kPPointIndices = kPCluster->GetControlPointIndices();

		// EFCgz擾
		const double* kPPointWeights = kPCluster->GetControlPointWeights();

		// CfbNXƃEFCg̔zo
		for (int j = 0; j < kPointIndicesCount; ++j)
		{
			const int kIndex = kPPointIndices[j];
			const double kWeight = kPPointWeights[j]; 
			PFL(_T("\t\t_CfbNX[% 3d]=%d, EFCg=%lf"), j, kIndex, kWeight);
		}
	}
#endif // _DEBUG && DUMP_SKELETON_FBX


	// MEMO:oϐp
	// NX^̓Izp
	KFbxCluster** pClusters = NEW KFbxCluster*[kClusterCount];
	mPClusters.SetPointer(NEW KFbxCluster*[kClusterCount], true);

	// NX^̐Ń[v
	for (int i = 0; i < kClusterCount; ++i)
	{
		// MEMO:oϐɂ擾
		// NX^擾
		pClusters[i] = pSkin->GetCluster(i);
		mPClusters[i] = pSkin->GetCluster(i);
	}


	// |S擾
	const int kPolygonCount = pMesh->GetPolygonCount();
	PFL(_T("|S=%d"), kPolygonCount);

	// MEMO:Op`|Sł邱ƂOłB
	// 1|S̒_擾
	const int kVertexCountByPolygon = 3;
	PFL(_T("1|S̒_iߑłj=%d"), kVertexCountByPolygon);

	// CfbNX̐
	const int kIndexCount = kPolygonCount * kVertexCountByPolygon;
	PFL(_T("CfbNX̐=%d"), kIndexCount);

	// CfbNXz擾
	const int* kPVertexIndices = pMesh->GetPolygonVertices();
	for (int i = 0; i < kIndexCount; i += 3)
	{
		const int kVertexIndex0 = kPVertexIndices[i + 0];
		const int kVertexIndex1 = kPVertexIndices[i + 1];
		const int kVertexIndex2 = kPVertexIndices[i + 2];

#if _DEBUG && DUMP_SKELETON_FBX
		PFL(_T("CfbNX[% 3d, % 3d, % 3d]=% 3d, % 3d, % 3d"), i, i + 1, i + 2, kVertexIndex0, kVertexIndex1, kVertexIndex2);
#endif // _DEBUG && DUMP_SKELETON_FBX
	}


	// {[CfbNXz쐬
	SP<VertexBufferDX9::SBoneIndex> pSBoneIndices(NEW VertexBufferDX9::SBoneIndex[kIndexCount], true);
	ZeroMemory(pSBoneIndices.GetSource(), sizeof(VertexBufferDX9::SBoneIndex) * kIndexCount);

	// {[EFCgz𓮓I쐬
	SP<VertexBufferDX9::SBoneWeight> pSBoneWeights(NEW VertexBufferDX9::SBoneWeight[kIndexCount], true);
	ZeroMemory(pSBoneWeights.GetSource(), sizeof(VertexBufferDX9::SBoneWeight) * kIndexCount);


	// 1_ɑł{[̐
	const int kMaxVertexBoneCount = VertexBufferDX9::mStKMaxInfluenceBoneCount;

	// {[̔z
	SP<int> pApplyCounts(NEW int[kIndexCount], true);
	ZeroMemory(pApplyCounts.GetSource(), sizeof(int) * kIndexCount);


	// |SŃ[v
	for (int i = 0; i < kPolygonCount; ++i)
	{
		// 1|S̒_Ń[v
		for (int j = 0; j < kVertexCountByPolygon; ++j)
		{
			// [vCfbNX
			const int kLoopIndex = i * kVertexCountByPolygon + j;

			// QƐ撸_CfbNX
			const int kRefVertexIndex = kPVertexIndices[kLoopIndex];


			// NX^̐Ń[v
			for (int k = 0; k < kClusterCount; ++k)
			{
				// Q
				KFbxCluster& rCluster = *pClusters[k];


				// e^钸_CfbNX̐擾
				const int kPointIndicesCount = rCluster.GetControlPointIndicesCount();

				// e^钸_CfbNXz擾
				const int* kPPointIndices = rCluster.GetControlPointIndices();

				// EFCgz擾
				const double* kPPointWeights = rCluster.GetControlPointWeights();


				// e^钸_CfbNX̐Ń[v
				for (int l = 0; l < kPointIndicesCount; ++l)
				{
					const int kPointIndex = kPPointIndices[l];
					const double kPointWeight = kPPointWeights[l];

					// CfbNXvȂ
					if (kRefVertexIndex == kPointIndex)
					{
						const int kAssignIndex = i * kVertexCountByPolygon + j;


						// {[CfbNXQ
						VertexBufferDX9::SBoneIndex& rSBoneIndices = pSBoneIndices[kAssignIndex];

						// {[EFCgQ
						VertexBufferDX9::SBoneWeight& rSBoneWeights = pSBoneWeights[kAssignIndex];


						// ς݂̐擾
						const int kApplyCount = pApplyCounts[kAssignIndex];

						// ς݂̐e𒴂ĂȂȂ
						if (kApplyCount < kMaxVertexBoneCount)
						{
							rSBoneIndices.mIndices[kApplyCount] = k;
							rSBoneWeights.mWeights[kApplyCount] = static_cast<float>(kPointWeight);

#if _DEBUG && DUMP_SKELETON_FBX
							PFL(_T("\t[%d][%d]ڂ֑BCfbNX=%d, EFCg=%lf"), kAssignIndex, kApplyCount, k, kPointWeight);
#endif // _DEBUG && DUMP_SKELETON_FBX

							++pApplyCounts[kAssignIndex];
						}
						else
						{
							WARNING(NULL, _T("1_ɉe{[̐4𒴂Ă܂B"));
						}
					}
				}
			}
		}
	}

#if _DEBUG && DUMP_SKELETON_FBX
	PFL(_T("@{[̌ʁ@"));

	// CfbNX̐Ń[v
	for (int i = 0; i < kIndexCount; ++i)
	{
		// Q
		const VertexBufferDX9::SBoneIndex& kRSBoneIndex = pSBoneIndices[i];
		const VertexBufferDX9::SBoneWeight& kRSBoneWeight = pSBoneWeights[i];

		PFL(_T("\t[%d]"), i);

		// {[o
		for (int j = 0; j < VertexBufferDX9::mStKMaxInfluenceBoneCount; ++j)
		{
			const unsigned kBoneIndex = kRSBoneIndex.mIndices[j];
			const double kBoneWeight = kRSBoneWeight.mWeights[j];

			// EFCg0ȏȂ
			if (0 < kBoneWeight)
			{
				PFL(_T("\t\tCfbNX[%3d]=%3d, EFCg=%lf"), j, kBoneIndex, kBoneWeight);
			}
		}
	}
#endif // _DEBUG && DUMP_SKELETON_FBX


	// o[ebNXobt@쐬
	for (int i = 0; i < eVERTEXBUFFER_COUNT; ++i)
	{
		mPVertexBuffers[i].SetPointer(NEW VertexBufferDX9());
	}

	// {[CfbNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->SetVertices(pSBoneIndices.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SBoneIndex) * kIndexCount);

	// {[EFCgobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->SetVertices(pSBoneWeights.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SBoneWeight) * kIndexCount);


	// EZ-UpnY-Upnɂs쐬
	Matrix coodinateConvert = MathHelper::CreateZUpRHToYUpLH();


	//NX^̐Ń[v
	for (int i = 0; i < kClusterCount; ++i)
	{
		// Q		
		KFbxCluster& rCluster = *pClusters[i];
		SBone& rSBone = mSBones[i];


		// oCh|[Ys擾
		KFbxXMatrix bindPoseMatrix;
		rCluster.GetTransformLinkMatrix(bindPoseMatrix);

		// oCh|[Ysϊ
		MathHelper::ToMatrix(bindPoseMatrix, &rSBone.mBindPoseMatrix);


		// n̕ϊsǉZ
		rSBone.mBindPoseMatrix *= coodinateConvert;
	}


	// {[ێ
	mBoneCount = kClusterCount;


	// Iz
	SAFE_DELETE_ARRAY(pClusters);


	return true;
}


/// XV
void SkeletonFbx::Update(float delta)
{
}


/// {[CfbNXobt@擾
SP<VertexBufferDX9> SkeletonFbx::GetBoneIndexVertexBuffer()
{
	return mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX];
}

/// {[CfbNXobt@擾
const SP<VertexBufferDX9> SkeletonFbx::GetBoneIndexVertexBuffer() const
{
	return mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX];
}


/// {[EFCgobt@擾
SP<VertexBufferDX9> SkeletonFbx::GetBoneWeightVertexBuffer()
{
	return mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT];
}

/// {[EFCgobt@擾
const SP<VertexBufferDX9> SkeletonFbx::GetBoneWeightVertexBuffer() const
{
	return mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT];
}


/// {[̐擾
int SkeletonFbx::GetBoneCount() const
{
	return mBoneCount;
}


/// NX^z擾
const SP<KFbxCluster*> SkeletonFbx::GetClusters() const
{
	return mPClusters;
}

/// NX^z擾
SP<KFbxCluster*> SkeletonFbx::GetClusters()
{
	return mPClusters;
}


/// NX^擾
const KFbxCluster* SkeletonFbx::GetClusterPtr(int index) const
{
	return mPClusters[index];
}

/// NX^擾
KFbxCluster* SkeletonFbx::GetClusterPtr(int index)
{
	return mPClusters[index];
}


/// {[z擾
const SkeletonFbx::SBone* SkeletonFbx::GetBones() const
{
	return mSBones;
}

/// {[z擾
SkeletonFbx::SBone* SkeletonFbx::GetBones()
{
	return mSBones;
}

/// {[擾
const SkeletonFbx::SBone& SkeletonFbx::GetBone(int index) const
{
	return mSBones[index];
}

/// {[擾
SkeletonFbx::SBone& SkeletonFbx::GetBone(int index)
{
	return mSBones[index];
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// bVm[h擾
void SkeletonFbx::FindMeshNode(KFbxNode* pNode, KFbxMesh** pOut)
{
	// Agr[g̐Ń[v
	const int kAttributeCount = pNode->GetNodeAttributeCount();
	for (int i = 0; i < kAttributeCount; ++i)
	{
		// Agr[g擾
		KFbxNodeAttribute* pAttribute = pNode->GetNodeAttributeByIndex(i);
		KFbxNodeAttribute::EAttributeType eType = pAttribute->GetAttributeType();

		// bVȂ
		if (eType == KFbxNodeAttribute::eMESH)
		{
			// LXg
			KFbxMesh* pMesh = static_cast<KFbxMesh*>(pAttribute);

			// o͕ϐɑ
			*pOut = pMesh;

			return;
		}
	}

	// q̐Ń[v
	const int kChildCount = pNode->GetChildCount();
	for (int i = 0; i < kChildCount; ++i)
	{
		// q擾
		KFbxNode* pChild = pNode->GetChild(i);

		// qŌ
		FindMeshNode(pChild, pOut);

		if (pOut)
		{
			return;
		}
	}
}
