#include "Blast/Base/SequenceManager.h"

#include "Blast/Base/ISequence.h"

using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SequenceManager::SequenceManager()
{
}

/// fXgN^
SequenceManager::~SequenceManager()
{
}

/// 
void SequenceManager::HandleInput(float delta)
{
	// V[PXȂȂ珈Kv͂Ȃ
	if (mSequences.empty())
	{
		return;
	}


	// MEMO:ŌɒǉꂽV[PX݂̂

	// ͏Ăт
	SP<ISequence> pSeq = mSequences.back();
	ASSERT_PF(pSeq, _T("V[PX܂B"));
	if (pSeq)
	{
		pSeq->HandleInput(delta);
	}
}

/// XV
void SequenceManager::Update(float delta)
{
	// V[PXȂȂ珈Kv͂Ȃ
	if (mSequences.empty())
	{
		return;
	}


	// ŌɒǉꂽV[PX݂̂XV
	// A|bvAbv̏ꍇ͈ÕV[PXXV

	// tŃ[verase\bhgȂB
	// ܂AIĂV[PX͏ÔŁAꎞϐ͎g킸oϐtɑB

	const int kSequenceCount = mSequences.size();
	int seqIndex = kSequenceCount - 1;
	while (0 <= seqIndex)
	{
		SP<ISequence> pSeq = mSequences.at(seqIndex);

		// XVĂ
		if (pSeq->IsEnable())
		{
			pSeq->Update(delta);
		}

		// IĂԑOɐɕKvȏ𔲂Ă
		bool isExit = pSeq->IsExit();
		bool isPopup = pSeq->IsPopUp();

		// I͏Ă񂾌ɃXg珜O
		if (isExit)
		{
			pSeq->Finalize();

			Sequences::iterator it = mSequences.begin();
			std::advance(it, seqIndex);
			mSequences.erase(it);
		}

		// |bvAbv̏ꍇ͈̃V[PXXVcontinue
		if (isPopup)
		{
			--seqIndex;
			continue;
		}

		break;
	}
}

/// `
void SequenceManager::Render()
{
	// V[PXȂȂ珈Kv͂Ȃ
	if (mSequences.empty())
	{
		return;
	}


	// ŌɒǉꂽV[PX݂̂`悷B
	// A|bvAbv̏ꍇ1̃V[PX`悷B
	// ̏ꍇA|bvAbṽV[PX͌ɂȂ悤`揈ĂԁB

	// `悷V[PX擾
	Sequences renderSeqs;
	Sequences::reverse_iterator rit = mSequences.rbegin();
	while (rit != mSequences.rend())
	{
		// Xgɒǉ
		if ((*rit)->IsVisible())
		{
			renderSeqs.push_back(*rit);
		}

		// |bvAbvȂ玟
		if ((*rit)->IsPopUp())
		{
			++rit;
			continue;
		}
		
		break;
	}

	// Ԃɕ`
	rit = renderSeqs.rbegin();
	while (rit != renderSeqs.rend())
	{
		// `
		(*rit)->Render();

		++rit;
	}
}

/// V[PXǉ
void SequenceManager::AddSequence(SP<ISequence> pSequence)
{
	// 
	pSequence->Initialize();

	// ǉ
	mSequences.push_back(pSequence);
}

/// V[PXXgO
void SequenceManager::RemoveSequence(SP<ISequence> pSequence)
{
	// V[PX̐Ń[v
	Sequences::iterator it;
	for (it = mSequences.begin(); it != mSequences.end(); ++it)
	{
		// V[PXvȂ
		if ((*it).GetSource() == pSequence.GetSource())
		{
			mSequences.erase(it);

			return;
		}
	}
}

/// V[PX擾
SP<ISequence> SequenceManager::GetSequenceAt(int index)
{
	ASSERT_PF(0 <= index && index < GetSequenceCount(),
		_T("͈͊Ow肳Ă܂B\nV[PX̐=%d\nCfbNX=%d"), GetSequenceCount(), index);

	return mSequences.at(index);
}

/// V[PX擾
SP<ISequence> SequenceManager::GetSequence(int type)
{
	// ^CvvV[PXԂ
	Sequences::iterator it;
	for (it = mSequences.begin(); it != mSequences.end(); ++it)
	{
		if (type == (*it)->GetType())
		{
			return (*it);
		}
	}

	WARNING(NULL, _T("ʂ̌^V[PX擾ł܂łB\ntype=%d"), type);

	return SP<ISequence>();
}

/// V[PX̐擾
int SequenceManager::GetSequenceCount() const
{
	return mSequences.size();
}