#include "Blast/Graphic/DirectX9/PrimitiveModelDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
PrimitiveModelDX9::PrimitiveModelDX9() :
mColor(0xff888888),
mScale(Vector3::One()),
mRotation(Vector3::Zero()),
mPosition(Vector3::Zero())
{
	// VF[_[GtFNgǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShaderEffect = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_PRIMITIVE));

	// eNjbNݒ
	mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_LAMBERT);
}

/// fXgN^
PrimitiveModelDX9::~PrimitiveModelDX9()
{
}


/// XV
void PrimitiveModelDX9::Update(float delta)
{
}

/// `
void PrimitiveModelDX9::Render()
{
	// ASSERT:bVȂ玀
	ASSERT_PRINTF(mPMesh, _T("bVݒ肳Ă܂B"));

	// bVȂ
	if (!mPMesh)
	{
		return;
	}


	// ASSERT:JȂ玀
	ASSERT_PRINTF(mPCamera, _T("Jݒ肳Ă܂B"));

	// JȂ
	if (!mPCamera)
	{
		return;
	}


	// [hs쐬
	Matrix scale, rotate, translate;
	scale.CreateScale(mScale);

	rotate.CreateRotationZXY(mRotation);

	translate.CreateTranslate(mPosition);

	Matrix world;
	world = scale;
	world *= rotate;
	world *= translate;

	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &world);

	// r[sݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mPCamera->GetViewMatrixRef());

	// ˉesݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mPCamera->GetProjectionMatrixRef());

	// [hr[vWFNVsݒ
	Matrix wvp;
	wvp *= world;
	wvp *= mPCamera->GetViewMatrixRef();
	wvp *= mPCamera->GetProjectionMatrixRef();
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD_VIEW_PROJECTION, &wvp);


	// CeBOvZׂ̈ɋt[h]usݒ
	Matrix worldIT = world;
	worldIT.Inverse();
	worldIT.Transpose();
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD_INVERSE_TRANSPOSE, &worldIT);


	// ݒ
	mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, mColor.GetArray(), Color::mStKColorFactorNoAlphaCount);


	// `Jn
	unsigned passCount = 0;
	mPShaderEffect->Begin(&passCount, 0);
	{
		// pX̐Ń[v
		for (unsigned i = 0; i < passCount; ++i)
		{
			// `pXJn
			mPShaderEffect->BeginPass(i);
			{
				// `
				mPMesh->Render();
			}
			mPShaderEffect->EndPass();
		}
	}
	mPShaderEffect->End();
}