#include "Blast/Graphic/DirectX9/PolygonTriangleDX9.h"

#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
PolygonTriangleDX9::PolygonTriangleDX9()
{
}

/// fXgN^
PolygonTriangleDX9::~PolygonTriangleDX9()
{
}

/// o[ebNXobt@쐬
void PolygonTriangleDX9::CreateVertexBuffer()
{
	// TCY
	const float kSize = 100.0f;

	// Zl͌Œ
	const float kZBuffer = 1.0f;

	// MEMO:XUVWKvɂȂ邩܂B

	// _ݒ
	SVertex sVertices[] =
	{
		{  0.0f, kSize, kZBuffer, }, // 0xffffffff }, // 
		{  kSize, 0.0f, kZBuffer, }, // 0xffffffff }, // E
		{  0.0f, 0.0f, kZBuffer, }, // 0xffffffff }, // 
	};

	// _擾
	int vertexCount = sizeof(sVertices) / sizeof(sVertices[0]);

	// MEMO:z̐ł͂܂BoCgłB
	// _̃TCY擾
	int vertexSize = sizeof(SVertex) * vertexCount;

	// _obt@쐬
	VertexBufferDX9* pBuffer = NEW VertexBufferDX9();
	pBuffer->SetVertices(sVertices, vertexCount, vertexSize);

	// X}[g|C^ŕێ
	mPVertexBuffer.SetPointer(pBuffer);
}

/// _`쐬
void PolygonTriangleDX9::CreateVertexDeclaration()
{
	// _錾쐬
	VertexDeclarationDX9* pVD = NEW VertexDeclarationDX9();


	// _Hp
	VertexElementFactoryDX9 elementFactory;

	// _쐬
	const D3DVERTEXELEMENT9 sElements[] =
	{
		elementFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		elementFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	pVD->CreateDeclaration(sElements);

	// X}[g|C^ŕێ
	mPVertexDeclaration.SetPointer(pVD);
}

/// CfbNXobt@쐬
void PolygonTriangleDX9::CreateIndexBuffer()
{
	// MEMO:PȎOp`łB
	// CfbNXz쐬
	int indices[] = { 0, 1, 2 };

	// CfbNX̐擾
	int indexCount = sizeof(indices) / sizeof(indices[0]);

	// CfbNXobt@쐬
	IndexBufferDX9* pIndexBuffer = NEW IndexBufferDX9();
	pIndexBuffer->SetIndices(indices, indexCount);

	// X}[g|C^ŕێ
	mPIndexBuffer.SetPointer(pIndexBuffer);
}

/// VF[_[GtFNg쐬
void PolygonTriangleDX9::CreateShaderEffect()
{
	// VF[_[GtFNgǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShaderEffect = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_EFFECTTECHNIQUES));
}

/// XV
void PolygonTriangleDX9::Update(float delta)
{
}

/// `
void PolygonTriangleDX9::Render()
{
	// MEMO:S̑̂ɍl͂ł傤B͕`o邱ƂDłB

	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// [hs쐬
	mWorldMatrixProperty.UpdateMatrix();

	// ϊs쐬
	Matrix wvp = mWorldMatrixProperty.GetSRTMatrixRef();
	wvp *= mViewMatrix;
	wvp *= mProjectionMatrix;


	// _錾ݒ
	IDirect3DVertexDeclaration9* pDeclaration = mPVertexDeclaration->GetDeclaration();
	pDevice->SetVertexDeclaration(pDeclaration);


	// VF[_[擾
	CSP<ID3DXEffect> cspShaderEffect = mPShaderEffect->GetShaderEffect();
	ID3DXEffect* pShaderEffect = cspShaderEffect.GetInterface();


	// MEMO:͂ŃRo[gĂ܂B
	D3DXMATRIX matrixDX;
	memcpy(matrixDX.m, &wvp.m, sizeof(wvp.m));

	// MEMO:ϐł͂ȂAZ}eBNXŎwłƗǂł傤B
	// VF[_[ɕϊsݒ
	HRESULT hr = pShaderEffect->SetMatrix("gWVP", &matrixDX);

	// ASSERT:VF[_[ւ̕ϊs̐ݒ肪sȂ玀
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ւ̃[hs̐ݒ肪s܂B"));


	// MEMO:擪łCfbNXw肵Ă܂B
	// VF[_[eNjbNݒ
	D3DXHANDLE techniqueHandle = pShaderEffect->GetTechnique(0);
	hr = pShaderEffect->SetTechnique(techniqueHandle);

	// ASSERT:VF[_[eNjbN̐ݒɎs玀
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[eNjbN̐ݒɎs܂B"));


	// MEMO:`JnƓɁAݒ肵eNjbÑpX̐擾܂B
	// `Jn
	unsigned passCount = 0;
	pShaderEffect->Begin(&passCount, 0);
	{
		// pX̐Ń[v
		for (unsigned i = 0; i < passCount; ++i)
		{
			// `pXJn
			pShaderEffect->BeginPass(i);
			{
				// MEMO:ǂsłB
				// o[ebNXXg[ݒ
				pDevice->SetStreamSource(0, mPVertexBuffer->GetBuffer(), 0, mPVertexBuffer->GetStride());

				// CfbNXobt@ݒ
				pDevice->SetIndices(mPIndexBuffer->GetBuffer());


				// _擾
				u32 vertexCount = mPVertexBuffer->GetVertexCount();

				// v~eBu擾
				u32 primitiveCount = mPIndexBuffer->GetPrimitiveCount();


				// MEMO:v~eBu̐͂ǂŎ̂ǂł傤B
				// `
				hr = pDevice->DrawIndexedPrimitive(
					D3DPT_TRIANGLELIST,
					0,
					0,
					vertexCount,
					0,
					primitiveCount
					);
			}
			pShaderEffect->EndPass();
		}
	}
	pShaderEffect->End();


#ifdef _DEBUG

	// \
	const int kDataSpacing = 70;

	// oƏ̍s
	const int kLineSpacing = 12;

	// CfbNX
	int dataIndex = 0;

	// ʒu
	const int kX = 10;
	const int kY = 10;

	// ʒu
	int posX = kX;
	int posY = kY;

	// [hs̏\
	posY = kY + kDataSpacing * dataIndex;
	DP(posX, posY, 0xff88ffff, _T("[hs"));
	mWorldMatrixProperty.GetSRTMatrixRef().DebugRender(posX, posY + kLineSpacing);

	// r[s̏\
	++dataIndex;
	posY = kY + kDataSpacing * dataIndex;
	DP(posX, posY, 0xff88ffff, _T("r[s"));
	mViewMatrix.DebugRender(posX, posY + kLineSpacing);

	// ˉes̏\
	++dataIndex;
	posY = kY + kDataSpacing * dataIndex;
	DP(posX, posY, 0xff88ffff, _T("ˉes"));
	mProjectionMatrix.DebugRender(posX, posY + kLineSpacing);


	// WVPϊ̍W\
	++dataIndex;
	posY = kY + kDataSpacing * dataIndex;
	DP(posX, posY, 0xff88ffff, _T("WVP"));

	Vector3 v3s[3] =
	{
		Vector3::UnitY(),
		Vector3::UnitX(),
		Vector3::UnitX() * -1,
	};
	for (int i = 0; i < 3; ++i)
	{
		// Z
		v3s[i].Multiply(wvp);

		// 
		const int kSpacing = 12;

		// \
		v3s[i].DebugRender(posX, posY + kLineSpacing + kSpacing * i);
	}

#endif // _DEBUG
}


/// 
void PolygonTriangleDX9::Intialize()
{
	mWorldMatrixProperty.Initialize();
	mViewMatrix.Identity();
	mProjectionMatrix.Identity();
}

/// r[sƎˉesݒ
void PolygonTriangleDX9::SetViewProjection(const Matrix& kRView, const Matrix& kRProjection)
{
	mViewMatrix = kRView;
	mProjectionMatrix = kRProjection;
}