#include "Blast/Base/MenuEntry.h"

#include "Blast/Graphic/DirectX9/FontDX9.h"
#include "Blast/Graphic/TextRendererColorTag.h"

using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MenuEntry::MenuEntry()
{
	// Oݒ
	mNameStr = _T("MenuEntry");


	// eLXg_\쐬
	SP<FontDX9> pFont(NEW FontDX9());
	pFont->CreateFontData();

	mPTextRenderer.SetPointer(NEW TextRendererColorTag(pFont));
}

/// fXgN^
MenuEntry::~MenuEntry()
{
}


/// 
void MenuEntry::HandleInput(float delta)
{
}

/// XV
void MenuEntry::Update(float delta)
{
	// Ԃ̐F擾
	const Color& kRStateColor = GetStateColorRef();

	// Fێ
	mColor = kRStateColor;
}

/// `
void MenuEntry::Render()
{
	// eLXg`
	ASSERT_PRINTF(mPTextRenderer, _T("_[ݒ肳Ă܂B"));
	if (mPTextRenderer)
	{
		// eLXgݒ
		mPTextRenderer->SetText(mTextStr.c_str());


		// ʒuݒ
		mPTextRenderer->SetPosition(mPosition);

		// Fݒ
		mPTextRenderer->SetBasicColor(mColor);


		// eLXg`
		mPTextRenderer->Render();
	}
}


/// O擾
const TCHAR* MenuEntry::GetName() const
{
	return mNameStr.c_str();
}

/// Oݒ
void MenuEntry::SetName(const TCHAR* kPName)
{
	mNameStr = kPName;
}


/// eLXg擾
const TCHAR* MenuEntry::GetText() const
{
	return mTextStr.c_str();
}

/// eLXgݒ
void MenuEntry::SetText(const TCHAR* kPText)
{
	mTextStr = kPText;
}


/// ʒu擾
Vector3& MenuEntry::GetPositionRef()
{
	return mPosition;
}

/// ʒu擾
const Vector3& MenuEntry::GetPositionRef() const
{
	return mPosition;
}

/// ʒuݒ
void MenuEntry::SetPosition(const Vector3& kRPosition)
{
	mPosition = kRPosition;
}


/// ʒuX擾
float MenuEntry::GetPositionX() const
{
	return mPosition.mX;
}

/// ʒuXݒ
void MenuEntry::SetPositionX(float x)
{
	mPosition.mX = x;
}


/// ʒuY擾
float MenuEntry::GetPositionY() const
{
	return mPosition.mY;
}

/// ʒuYݒ
void MenuEntry::SetPositionY(float y)
{
	mPosition.mY = y;
}


/// ʒuZ擾
float MenuEntry::GetPositionZ() const
{
	return mPosition.mZ;
}

/// ʒuZݒ
void MenuEntry::SetPositionZ(float z)
{
	mPosition.mZ = z;
}


/// ]擾
Vector3& MenuEntry::GetRotationRef()
{
	return mRotation;
}

/// ]擾
const Vector3& MenuEntry::GetRotationRef() const
{
	return mRotation;
}

/// ]ݒ
void MenuEntry::SetRotation(const Vector3& kRRotation)
{
	mRotation = kRRotation;
}


/// ]X擾
float MenuEntry::GetRotationX() const
{
	return mRotation.mX;
}

/// ]Xݒ
void MenuEntry::SetRotationX(float x)
{
	mRotation.mX = x;
}


/// ]Y擾
float MenuEntry::GetRotationY() const
{
	return mRotation.mY;
}

/// ]Yݒ
void MenuEntry::SetRotationY(float y)
{
	mRotation.mY = y;
}


/// ]Z擾
float MenuEntry::GetRotationZ() const
{
	return mRotation.mZ;
}

/// ]Zݒ
void MenuEntry::SetRotationZ(float z)
{
	mRotation.mZ = z;
}


/// F擾
Color& MenuEntry::GetColorRef()
{
	return mColor;
}

/// F擾
const Color& MenuEntry::GetColorRef() const
{
	return mColor;
}

/// Fݒ
void MenuEntry::SetColor(const Color& kRColor)
{
	mColor = kRColor;
}


/// tHg擾
SP<IFont> MenuEntry::GetFont()
{
	return mPTextRenderer->GetFont();
}

/// tHgݒ
void MenuEntry::SetFont(SP<IFont> pFont)
{
	mPTextRenderer->SetFont(pFont);
}


/// 擾
float MenuEntry::GetWidth() const
{
	// tHgɉ̒擾
	int width = mPTextRenderer->GetFont()->MeasureString(mTextStr.c_str());

	return static_cast<float>(width);
}

/// c擾
float MenuEntry::GetHeight() const
{
	// tHg̃TCY擾
	int height = mPTextRenderer->GetFont()->GetPointSize();

	return static_cast<float>(height);
}


/// Jݒ
void MenuEntry::SetCamera(const SP<ICamera> pCamera)
{
	mPTextRenderer->SetCamera(pCamera);
}