#include "Blast/Base/Menu.h"

#include <iterator>
#include "Blast/Input/InputManager.h"

using namespace Blast::Base;
using namespace Blast::Input;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------


/* fobOj[̃vpeB */


/// RXgN^
Menu::SMenuProperty::SMenuProperty()
{
	Initialize();
}

/// 
void Menu::SMenuProperty::Initialize()
{
	mNameStr = _T("()");

	mSelectedListIndex = -1;

	mIsInputable = true;
	mIsEnable = true;
	mIsVisible = true;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Menu::Menu()
{
	// 
	Initialize();
}

/// fXgN^
Menu::~Menu()
{
}


/// 
void Menu::Initialize()
{
	// Gg[̔z\̔zNA
	mEntryLists.clear();

	// IĂ郊XgCfbNX
	mSDebugMenuProperty.mSelectedListIndex = -1;


	// fobOj[̃vpeB
	mSDebugMenuProperty.Initialize();
}


/// 
void Menu::HandleInput(float delta)
{
	// XgȂ
	if (mEntryLists.empty())
	{
		return;
	}


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// BL[ꂽ
	if (pKB->IsJustDown(Keys::eKEY_B))
	{
		// IĂ郊XgCfbNXfNg
		--mSDebugMenuProperty.mSelectedListIndex;

		// ͈͊O
		if (mSDebugMenuProperty.mSelectedListIndex < 0)
		{
			mSDebugMenuProperty.mSelectedListIndex = 0;
		}
	}
	// NL[ꂽ
	else if (pKB->IsJustDown(Keys::eKEY_N))
	{
		// IĂ郊XgCfbNXCNg
		++mSDebugMenuProperty.mSelectedListIndex;

		// ͈͊O
		int size = mEntryLists.size();
		if (size <= mSDebugMenuProperty.mSelectedListIndex)
		{
			mSDebugMenuProperty.mSelectedListIndex = mEntryLists.size() - 1;
		}
	}


	// IĂ郊XgQ
	SP<IMenuEntryList> pSelectedEntryList = GetSelectedMenuEntryList();

	// 
	pSelectedEntryList->HandleInput(delta);
}

/// XV
void Menu::Update(float delta)
{
	// MEMO:XV͑SĂɍs܂B

	// Gg[̔z\̔z񐔂Ń[v
	std::vector< SP<IMenuEntryList> >::iterator it;
	for (it = mEntryLists.begin(); it != mEntryLists.end(); ++it)
	{
		// XV
		(*it)->Update(delta);
	}
}

/// `
void Menu::Render()
{
	// MEMO:ߑłłBNCAg̈̉╶Ŝ̉߂ꂽ猫ł傤B
	// ʒu
	int posX = 400;
	int posY = 10;

	// j[`
	DP(posX, posY, 0xff00ff00, mSDebugMenuProperty.mNameStr.c_str());


	// XgȂ
	if (mEntryLists.empty())
	{
		return;
	}

	// IĂ郊XgQ
	SP<IMenuEntryList> pSelectedEntryList = GetSelectedMenuEntryList();

	// `
	// UŃXvCg`悵Ă
	GraphicsDeviceDX9* pGD = GraphicsDeviceDX9::GetInstance();
	pGD->BeginSprite();
	pSelectedEntryList->Render();
	pGD->EndSprite();
}


/// Gg[Xgǉ
void Menu::AddMenuEntryList(SP<IMenuEntryList> pEntryList)
{
	// ǉ
	mEntryLists.push_back(pEntryList);


	// IĂ郊XgCfbNX0Ȃ
	if (mSDebugMenuProperty.mSelectedListIndex < 0)
	{
		mSDebugMenuProperty.mSelectedListIndex = 0;
	}
}


/// ݑIĂGg[Xg擾
SP<IMenuEntryList> Menu::GetSelectedMenuEntryList()
{
	//// ASSERT:Gg[XgȂ玀
	//ASSERT_PRINTF(!mEntryLists.empty(), _T("Gg[XgłB"));

	// Gg[XgȂ
	if (!mEntryLists.empty())
	{
		// CfbNX͈͓ǂ
		int size = mEntryLists.size();
		bool isIndexInternal = mSDebugMenuProperty.mSelectedListIndex < size;

		//// ASSERT:͈͊OȂ玀
		//ASSERT_PRINTF(isIndexInternal, _T("CfbNX͈͊OłBXg̐=%d, CfbNX=%d"), size, mSDebugMenuProperty.mSelectedListIndex);


		// CfbNX͈͓Ȃ
		if (isIndexInternal)
		{
			return mEntryLists.at(mSDebugMenuProperty.mSelectedListIndex);
		}
	}

	return SP<IMenuEntryList>();
}