#include "Blast/Math/MathHelper.h"

#include "Blast/Math/Random.h"

using namespace Blast::Math;
using namespace fbxsdk_2012_2;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// l𒴂ŏ̔{擾
int MathHelper::GetOverMultiple(int border, int multiple)
{
	int out = -1;

	out = border + (multiple - 1);
	out /= multiple;
	out *= multiple;

	return out;
}


/// KFbxXMatrixMatrixɕϊ
Matrix MathHelper::ToMatrix(const KFbxXMatrix& rIn, Matrix* pOut)
{
	Matrix mat;

	// ̐Ń[v
	for (int i = 0; i < Matrix::mStKColumnCount; ++i)
	{
		// s̐Ń[v
		for (int j = 0; j < Matrix::mStKRowCount; ++j)
		{
			mat.m[i][j] = static_cast<float>(rIn[i][j]);
		}
	}

	// o͕ϐLȂ
	if (pOut)
	{
		*pOut = mat;
	}
	
	return mat;
}

/// MatrixKFbxXMatrixɕϊ
KFbxXMatrix MathHelper::ToFbxXMatrix(const Matrix& rIn, KFbxXMatrix* pOut)
{
	KFbxXMatrix matFbx;

	// ̐Ń[v
	for (int i = 0; i < Matrix::mStKColumnCount; ++i)
	{
		// s̐Ń[v
		for (int j = 0; j < Matrix::mStKRowCount; ++j)
		{
			matFbx[i][j] = static_cast<double>(rIn.m[i][j]);
		}
	}

	// o͕ϐLȂ
	if (pOut)
	{
#if 0	// KFbxXMatrixւ̒ڑ͋@\Ȃ悤łI
		*pOut = matFbx;
#else
		memcpy(pOut, &matFbx, sizeof(matFbx));
#endif
	}

	return matFbx;
}

/// KFbxXMatrixdouble^̒lŏZ
void MathHelper::Multiple(KFbxXMatrix& rIO, double value)
{
	for (int i = 0; i < 4; ++i)
	{
		for (int j = 0; j < 4; ++j)
		{
			rIO[i][j] *= value;
		}
	}
}

/// KFbxXMatrixdouble^̒lZ
void MathHelper::Add(KFbxXMatrix& rIO, const KFbxXMatrix& rIn)
{
	for (int i = 0; i < 4; ++i)
	{
		for (int j = 0; j < 4; ++j)
		{
			rIO[i][j] += rIn[i][j];
		}
	}
}

/// KFbxXMatrix̑Ίpvf݂̂double^̒lŉZ
void MathHelper::AddToDiagnoal(KFbxXMatrix& rIO, double value)
{
	for (int i = 0; i < 4; ++i)
	{
		rIO[i][i] += value;
	}
}


/// EZ-UpWnY-UpWnɕϊs쐬
Matrix MathHelper::CreateZUpRHToYUpLH(Matrix* pOut)
{
	// Z}CiXXP[s쐬
	Matrix minusZ;
	Matrix::CreateScale(1, 1, -1, &minusZ);

	// X90x]s쐬
	Matrix rotX90;
	Matrix::CreateRotationX(MathHelper::ToRadian(90.0f), &rotX90);

	Matrix result = minusZ * rotX90;

	// o͕ϐLȂ
	if (pOut)
	{
		memcpy(pOut, &result, sizeof(result));
	}

	return result;
}

/// FBXSDKɂϊł͕sĂ镪UׂɎgp܂B
/// FBXSDKDirectX̎ϊsۂɕsĂ镪Us쐬
Matrix MathHelper::CreateConvertAxisFromFbxSdk(Matrix* pOut)
{
	Matrix scale, rotation, compensate;
	scale.CreateScale(Vector3(-1, 1, 1));
	rotation.CreateRotationX(MathHelper::ToRadian(90.0f));
	compensate = scale * rotation;

	// o͕ϐLȂĂ
	if (pOut)
	{
		memcpy(pOut, &compensate, sizeof(compensate));
	}

	return compensate;
}


/// 񎟌z̃CfbNXꎟz̃CfbNXƂĎZo
int MathHelper::CalculateLinearIndex(int indexX, int indexY, int width)
{
	const int kLinearIndex = width * indexY + indexX;

	return kLinearIndex;
}


/// m
bool MathHelper::IsJudgment(int percent)
{
	Random rand;
	const int kHundred = 100;
	const int kValue = rand.GetNext(kHundred);

	return (kValue < percent);
}