#include "Blast/Graphic/DirectX9/Line2DDX9.h"

#include "Blast/Base/DirectX9/GraphicsDeviceDX9.h"
#include "Blast/Graphic/VertexElementType.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------


	/* vpeB */


	/// RXgN^
	Line2DDX9::SLine2DDX9Property::SLine2DDX9Property()
	{
		// 
		Initialize();
	}

	/// 
	void Line2DDX9::SLine2DDX9Property::Initialize()
	{
		mWidth = 1;
		mIsAntialias = true;
		mColor = 0xffffffff;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Line2DDX9::Line2DDX9()
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// CC^[tF[X쐬
	D3DXCreateLine(pDevice, mPLine.ToCreator());


	// vpeB
	mSProperty.Initialize();
}

/// fXgN^
Line2DDX9::~Line2DDX9()
{
}


/// `
void Line2DDX9::Render(Vector2* pPoints, int count)
{
	// MEMO:Œł͂ȂƂ͂ANEWȂ΂ȂȂ̂ł傤B
	D3DXVECTOR2* pPointsDX = NEW D3DXVECTOR2[count];
	for (int i = 0; i < count; ++i)
	{
		// ϊ
		MathHelperDX::ToD3DXVECTOR2(pPoints[i], &pPointsDX[i]);
	}
	

	// ݒ
	mPLine->SetWidth(mSProperty.mWidth);

	// A`GCAXݒ
	mPLine->SetAntialias(mSProperty.mIsAntialias);


	// `Jn
	mPLine->Begin();
	{
		// `
		mPLine->Draw(pPointsDX, count, mSProperty.mColor.GetARGB());
	}
	// `I
	mPLine->End();


	// ϊ̔z
	SAFE_DELETE_ARRAY(pPointsDX);
}