#include "Blast/Input/DirectX8/KeyboardDX8.h"

#include "Blast/Input/DirectX8/KeyboardDeviceDX8.h"

using namespace Blast::Input;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* L[̏ */

/// Ԃ̍ől
const float KeyboardDX8::SKeyState::stKMaxTime = 1024.0f;

/// RXgN^
KeyboardDX8::SKeyState::SKeyState() :
mOldState(0),
mDownDurationTime(0),
mDownDelayTime(0),
mUpDurationTime(0),
mUpDelayTime(0)
{
}

/// LȏԂ̍XV
void KeyboardDX8::SKeyState::UpdateEnable(const float& kRDelta)
{
	mDownDurationTime += kRDelta;
	mDownDelayTime += kRDelta;
	mUpDurationTime = 0;
	mUpDelayTime = 0;

	UpdateClamp();
}

/// ȏԂ̍XV
void KeyboardDX8::SKeyState::UpdateDisable(const float& kRDelta)
{
	mDownDurationTime = 0;
	mDownDelayTime = 0;
	mUpDurationTime += kRDelta;
	mUpDelayTime += kRDelta;

	UpdateClamp();
}

/// Nvs
void KeyboardDX8::SKeyState::UpdateClamp()
{
	// MEMO:I[o[̗}݂̂Ă܂

	if (stKMaxTime <= mDownDurationTime)
	{
		mDownDurationTime = stKMaxTime;
	}

	if (stKMaxTime <= mDownDelayTime)
	{
		mDownDelayTime = stKMaxTime;
	}

	if (stKMaxTime <= mUpDurationTime)
	{
		mUpDurationTime = stKMaxTime;
	}

	if (stKMaxTime <= mUpDelayTime)
	{
		mUpDelayTime = stKMaxTime;
	}
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
KeyboardDX8::KeyboardDX8() :
mPDevice(NULL)
{
	// L[̏Ԃ
	ZeroMemory(mCurrentKeyStates, DIK_DATA_PACKET_SIZE);
}

/// fXgN^
KeyboardDX8::~KeyboardDX8()
{
	SAFE_DELETE(mPDevice);
}

/// InputDevice쐬
bool KeyboardDX8::Create(HWND hWnd, LPDIRECTINPUT8 pDirectInput)
{
	bool isOk = false;

	// foCX̍쐬
	mPDevice = new KeyboardDeviceDX8();
	isOk = mPDevice->Create(hWnd, pDirectInput);

	return isOk;
}

/// XV
void KeyboardDX8::Update(const float& kRDelta)
{
	// L擾
	HRESULT hr = mPDevice->GetInputDevice()->Acquire();

	// L̎擾ɎsȂ
	if (FAILED(hr))
	{
		return;
	}

	// L[̍XV
	UpdateKeyStates(kRDelta);
}

/// {^Ă邩擾
bool KeyboardDX8::IsDown(Keys::EKey eKey) const
{
	bool isDown = false;

	isDown = IsEnable(mCurrentKeyStates[eKey]);

	return isDown;
}

/// {^ꂽuԂ擾
bool KeyboardDX8::IsJustDown(Keys::EKey eKey) const
{
	bool isOldUp = IsDisable(mSKeyStates[eKey].mOldState);
	bool isCurrentDown = IsEnable(mCurrentKeyStates[eKey]);

	// O񉟂Ă炸A񉟂ĂȂ
	if (isOldUp && isCurrentDown)
	{
		return true;
	}

	return false;
}

/// ̃{^ꂽuԂ擾
bool KeyboardDX8::IsJustDownAny() const
{
	// ꂽuԂ̃L[ołAtrueԂ
	for (int i = 0; i < DIK_DATA_PACKET_SIZE; ++i)
	{
		Keys::EKey eKey = static_cast<Keys::EKey>(i);
		if (IsJustDown(eKey))
		{
			return true;
		}
	}
	
	return false;
}


/// {^Ă邩擾
bool KeyboardDX8::IsUp(Keys::EKey eKey) const
{
	bool isUp = false;

	isUp = IsDisable(mCurrentKeyStates[eKey]);

	return isUp;
}

/// {^ꂽuԂ擾
bool KeyboardDX8::IsJustUp(Keys::EKey eKey) const
{
	bool isOldDown = IsEnable(mSKeyStates[eKey].mOldState);
	bool isCurrentUp = IsDisable(mCurrentKeyStates[eKey]);

	// O񉟂ĂA񉟂ĂȂȂ
	if (isOldDown && isCurrentUp)
	{
		return true;
	}

	return false;
}

/// {^Ă邩ԊuŎ擾
bool KeyboardDX8::IsRapidDown(Keys::EKey eKey, const float& kRInterval)
{
	bool isDown = false;

	// {^ĂȂ
	if (IsDown(eKey))
	{
		// MEMO:uԂ͌m܂
		isDown = IsJustDown(eKey);

		// LȎԂ莞Ԃ𒴂ĂȂ
		if (kRInterval <= mSKeyStates[eKey].mDownDurationTime)
		{
			isDown = true;

			// Ă鎞Ԃ
			mSKeyStates[eKey].mDownDurationTime = 0;
		}
	}

	return isDown;
}

/// {^Ă邩ԊuŎ擾
bool KeyboardDX8::IsRapidUp(Keys::EKey eKey, const float& kRInterval)
{
	bool isUp = false;

	// {^ĂȂ
	if (IsUp(eKey))
	{
		// MEMO:uԂ͌m܂
		isUp = IsJustUp(eKey);

		// ȎԂ莞Ԃ𒴂ĂȂ
		if (kRInterval <= mSKeyStates[eKey].mUpDurationTime)
		{
			isUp = true;

			// Ă鎞Ԃ
			mSKeyStates[eKey].mUpDurationTime = 0;
		}
	}

	return isUp;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool KeyboardDX8::IsDelayRapidDown(Keys::EKey eKey, const float& kRInterval, const float& kRDelay)
{
	// MEMO:uԂ͌m܂

	// ꂽuԂȂ
	if (IsJustDown(eKey))
	{
		return true;
	}
	// {^ĂȂ
	else if (IsDown(eKey))
	{
		// ĂxԂ߂ĂȂ
		if (kRDelay <= mSKeyStates[eKey].mDownDelayTime)
		{
			// sbh͂LȂ
			if (IsRapidDown(eKey, kRInterval))
			{
				return true;
			}
		}
	}

	return false;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool KeyboardDX8::IsDelayRapidUp(Keys::EKey eKey, const float& kRInterval, const float& kRDelay)
{
	// MEMO:uԂ͌m܂

	// uԂȂ
	if (IsJustUp(eKey))
	{
		return true;
	}
	// {^ĂȂ
	else if (IsUp(eKey))
	{
		// ĂxԂ߂ĂȂ
		if (kRDelay <= mSKeyStates[eKey].mUpDelayTime)
		{
			// sbh͂LȂ
			if (IsRapidUp(eKey, kRInterval))
			{
				return true;
			}
		}
	}

	return false;
}

/// ĂL[Q擾
void KeyboardDX8::GetDownKeys(std::vector<Keys::EKey>* pOut) const
{
	// o͕ϐ
	pOut->clear();

	// f[^pPbg̐Ń[v
	for (int i = 0; i < DIK_DATA_PACKET_SIZE; ++i)
	{
		Keys::EKey eKey = static_cast<Keys::EKey>(i);

		// ĂȂ
		if (IsDown(eKey))
		{
			pOut->push_back(eKey);
		}
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ԂLǂ
bool KeyboardDX8::IsEnable(const u8& kRState) const
{
	return (0 < (kRState & 0x80));
}

/// Ԃǂ
bool KeyboardDX8::IsDisable(const u8& kRState) const
{
	return !IsEnable(kRState);
}

/// L[̍XV
void KeyboardDX8::UpdateKeyStates(const float& kRDelta)
{
	// f[^pPbg̐Ń[v
	for (int i = 0; i < DIK_DATA_PACKET_SIZE; ++i)
	{
		// ͏ԂȌԂɑ
		mSKeyStates[i].mOldState = mCurrentKeyStates[i];
	}
	
	// Ԃ擾
	HRESULT hr = mPDevice->GetInputDevice()->GetDeviceState(DIK_DATA_PACKET_SIZE, mCurrentKeyStates);

	// Ԃ̎擾ɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("L[{[h̏Ԏ擾Ɏs܂"));
	}

	// f[^pPbg̐Ń[v
	for (int i = 0; i < DIK_DATA_PACKET_SIZE; ++i)
	{
		// L[Q
		SKeyState& rSKeyState = mSKeyStates[i];

		// LȏԂȂ
		if (IsEnable(mCurrentKeyStates[i]))
		{
			rSKeyState.UpdateEnable(kRDelta);
		}
		// ȏԂȂ
		else
		{
			rSKeyState.UpdateDisable(kRDelta);
		}
	}
}