#include "Blast/Input/DirectX8/JoystickDeviceDX8.h"

using namespace Blast::Input;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// WCXeBbN̗񋓂sR[obN
BOOL CALLBACK JoystickDeviceDX8::EnumJoysticksCallback(const DIDEVICEINSTANCE* pDeviceInstance, void* pContext)
{
	HRESULT hr = DI_OK;
	
	// WCXeBbN쐬
	hr = mPInput->CreateDevice(
		pDeviceInstance->guidInstance,
		&mPInputDevice,
		NULL);

	// WCXeBbN̍쐬ɎsȂ
	if(FAILED(hr))
	{
		PRINTF_LINE(_T("WCXeBbN̍쐬Ɏs܂"));

		// MEMO:DIENUM_CONTINUE͑sƂӖȂ̂ł傤H
		return DIENUM_CONTINUE;
	}

	// CX^Xێ
	mInstanceNameStr = pDeviceInstance->tszInstanceName;
	mProductNameStr = pDeviceInstance->tszProductName;

	// MEMO:DIENUM_STOP͈IƂӖȂ̂ł傤H
	return DIENUM_STOP;
}

/// WCXeBbN̏sR[obN
BOOL CALLBACK JoystickDeviceDX8::EnumObjectsCallback(const DIDEVICEOBJECTINSTANCE* pObjectInstance, void* pContext)
{
	HRESULT hr = DI_OK;

	// ^CvDIDFT_AXISȂ
	if(pObjectInstance->dwType & DIDFT_AXIS)
	{
		DIPROPRANGE sRange;
		sRange.diph.dwSize = sizeof(DIPROPRANGE);
		sRange.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		sRange.diph.dwHow = DIPH_BYID;
		sRange.diph.dwObj = pObjectInstance->dwType;
		sRange.lMin = -mStKRange;
		sRange.lMax = mStKRange;

		// vpeBݒ
		hr = mPInputDevice->SetProperty(DIPROP_RANGE, &sRange.diph);

		// vpeB̐ݒɎsȂ
		if (FAILED(hr))
		{
			// MEMO:Ƃ肠~߂邱Ƃɂ܂
			HALT(_T("WCXeBbÑvpeB̐ݒɎs܂"));

			//return DIENUM_CONTINUE;
		}
	}

    return DIENUM_CONTINUE;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// fXgN^
JoystickDeviceDX8::JoystickDeviceDX8()
{
}

/// fXgN^
JoystickDeviceDX8::~JoystickDeviceDX8()
{
}

/// foCX̍쐬
bool JoystickDeviceDX8::Create(HWND hWnd, LPDIRECTINPUT8 pDirectInput)
{
	HRESULT hr = DI_OK;

	// LPDIRECTINPUT8ێ
	mPInput = pDirectInput;

	// foCX
	hr = pDirectInput->EnumDevices(
		DI8DEVCLASS_GAMECTRL,
		EnumJoysticksCallback,
		NULL,
		DIEDFL_ATTACHEDONLY
		);

	// foCX̗񋓂ɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("WCXeBbN̗񋓂Ɏs܂"));
	}

	// ڑĂWCXeBbNȂ
	if (!mPInputDevice)
	{
		// MEMO:WCXeBbN͐ڑĂȂ\̂ŗƂ܂
		PRINTF_LINE(_T("ڑĂWCXeBbN͂܂łB"));

		return false;
	}

	// tH[}bgݒ
	hr = mPInputDevice->SetDataFormat(&c_dfDIJoystick2);

	// tH[}bg̐ݒɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("WCXeBbÑtH[}bgݒɎs܂"));
	}

	// [hݒ
	hr = mPInputDevice->SetCooperativeLevel(hWnd, DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);

	// [h̐ݒɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("WCXeBbN̋[hݒɎs܂"));
	}

	// MEMO:̏̂ł傤H
	// WCXeBbÑLpreB擾
	DIDEVCAPS devCaps;
	devCaps.dwSize = sizeof(DIDEVCAPS);

	hr = mPInputDevice->GetCapabilities(&devCaps);

	// WCXeBbÑLpreB̎擾ɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("WCXeBbÑLpreB擾Ɏs܂"));
	}

	// WCXeBbN̏ݒ
	hr = mPInputDevice->EnumObjects(
		EnumObjectsCallback,
		(void*)hWnd,
		DIDFT_AXIS
		);

	// WCXeBbN̏̐ݒɎsȂ
	if (FAILED(hr))
	{
		HALT(_T("WCXeBbÑIuWFNg񋓃R[obNɎs܂"));
	}

	return (hr == DI_OK);
}

/// foCX擾
LPDIRECTINPUTDEVICE8 JoystickDeviceDX8::GetInputDevice() const
{
	return mPInputDevice;
}


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// 
LPDIRECTINPUT8 JoystickDeviceDX8::mPInput = NULL;

/// ̓foCX
LPDIRECTINPUTDEVICE8 JoystickDeviceDX8::mPInputDevice = NULL;

/// CX^X
tstring JoystickDeviceDX8::mInstanceNameStr;

/// v_Ng
tstring JoystickDeviceDX8::mProductNameStr;