#include "Blast/Input/DirectX8/JoystickDX8.h"

#include "Blast/Input/DirectX8/JoystickDeviceDX8.h"

using namespace Blast::Input;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* WCXeBbN̓͂̏ */

/// Ăꍇ̍XV
void JoystickDX8::SJoystickInputState::UpdateDown(const float& kRDelta)
{
	mElapsedTimeDown += kRDelta;
	mElapsedTimeDelayDown += kRDelta;
	mElapsedTimeUp = 0;
	mElapsedTimeDelayUp = 0;
}

/// Ăꍇ̍XV
void JoystickDX8::SJoystickInputState::UpdateUp(const float& kRDelta)
{
	mElapsedTimeDown = 0;
	mElapsedTimeDelayDown = 0;
	mElapsedTimeUp += kRDelta;
	mElapsedTimeDelayUp += kRDelta;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
JoystickDX8::JoystickDX8() :
mPDevice(NULL)
{
	// {^̏Ԃ
	ZeroMemory(mButtonStatus, sizeof(mButtonStatus));

	// nbg̏Ԃ
	ZeroMemory(mPOVStatus, sizeof(mPOVStatus));
}

/// fXgN^
JoystickDX8::~JoystickDX8()
{
	SAFE_DELETE(mPDevice);
}

/// foCX쐬
bool JoystickDX8::Create(HWND hWnd, LPDIRECTINPUT8 pDirectInput)
{
	bool isOk = false;

	// foCX쐬
	mPDevice = new JoystickDeviceDX8();
	isOk = mPDevice->Create(hWnd, pDirectInput);

	return isOk;
}

/// XV
void JoystickDX8::Update(const float& kRDelta)
{
	LPDIRECTINPUTDEVICE8 pDevice = mPDevice->GetInputDevice();

	// foCXȂ
	if (!pDevice)
	{
		return;
	}

	// ʕϐ
	HRESULT hr = DI_OK;

	// MEMO:foCX̏ԂXV܂B
	// |[Os
	hr = mPDevice->GetInputDevice()->Poll();

	// |[OɎsĂȂ
	if (FAILED(hr))
	{
		// L擾
		hr = mPDevice->GetInputDevice()->Acquire();

		// L擾łȂȂ
		if (FAILED(hr))
		{
			// MEMO:TvłwhileŎ擾悤ƂĂ܂B
			return;
		}
	}

	// WCXeBbNXV
	UpdateJoystick(kRDelta);
}

/// XeBbNX̌X|ʂ擾
int JoystickDX8::GetStickTiltX(Sticks::EStick eStick) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	return GetStickTiltXByIndex(eStick);
}

/// XeBbNY̌X|ʂ擾
int JoystickDX8::GetStickTiltY(Sticks::EStick eStick) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	return GetStickTiltYByIndex(eStick);
}

/// XeBbŃ{X̌X|ʂlĂ邩
bool JoystickDX8::IsStickTiltPlusX(Sticks::EStick eStick, int tiltBorder) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	const LONG& kRX = GetStickTiltXByIndex(eStick);

	bool isOver = IsStickTiltOver(kRX, tiltBorder);

	return isOver;
}

/// XeBbŃ|X̌X|ʂlĂ邩
bool JoystickDX8::IsStickTiltMinusX(Sticks::EStick eStick, int tiltBorder) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}
	
	const LONG& kRX = GetStickTiltXByIndex(eStick);

	bool isUnder = IsStickTiltUnder(kRX, tiltBorder);

	return isUnder;
}

/// XeBbŃ{Y̌X|ʂlĂ邩
bool JoystickDX8::IsStickTiltPlusY(Sticks::EStick eStick, int tiltBorder) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}
	
	const LONG& kRY = GetStickTiltYByIndex(eStick);

	bool isOver = IsStickTiltOver(kRY, tiltBorder);

	return isOver;
}

/// XeBbŃ|X̌X|ʂlĂ邩
bool JoystickDX8::IsStickTiltMinusY(Sticks::EStick eStick, int tiltBorder) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}
	
	const LONG& kRY = GetStickTiltYByIndex(eStick);

	bool isUnder = IsStickTiltUnder(kRY, tiltBorder);

	return isUnder;
}

/// {^Ă邩擾
bool JoystickDX8::IsDown(Buttons::EButton eButton) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:{^LȂ牟Ă܂B

	const u8& kRButton = mJoystickStatus[eSTATE_CURRENT].rgbButtons[eButton];

	bool isDown = IsEnableButton(kRButton);

	return isDown;
}

/// {^ꂽuԂ擾
bool JoystickDX8::IsJustDown(Buttons::EButton eButton) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:O񖳌ōLȂAꂽuԂłB

	const u8& kROldButton = mJoystickStatus[eSTATE_OLD].rgbButtons[eButton];
	const u8& kRCurrentButton = mJoystickStatus[eSTATE_CURRENT].rgbButtons[eButton];

	bool isOldUp = IsDisableButton(kROldButton);
	bool isCurrentDown = IsEnableButton(kRCurrentButton);

	bool isJustDown = (isOldUp && isCurrentDown);

	return isJustDown;
}

/// {^Ă邩擾
bool JoystickDX8::IsUp(Buttons::EButton eButton) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:{^Ȃ痣Ă܂B

	const u8& kRButton = mJoystickStatus[eSTATE_CURRENT].rgbButtons[eButton];

	bool isUp = IsDisableButton(kRButton);

	return isUp;
}

/// {^ꂽuԂ擾
bool JoystickDX8::IsJustUp(Buttons::EButton eButton) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:OLō񖳌ȂAꂽuԂłB

	const u8& kROldButton = mJoystickStatus[eSTATE_OLD].rgbButtons[eButton];
	const u8& kRCurrentButton = mJoystickStatus[eSTATE_CURRENT].rgbButtons[eButton];

	bool isOldDown = IsEnableButton(kROldButton);
	bool isCurrentUp = IsDisableButton(kRCurrentButton);

	bool isJustUp = (isOldDown && isCurrentUp);

	return isJustUp;
}

/// {^Ă邩ԊuŎ擾
bool JoystickDX8::IsRapidDown(Buttons::EButton, const float& kRInterval)
{
	return false;
}

/// {^Ă邩ԊuŎ擾
bool JoystickDX8::IsRapidUp(Buttons::EButton, const float& kRInterval)
{
	return false;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool JoystickDX8::IsDelayRapidDown(Buttons::EButton, const float& kRInterval, const float& kRDelay)
{
	return false;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool JoystickDX8::IsDelayRapidUp(Buttons::EButton, const float& kRInterval, const float& kRDelay)
{
	return false;
}

/// \L[Ă邩擾
bool JoystickDX8::IsDownPOV(PointOfViews::EPointOfView ePOV, int index) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// nbg擾
	const DWORD& kRPOV = mJoystickStatus[eSTATE_CURRENT].rgdwPOV[index];

	bool isDown = IsEnablePOV(kRPOV, ePOV);

	return isDown;
}

/// \L[Ă邩擾
bool JoystickDX8::IsUpPOV(PointOfViews::EPointOfView ePOV, int index) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// nbg擾
	const DWORD& kRPOV = mJoystickStatus[eSTATE_CURRENT].rgdwPOV[index];

	bool isUp = IsDisablePOV(kRPOV, ePOV);

	return isUp;
}

/// \L[ꂽuԂ擾
bool JoystickDX8::IsJustDownPOV(PointOfViews::EPointOfView ePOV, int index) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:O񖳌ŁALȂAꂽuԂłB

	const DWORD& kRPOVOld = mJoystickStatus[eSTATE_OLD].rgdwPOV[index];
	const DWORD& kRPOVCurrent = mJoystickStatus[eSTATE_CURRENT].rgdwPOV[index];

	bool isDisableOld = IsDisablePOV(kRPOVOld, ePOV);
	bool isEnbaleCurrent = IsEnablePOV(kRPOVCurrent, ePOV);

	bool isJustDown = (isDisableOld && isEnbaleCurrent);

	return isJustDown;
}

/// \L[ꂽuԂ擾
bool JoystickDX8::IsJustUpPOV(PointOfViews::EPointOfView ePOV, int index) const
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// MEMO:OLŁA񖳌ȂAꂽuԂłB

	const DWORD& kRPOVOld = mJoystickStatus[eSTATE_OLD].rgdwPOV[index];
	const DWORD& kRPOVCurrent = mJoystickStatus[eSTATE_CURRENT].rgdwPOV[index];

	bool isEnableOld = IsEnablePOV(kRPOVOld, ePOV);
	bool isDisaleCurrent = IsDisablePOV(kRPOVCurrent, ePOV);

	bool isJustUp = (isEnableOld && isDisaleCurrent);

	return isJustUp;
}

/// \L[Ă邩ԊuŎ擾
bool JoystickDX8::IsRapidDownPOV(PointOfViews::EPointOfView ePOV, float interval, int index)
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// uԂȂ
	if (IsJustDownPOV(ePOV, index))
	{
		return true;
	}
	// uԂłȂȂ
	else
	{
		SJoystickInputState& rState = mPOVStatus[index][ePOV];

		// Ă鎞Ԃ莞ԈȏȂ
		if (interval <= rState.mElapsedTimeDown)
		{
			// Ă鎞ԂZbg
			rState.mElapsedTimeDown = 0;

			return true;
		}
	}

	return false;
}

/// \L[Ă邩ԊuŎ擾
bool JoystickDX8::IsRapidUpPOV(PointOfViews::EPointOfView ePOV, float interval, int index)
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// uԂȂ
	if (IsUpPOV(ePOV, index))
	{
		return true;
	}
	// uԂłȂȂ
	else
	{
		SJoystickInputState& rState = mPOVStatus[index][ePOV];

		// Ă鎞Ԃ莞ԈȏȂ
		if (interval <= rState.mElapsedTimeUp)
		{
			// Ă鎞ԂZbg
			rState.mElapsedTimeUp= 0;

			return true;
		}
	}

	return false;
}

/// \L[Ă邩莞ԌォԊuŎ擾
bool JoystickDX8::IsDelayRapidDownPOV(PointOfViews::EPointOfView ePOV, float interval, float delay, int index)
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// uԂȂ
	if (IsJustDownPOV(ePOV, index))
	{
		return true;
	}
	// uԂłȂȂ
	else
	{
		SJoystickInputState& rState = mPOVStatus[index][ePOV];

		// Ă鎞ԂxԈȏȂ
		if (delay <= rState.mElapsedTimeDelayDown)
		{
			// 莞ԊԊuŎ擾
			bool isDown = IsRapidDownPOV(ePOV, interval, index);

			return isDown;
		}
	}

	return false;
}

/// \L[Ă邩莞ԌォԊuŎ擾
bool JoystickDX8::IsDelayRapidUpPOV(PointOfViews::EPointOfView ePOV, float interval, float delay, int index)
{
	// WCXeBbNȂ
	if (IsNothingJoystick())
	{
		return false;
	}

	// uԂȂ
	if (IsJustUpPOV(ePOV, index))
	{
		return true;
	}
	// uԂłȂȂ
	else
	{
		SJoystickInputState& rState = mPOVStatus[index][ePOV];

		// Ă鎞ԂxԈȏȂ
		if (delay <= rState.mElapsedTimeDelayUp)
		{
			// 莞ԊԊuŎ擾
			bool isUp = IsRapidUpPOV(ePOV, interval, index);

			return isUp;
		}
	}

	return false;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// WCXeBbNł邩ǂ
bool JoystickDX8::IsExistJoystick() const
{
	return (0 < mPDevice->GetInputDevice());
}

/// WCXeBbNȂǂ
bool JoystickDX8::IsNothingJoystick() const
{
	return !IsExistJoystick();
}

/// XeBbNX̌X|ʂ擾
const LONG& JoystickDX8::GetStickTiltXByIndex(const int& eStick) const
{
	// CfbNXŕ
	switch (eStick)
	{
		// XeBbNȂ
		case eSTICK_LEFT:

			return mJoystickStatus[eSTATE_CURRENT].lX;

		// EXeBbNȂ
		case eSTICK_RIGHT:

			return mJoystickStatus[eSTATE_CURRENT].lZ;

		// P[XOȂ
		default:

			PRINTF_LINE(_T("GetStickTiltX()caseӐ}ɂȂĂ܂B"));

			return mJoystickStatus[eSTATE_CURRENT].lX;
	};
}

/// XeBbNY̌X|ʂ擾
const LONG& JoystickDX8::GetStickTiltYByIndex(const int& eStick) const
{
	// CfbNXŕ
	switch (eStick)
	{
		// XeBbNȂ
		case eSTICK_LEFT:

			return mJoystickStatus[eSTATE_CURRENT].lY;

		// EXeBbNȂ
		case eSTICK_RIGHT:

			return mJoystickStatus[eSTATE_CURRENT].lRz;

		// P[XOȂ
		default:

			PRINTF_LINE(_T("GetStickTiltY()caseӐ}ɂȂĂ܂B"));

			return mJoystickStatus[eSTATE_CURRENT].lY;
	};
}

/// XeBbŇX|ʂ{̈lȏォǂ
bool JoystickDX8::IsStickTiltOver(const LONG& kRTilt, const LONG& kRBorder) const
{
	bool isOver = (kRBorder <= kRTilt);

	return isOver;
}

/// XeBbŇX|ʂ|̈lȉǂ
bool JoystickDX8::IsStickTiltUnder(const LONG& kRTilt, const LONG& kRBorder) const
{
	bool isDown = (kRTilt <= kRBorder);

	return isDown;
}

/// {^̏ԂLǂ
bool JoystickDX8::IsEnableButton(const u8& kRButton) const
{
	return (0 < (kRButton & 0x80));
}

/// {^̏Ԃǂ
bool JoystickDX8::IsDisableButton(const u8& kRButton) const
{
	return !IsEnableButton(kRButton);
}

/// nbg̏ԂLǂ
bool JoystickDX8::IsEnablePOV(const DWORD& kRPOV, const int& kRPOVIndex) const
{
	bool isEnable = false;

	// MEMO:LȏꍇAk玞vɎpx100{̒l܂B
	// 0AE9000A18000A27000łB

	// AiO[hł̃nbg
	static const int stKIndicatorUnit = 9000;
	isEnable |= (kRPOV == stKIndicatorUnit * kRPOVIndex);

	return isEnable;
}

/// nbg̏Ԃǂ
bool JoystickDX8::IsDisablePOV(const DWORD& kRPOV, const int& kRIndex) const
{
	return !IsEnablePOV(kRPOV, kRIndex);
}

/// WCXeBbNXV
void JoystickDX8::UpdateJoystick(const float& kRDelta)
{
	HRESULT hr = DI_OK;

	// ̏Oɑ
	mJoystickStatus[eSTATE_OLD] = mJoystickStatus[eSTATE_CURRENT];

	// WCXeBbN̓͏Ԃ擾
	hr = mPDevice->GetInputDevice()->GetDeviceState(sizeof(DIJOYSTATE2), &mJoystickStatus[eSTATE_CURRENT]);

	// ͏Ԃ̎擾ɎsȂ
	if (FAILED(hr))
	{
		return;
	}

	// {^̐Ń[v
	for (int i = 0; i < mStKButtonCount; ++i)
	{
		const BYTE& kRButton = mJoystickStatus[eSTATE_CURRENT].rgbButtons[i];

		// Lȃ{^Ȃ
		if (IsEnableButton(kRButton))
		{
			mButtonStatus[i].UpdateDown(kRDelta);
		}
		// ȃ{^Ȃ
		else
		{
			mButtonStatus[i].UpdateUp(kRDelta);
		}
	}

	// \{^̐Ń[v
	for (int i = 0; i < mStKPOVCount; ++i)
	{
		const DWORD& kRPOV = mJoystickStatus[eSTATE_CURRENT].rgdwPOV[i];

		// \{^̐̕Ń[v
		for (int j = 0; j < PointOfViews::ePOV_COUNT; ++j)
		{
			// Lȏ\{^Ȃ
			if (IsEnablePOV(kRPOV, j))
			{
				mPOVStatus[i][j].UpdateDown(kRDelta);
			}
			// ȏ\{^Ȃ
			else
			{
				mPOVStatus[i][j].UpdateUp(kRDelta);
			}
		}
	}
}