#include "Blast/Input/InputManagerHelper.h"

#include "Blast/Input/IKeyboard.h"
#include "Blast/Input/IMouse.h"
#include "Blast/Input/IJoystick.h"
#include "Blast/Input/InputManager.h"

using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// L[{[h擾
IKeyboard* InputManagerHelper::GetKeyboard()
{
	// Cvbg}l[W[擾
	InputManager* pIM = GetInputManager();

	// L[{[h擾
	IKeyboard* pKeyboard = pIM->GetKeyboard();

	return pKeyboard;
}

/// }EX擾
IMouse* InputManagerHelper::GetMouse()
{
	// Cvbg}l[W[擾
	InputManager* pIM = GetInputManager();

	// }EX擾
	IMouse* pMouse = pIM->GetMouse();

	return pMouse;
}

/// WCXeBbN擾
IJoystick* InputManagerHelper::GetJoystick()
{
	// Cvbg}l[W[擾
	InputManager* pIM = GetInputManager();

	// WCXeBbN擾
	IJoystick* pJoystick = pIM->GetJoystick();

	return pJoystick;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// InputManager擾
InputManager* InputManagerHelper::GetInputManager()
{
	// Cvbg}l[W[擾
	InputManager* pIM = InputManager::GetInstance();

	// ASSERT:擾łȂ玀
	ASSERT_PRINTF(pIM, _T("InputManager擾ł܂łB"));

	return pIM;
}