#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
IndexBufferDX9::IndexBufferDX9() :
mSize(-1),
mPIndices(NULL)
{
}

/// fXgN^
IndexBufferDX9::~IndexBufferDX9()
{
	SAFE_DELETE_ARRAY(mPIndices);
}

/// CfbNXzݒ
void IndexBufferDX9::SetIndices(const int* pIndices, int count)
{
	// U
	SAFE_DELETE_ARRAY(mPIndices);

	// TCYێ
	mSize = sizeof(int) * count;

	// CfbNXz쐬
	mPIndices = NEW int[count];
	memcpy(mPIndices, pIndices, mSize);

	// obt@쐬
	CreateBuffer();
}

/// CfbNXobt@擾
IDirect3DIndexBuffer9* IndexBufferDX9::GetBuffer()
{
	return mPBuffer.GetInterface();
}

/// TCY擾
int IndexBufferDX9::GetSize() const
{
	return mSize;
}

/// CfbNX̐擾
int IndexBufferDX9::GetIndexCount() const
{
	return mSize / sizeof(int);
}

/// MEMO:Ƃ肠CfbNXobt@Ⴄ悤ɂĂ܂B
/// v~eBu擾
int IndexBufferDX9::GetPrimitiveCount() const
{
	// MEMO:Op`|Ŝ݂łȂAlp`|ST|[gꍇ͂̂܂܂ł͂܂B
	return GetIndexCount() / 3;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// obt@쐬
void IndexBufferDX9::CreateBuffer()
{
	// foCX擾
	GraphicsDeviceDX9* pRenderDeviceDX9 = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pRenderDeviceDX9->GetDevice();

	// CfbNXobt@쐬
	mPBuffer.SetInterfacePtr(NULL);
	HRESULT hr = pDevice->CreateIndexBuffer(mSize, 0, D3DFMT_INDEX32, D3DPOOL_DEFAULT, mPBuffer.ToCreator(), NULL);
	if (FAILED(hr))
	{
		HALT(_T("CfbNXobt@̍쐬Ɏs܂B\n"));
	}

	// CfbNXobt@ɃRs[
	void* pI = NULL;
	hr = mPBuffer->Lock(0, 0, (void**)&pI, 0);
	if (FAILED(hr))
	{
		HALT(_T("CfbNXobt@̃bNɎs܂\n"));
	}
	memcpy(pI, mPIndices, mSize);
	mPBuffer->Unlock();
}