#include "Blast/Graphic/DirectX9/FontTexture2DDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FontTexture2DDX9::FontTexture2DDX9()
{
}

/// fXgN^
FontTexture2DDX9::~FontTexture2DDX9()
{
}

/// eNX`쐬
void FontTexture2DDX9::CreateTexture(unsigned characterCode, const TCHAR* kPFontName, int fontSize, int fontWeight)
{
	// 쐬tHgp
	LOGFONT sLF;
	sLF.lfHeight = fontSize;
	sLF.lfWidth = 0;			// MEMO:0^ƍɉK؂ȒlɂȂ܂B
	sLF.lfEscapement = 0;
	sLF.lfOrientation = 0;
	sLF.lfWeight = fontWeight;
	sLF.lfItalic = 0;
	sLF.lfUnderline = 0;
	sLF.lfStrikeOut = 0;
	sLF.lfCharSet = SHIFTJIS_CHARSET;
	sLF.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	sLF.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	sLF.lfQuality = PROOF_QUALITY;
	sLF.lfPitchAndFamily = DEFAULT_PITCH | FF_MODERN;
	memcpy(sLF.lfFaceName, kPFontName, sizeof(sLF.lfFaceName));

	// tHgnh쐬
	HFONT hFont = CreateFontIndirect(&sLF);

	// foCXReLXgݒ
	HDC hdc = GetDC(NULL);
	HFONT oldFont = (HFONT)SelectObject(hdc, hFont);


	// MEMO:Œ̂悤łB
	// rbg}bv擾ۂɓnsp
	const MAT2 mat =
	{
		{ 0, 1 },
		{ 0, 0 },
		{ 0, 0 },
		{ 0, 1 },
	};

	// rbg}bvi[̂ɕKvȃoCg擾
	DWORD size = GetGlyphOutline(
		hdc,
		characterCode,
		GGO_GRAY4_BITMAP,
		&mSGlyphMetrics,
		0,
		NULL,
		&mat);

	// rbg}bv擾
	BYTE* pBytes = NEW BYTE[size];
	GetGlyphOutline(
		hdc,
		characterCode,
		GGO_GRAY4_BITMAP,
		&mSGlyphMetrics,
		size,
		pBytes,
		&mat);


	// foCXQ
	GraphicsDeviceDX9* pGraphiceDeviceDX9 = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphiceDeviceDX9->GetDevice();


	// eNX`̃TCYZo
	int fontWidth = MathHelper::GetOverMultiple(mSGlyphMetrics.gmBlackBoxX, 4);
	int fontHeight = mSGlyphMetrics.gmBlackBoxY;

	// eNX`쐬
	pDevice->CreateTexture(fontWidth, fontHeight, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED, mPTexture.ToCreator(), NULL); 


	// eNX`̈̏bN
	D3DLOCKED_RECT sLockedRect;
	mPTexture->LockRect(0, &sLockedRect, NULL, 0);
	{
		// MEMO:GGO_GRAY4_BITMAP̊K17łB
		// ~w
		const int kGradationCount = 16;

		// bN̈J[obt@ƂĎQ
		DWORD* pTextureBuffer = (DWORD*)sLockedRect.pBits;

		// rbg}bṽsNZŃ[v
		for (int i = 0; i < fontWidth * fontHeight; ++i)
		{
			// lZo
			DWORD alpha = pBytes[i] * 255 / kGradationCount;

			// sNZ̐FZo
			unsigned pixelColor = (alpha << 24) | 0x00ffffff;

			// F
			pTextureBuffer[i] = pixelColor;
		}
	}
	// eNX`AbN
	mPTexture->UnlockRect(0); 


	// T[tFCX쐬
	CreateSurfaceByTexture();


	// Ȃ̂
	SAFE_DELETE_ARRAY(pBytes);
	SelectObject(hdc, oldFont);
	ReleaseDC(NULL, hdc);
}


/// MEMO:eNX`̉͊4oCgAĈ͂BĂ炱ŃI[o[Ch܂傤B
/// 擾
int FontTexture2DDX9::GetWidth() const
{
	// MEMO:rbg}bṽACg4oCgłB
	const int kByteAlignment = 4;
	s32 width = MathHelper::GetOverMultiple(mSGlyphMetrics.gmBlackBoxX, kByteAlignment);

	return width;
}