#include "Blast/IO/File.h"

#include <stdio.h>
#include <stdarg.h>
#include "Blast/Storage/Directory.h"

using namespace std;
using namespace Blast::IO;
using namespace Blast::Storage;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
File::File() : 
mPFile(NULL)
{
}

/// fXgN^
File::~File()
{
	// t@C
	Close();
}

/// t@CWJ
bool File::Open(const TCHAR* kPFullPath, const TCHAR* kPMode)
{
	// pXێ
	mFullPathStr = kPFullPath;


	// ΃pXɕϊ
	TCHAR absFullPath[Directory::mStKMaxPath];
	Directory::ToAbsolutePath(kPFullPath, absFullPath);

	// t@CWJ
	_tfopen_s(&mPFile, absFullPath, kPMode);

	// WARNING:WJɎsȂx
	WARNING(mPFile, _T("t@C̓WJɎs܂B\n%s"), kPFullPath);


	// t@CJȂ
	if (mPFile)
	{
		return true;
	}
	// t@CJȂ
	else
	{
		return false;
	}
}

/// t@C
void File::Close()
{
	fclose(mPFile);
}


/// V[Nʒu擾
long File::GetSeekPosition()
{
	return ftell(mPFile);
}

/// V[NʒuύX
void File::Seek(int shift)
{
	fseek(mPFile, shift, SEEK_CUR);
}

/// V[Nʒu擪ɐݒ
void File::SeekStart()
{
	fseek(mPFile, 0, SEEK_SET);
}

/// V[NʒuŌɐݒ
void File::SeekEnd()
{
	fseek(mPFile, 0, SEEK_END);
}

/// EOFǂ擾
bool File::IsEOF()
{
	bool isEOF = feof(mPFile) ? true : false;

	return isEOF;
}


/// ǂݍ
void File::Read(TCHAR pOut[], int streamSize)
{
	fread(pOut, sizeof(TCHAR), streamSize, mPFile);
}

/// sǂݍ
void File::ReadLine(TCHAR pOut[], int streamSize)
{
	// s擾
	_fgetts(pOut, streamSize, mPFile);
}

/// tH[}bgwɉēǂݍ
void File::ReadFormat(const TCHAR* kPFormat, void* pOut, const int* pStringCount)
{
	// MEMO:擾ۂɂ͕̎w肪K{łB
	// ̃TCYw肪Ȃ
	if (pStringCount)
	{
		_ftscanf_s(mPFile, kPFormat, pOut, *pStringCount);
	}
	else
	{
		_ftscanf_s(mPFile, kPFormat, pOut);
	}
}


/// 
void File::Write(const TCHAR* pText)
{
	_fputts(pText, mPFile);
}

/// s
void File::WriteLine(const TCHAR* pText)
{
	Write(pText);
	Write(_T("\n"));
}


/// t@CIuWFNg擾
const FILE* File::GetFileObject() const
{
	return mPFile;
}

/// t@CIuWFNg擾
FILE* File::GetFileObject()
{
	return mPFile;
}


/// pX擾
const tstring& File::GetFullPathRef() const
{
	return mFullPathStr;
}