#include "Blast/Graphic/Fade.h"

#include "Blast/Graphic/DirectX9/Texture2DDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Fade::Fade()
	: mEState(eSTATE_END)
	, mEDirection(eDIRECTION_IN)
	, mIsPause(false)
	, mDurationTime(0)
	, mElapsedTime(0)
	, mIsUniversal(false)
	, mFadeColor( ColorCode::ToCode(ColorCode::eCOLOR_BLACK) )
{
	// bV쐬
	MeshSpriteDX9* pMesh = NEW MeshSpriteDX9(2.0f, 2.0f);
	mPMesh.SetPointer(pMesh);

	// VF[_[GtFNg쐬
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShaderEffect = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_FADE));
}

/// fXgN^
Fade::~Fade()
{
}

/// XV
void Fade::Update(float delta)
{
	// Ԃŕ
	switch (mEState)
	{
		/// tF[hJn
		case eSTATE_START:
			
			// oߎԂZbg
			mElapsedTime = 0;

			// tF[hɏԂJ
			mEState = eSTATE_FADING;

			break;

		/// tF[h
		case eSTATE_FADING:
		{
			// |[YłȂȂ
			if (!mIsPause)
			{
				// oߎԂZ
				mElapsedTime += delta;

				// oߎԂtF[h܂łɂ鎞Ԃ𒴂
				if (mDurationTime < mElapsedTime)
				{
					// Nv
					mElapsedTime = mDurationTime;

					// ԂύX
					mEState = eSTATE_END;
				}
			}
		}
			break;

		/// tF[hI
		case eSTATE_END:
			break;

		/// P[XOȂ
		default:
			HALT(_T("P[XȌԂɂȂ܂B"));
			break;
	}
}

/// `
void Fade::Render()
{
	// OtBbNfoCXQ
	GraphicsDeviceDX9* pGD = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGD->GetDevice();


	// ԎԂݒ
	float durationTime = static_cast<float>(mDurationTime);
	mPShaderEffect->SetValue("gDurationTime", &durationTime, sizeof(durationTime));

	// ԎԂ̔ݒ
	float halfDurationTime = static_cast<float>(mDurationTime * 0.5);
	mPShaderEffect->SetValue("gHalfDurationTime", &halfDurationTime, sizeof(halfDurationTime));

	// oߎԂݒ
	float elapsedTime = static_cast<float>(mElapsedTime);
	mPShaderEffect->SetValue("gElapsedTime", &elapsedTime, sizeof(elapsedTime));

	// tF[hCǂݒ
	int fadeDirectionIn = (mEDirection == eDIRECTION_IN) ? 1 : 0;
	mPShaderEffect->SetValue("gFadeDirectionIn", &fadeDirectionIn, sizeof(fadeDirectionIn));

	// MEMO:HLSLbool^4oCg̃rbOGfBAȂ̂ŁA1oCgłC++bool^𒼐ړnĂlɂȂȂB
	//      ̂߁Axint^ɓĂVF[_[ɒʒmĂ܂B
	// jo[Tǂݒ
	Int32 isUniversal = mIsUniversal;
	mPShaderEffect->SetValue("gIsUniversal", &isUniversal.GetValueRef(), Int32::GetSize());
	

	// tF[hFݒ
	mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, mFadeColor.GetArray(), Color::mStKColorFactorCount);

	// eNX`ݒ
	SetTextureToShader();

	// eNjbNݒ
	mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_SOLID_WIREFRAME);

	// `Jn
	unsigned passCount = 0;
	mPShaderEffect->Begin(&passCount);
	{
		// pX̐Ń[v
		for (unsigned i = 0; i < passCount; ++i)
		{
			// `pXJn
			mPShaderEffect->BeginPass(i);
			{
				// bV`
				mPMesh->Render();
			}
			mPShaderEffect->EndPass();
		}
	}
	mPShaderEffect->End();
}


/// tF[hJn
void Fade::StartFade()
{
	// oߎԂZbg
	mElapsedTime = 0;

	// ꎞ~Ԃ
	mIsPause = false;

	// jo[TtO~낷
	mIsUniversal = false;


	// ԂtF[hJnԂɐݒ
	mEState = eSTATE_START;
}

/// jo[TgWVJn
void Fade::StartUniversal()
{
	// oߎԂZbg
	mElapsedTime = 0;

	// ꎞ~Ԃ
	mIsPause = false;

	// jo[TtO𗧂Ă
	mIsUniversal = true;


	// ԂtF[hԂɐݒ
	mEState = eSTATE_FADING;
}

/// I
void Fade::End()
{
	// oߎԂɃtF[h܂łɂ鎞Ԃݒ
	mElapsedTime = mDurationTime;

	// ԂIԂɐݒ
	mEState = eSTATE_END;
}

/// ꎞ~
void Fade::Pause()
{
	mIsPause = true;
}

/// ĊJ
void Fade::Resume()
{
	mIsPause = false;
}


/// tF[hǂ
bool Fade::IsFading() const
{
	// MEMO:vĂƃtF[hĂ̂ŁAtł͂܂B
	bool isFading = (0 <= mElapsedTime) || (mElapsedTime < mDurationTime);

	return isFading;
}

/// tF[hIĂ邩ǂ
bool Fade::IsEnd() const
{
	bool isEnd = (mDurationTime <= mElapsedTime);

	return isEnd;
}

/// ꎞ~Ă邩ǂ
bool Fade::IsPause() const
{
	return mIsPause;
}


/// tF[h̕擾
Fade::EDirection Fade::GetDirection() const
{
	return mEDirection;
}

/// tF[h̕ݒ
void Fade::SetDirection(EDirection eDirection)
{
	mEDirection = eDirection;
}


/// tF[hɂ鎞Ԃ擾
double Fade::GetDurationTime() const
{
	return mDurationTime;
}

/// tF[hɂ鎞Ԃݒ
void Fade::SetDurationTime(double time)
{
	mDurationTime = time;
}

/// tF[hJňoߎԂ擾
double Fade::GetElapsedTime() const
{
	return mElapsedTime;	
}

/// MEMO:0ōŏA1ŊłB
/// tF[h̐iSŎ擾
double Fade::GetPercentage() const
{
	// Ԃ0Ȃ
	if (mDurationTime == 0)
	{
		return 0;
	}
	// Ԃ0łȂȂ
	else
	{
		// S
		double per = mElapsedTime / mDurationTime;

		return per;
	}
}


/// tF[hF擾
const Color& Fade::GetColorRef() const
{
	return mFadeColor;
}

/// tF[hFݒ
void Fade::SetColor(const Color& kRColor)
{
	mFadeColor = kRColor;
}


/// fBt[YeNX`ݒ
void Fade::SetDiffuseTexture(SP<Blast::Graphic::ITexture2D> pTexture)
{
	mPTextures[eTEXTURE_DIFFUSE] = pTexture;
}

/// [eNX`ݒ
void Fade::SetRuleTexture(SP<Blast::Graphic::ITexture2D> pTexture)
{
	mPTextures[eTEXTURE_RULE] = pTexture;

	// MEMO:NCAg菬eNX`ȂA^Cɕ~l߂Ɨǂł傤B
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// VF[_[ɃeNX`ݒ
void Fade::SetTextureToShader()
{
	// eNX`̐Ń[v
	for (int i = 0; i < eTEXTURE_COUNT; ++i)
	{
		// eNX`LXg
		SP<Texture2DDX9> pTexture;
		bool isSuccess = pTexture.DownCast(mPTextures[i]);

		// LXgɐȂ
		if (isSuccess)
		{
			// eNX`̎ނŕ
			ShaderEffectDX9::EVariable eVariableTexture = ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE;	//< eLg[ȏl
			switch (i)
			{
				// fBt[YȂ
				case eTEXTURE_DIFFUSE:	eVariableTexture = ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE;
					break;

				// [Ȃ
				case eTEXTURE_RULE:		eVariableTexture = ShaderEffectDX9::eVARIABLE_RULE_TEXTURE;
					break;

				// P[XOȂ
				default:
					break;
			}

			mPShaderEffect->SetTexture(eVariableTexture, pTexture->GetTexturePtrRef().GetInterface());
		}
	}
}