// FPSvNXt@C

#include "Blast/Base/FPSCounter_C.h"

// RXgN^
CFPSCounter::CFPSCounter(unsigned int smp)
{
    // Tv̐ݒ
    SetSampleNum(smp);

    // v鎞v̑I
    if(QueryPerformanceCounter( &m_Counter ) != 0)
    {
        // QueryPerformanceCounter֐gtO
        m_iCounterFlag = FPSCOUNTER_QUERYPER_COUNTER;
        m_OldLongCount = m_Counter.QuadPart;        // ̎iNbNj擾
        LARGE_INTEGER Freq;
        QueryPerformanceFrequency( &Freq );            // 1bNbN擾
        m_dFreq = (double)Freq.QuadPart;
    }
    else
    {
        // timeGetTime֐gtO
        m_iCounterFlag = FPSCOUNTER_TIMEGETTIME;

        // xグ
        timeBeginPeriod(1);

        // ̎i~bj擾
        m_dwTGTOldCount = timeGetTime();
    }

    // v
    GetFPS();
}


// fXgN^
CFPSCounter::~CFPSCounter(void)
{
    if(m_iCounterFlag == FPSCOUNTER_TIMEGETTIME)
        timeEndPeriod(1);    // ^C}[̐x߂
}


// FPSl擾
double CFPSCounter::GetFPS()
{
    double Def = GetCurDefTime();
    if(Def == 0){
        // vZłȂ̂łԂ
        return 0;
    }

    return UpdateFPS( Def );
}


// ݂̍~bPʂŎ擾
double CFPSCounter::GetCurDefTime()
{
    // Ԃv
    if(m_iCounterFlag == FPSCOUNTER_QUERYPER_COUNTER)
    {
        // QueryPerformanceCounter֐ɂv
        QueryPerformanceCounter( &m_Counter );                     // ݂̎擾A
        LONGLONG LongDef = m_Counter.QuadPart - m_OldLongCount;    // JEgZoB
        double dDef = (double)LongDef;                             // {x_ɕϊ
        m_OldLongCount = m_Counter.QuadPart;                       // ݂̎ێ
        return dDef*1000 / m_dFreq;                                // Ԃ~bPʂŕԂ
    }

    // timeGetTime֐ɂv
    DWORD CurTime = timeGetTime();
    DWORD CurDef = CurTime - m_dwTGTOldCount;         // JEgZo
    m_dwTGTOldCount = CurTime;                        // ݂̎ێ
    return CurDef;
}


// FPSXV
double CFPSCounter::UpdateFPS( double Def )
{
    // łÂf[^
    m_dwDefTimeLst.pop_front();

    // Vf[^ǉ
    m_dwDefTimeLst.push_back( Def );

    // FPSZo
    double FPS;
    double AveDef = (m_dwSumTimes + Def) / m_uiNum;
    if(AveDef != 0)
        FPS = 1000.0 / AveDef;

    // ʉZ̍XV
    m_dwSumTimes += Def - *m_dwDefTimeLst.begin();

    return FPS;
}


// TvύX
void CFPSCounter::SetSampleNum( unsigned int smp)
{
	// ςvZ
    m_uiNum = smp;

	// Xg
    m_dwDefTimeLst.resize(smp, 0);
    m_dwSumTimes = 0;
} 
