#include "Blast/Frontend/FEMenuEntryText.h"

#include "Blast/Graphic/DirectX9/FontDX9.h"
#include "Blast/Graphic/TextRendererColorTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Frontend;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FEMenuEntryText::FEMenuEntryText()
	: mTextStr(_T("Missing"))
	, mIsInputable(true)
	, mIsEnable(true)
	, mIsVisible(true)
	, mIsSelectable(true)
	, mIsSelected(false)
{
	// ŕ`悷邽߂̋@\쐬ĂB
	// Oݒ肷邱Ƃł̂ňꉞ̓tLVuB
	// tHg쐬
	SP<FontDX9> pFont(NEW FontDX9());
	pFont->CreateFontData(FontDX9::stKPFontName, 12);

	mPTextRenderer.SetPointer(NEW TextRendererColorTag(pFont));
}

/// fXgN^
FEMenuEntryText::~FEMenuEntryText()
{
}


/// 
void FEMenuEntryText::HandleInput(float delta)
{
}

/// XV
void FEMenuEntryText::Update(float delta)
{
}

/// `
void FEMenuEntryText::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// `悷
	if (mPCamera)
	{
		// IԂɂĐFύXB
		// IԂωɂݒ肷ǂH@ȂƂȂH
		Color color = mPTextRenderer->GetBasicColor();
		if (mIsSelected)
		{
			color = Color::GetPreset(ColorCode::eCOLOR_LIGHTSALMON);
		}
		else
		{
			color = Color::GetPreset(ColorCode::eCOLOR_WHITE);
		}
		mPTextRenderer->SetBasicColor(color);
		
		mPTextRenderer->Render();
	}
}

/// IԂݒ肷
void FEMenuEntryText::SetSelected(bool value)
{
	mIsSelected = value;
}

/// O擾
const TCHAR* FEMenuEntryText::GetName() const
{
	return mNameStr.c_str();
}

/// ʒuݒ
void FEMenuEntryText::SetPosition(const Vector3& kRPosition)
{
	mPTextRenderer->SetPosition(kRPosition);
}

/// c擾
float FEMenuEntryText::GetHeight() const
{
	const float kHeight = static_cast<float>( mPTextRenderer->GetFont()->GetPointSize() );
	return kHeight;
}

/// Jݒ
void FEMenuEntryText::SetCamera(const SP<ICamera> pCamera)
{
	mPCamera = pCamera;
	mPTextRenderer->SetCamera(pCamera);
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// Oݒ
void FEMenuEntryText::SetName(const TCHAR* kPName)
{
	mNameStr = kPName;
}

/// `悷eLXg擾
const TCHAR* FEMenuEntryText::GetText() const
{
	return mTextStr.c_str();
}

/// `悷eLXgݒ肷
void FEMenuEntryText::SetText(const TCHAR* kPText)
{
	mTextStr = kPText;
	mPTextRenderer->SetText(kPText);
}

/// eLXg_[擾
SP<ITextRenderer> FEMenuEntryText::GetTextRenderer()
{
	return mPTextRenderer;
}

/// ̓tO擾
bool FEMenuEntryText::IsInputable() const
{
	return mIsInputable;
}

/// ̓tOݒ
void FEMenuEntryText::SetInputable(bool value)
{
	mIsInputable = value;
}

/// XVtO擾
bool FEMenuEntryText::IsEnable() const
{
	return mIsEnable;
}

/// XVtOݒ
void FEMenuEntryText::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool FEMenuEntryText::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void FEMenuEntryText::SetVisible(bool value)
{
	mIsVisible = value;
}