#include "Blast/Frontend/FEMenuEntryImage.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Frontend;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FEMenuEntryImage::FEMenuEntryImage()
	: mNameStr(_T("Missing"))
	, mIsInputable(true)
	, mIsEnable(true)
	, mIsVisible(true)
	, mIsSelectable(true)
	, mIsSelected(false)
	, mIsSelectedColorReflection(true)
	, mIsSelectedImageReflection(false)
{
}

/// fXgN^
FEMenuEntryImage::~FEMenuEntryImage()
{
}


/// 
void FEMenuEntryImage::HandleInput(float delta)
{
}

/// XV
void FEMenuEntryImage::Update(float delta)
{
	if (mPSprite)
	{
		// ʒuݒ
		mPosition.mZ = 0;
		mPSprite->SetPosition(mPosition);
		mPSelectedSprite->SetPosition(mPosition);

		// FݒBʃeNX`ւ̕\ύX̕ǂƂ͎vB
		Color color = Color::GetPreset(ColorCode::eCOLOR_WHITE);
		if (mIsSelected && mIsSelectedColorReflection)
		{
			color = Color::GetPreset(ColorCode::eCOLOR_RED);
		}
		mPSprite->SetColor(color);
		mPSelectedSprite->SetColor(color);

		// XvCg̍XV
		mPSprite->Update(delta);
		mPSelectedSprite->Update(delta);
	}
}

/// `
void FEMenuEntryImage::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// 摜`悷
	ASSERT_PF(mPCamera, _T("Jݒ肳Ă܂B"));
	ASSERT_PF(mPSprite, _T("XvCgݒ肳Ă܂B"));
	if (mPCamera && mPSprite)
	{
		mPSprite->SetCamera(mPCamera); //< Jݒ莞ɂ̓XvCgϐ\̂łŐݒ
		mPSelectedSprite->SetCamera(mPCamera);

		// `悷XvCgύXB
		// `悵ȂXV肵Ă̂ŁAʂƗǂB
		SP<SpriteDX9> pSprite = (mIsSelected && mIsSelectedImageReflection) ? mPSelectedSprite : mPSprite;
		pSprite->Render();
	}
}

/// IԂݒ肷
void FEMenuEntryImage::SetSelected(bool value)
{
	mIsSelected = value;
}

/// O擾
const TCHAR* FEMenuEntryImage::GetName() const
{
	return mNameStr.c_str();
}

/// ʒuݒ
void FEMenuEntryImage::SetPosition(const Vector3& kRPosition)
{
	mPosition = kRPosition;
}

/// c擾
float FEMenuEntryImage::GetHeight() const
{
	// XvCg̗Ldv
	if (mPSprite)
	{
		const Vector2& kRSize = mPSprite->GetSize();
		return kRSize.mY;
	}

	return 0;
}

/// Jݒ
void FEMenuEntryImage::SetCamera(const SP<ICamera> pCamera)
{
	mPCamera = pCamera;
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// Oݒ
void FEMenuEntryImage::SetName(const TCHAR* kPName)
{
	mNameStr = kPName;
}

/// XvCg擾
SP<SpriteDX9> FEMenuEntryImage::GetSprite()
{
	return mPSprite;
}

/// XvCgݒ
void FEMenuEntryImage::SetSprite(SP<SpriteDX9> value)
{
	mPSprite = value;
	if (!mPSelectedSprite)
	{
		mPSelectedSprite = value;
	}
}

/// I𒆂̃XvCg擾
SP<SpriteDX9> FEMenuEntryImage::GetSelectedSprite()
{
	return mPSelectedSprite;
}

/// I𒆂̃XvCgݒ
void FEMenuEntryImage::SetSelectedSprite(SP<SpriteDX9> value)
{
	mPSelectedSprite = value;
}

/// ̓tO擾
bool FEMenuEntryImage::IsInputable() const
{
	return mIsInputable;
}

/// ̓tOݒ
void FEMenuEntryImage::SetInputable(bool value)
{
	mIsInputable = value;
}

/// XVtO擾
bool FEMenuEntryImage::IsEnable() const
{
	return mIsEnable;
}

/// XVtOݒ
void FEMenuEntryImage::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool FEMenuEntryImage::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void FEMenuEntryImage::SetVisible(bool value)
{
	mIsVisible = value;
}

/// I̐FύXtO擾
bool FEMenuEntryImage::IsSelectedColorReflection() const
{
	return mIsSelectedColorReflection;
}

/// I̐FύXtOݒ
void FEMenuEntryImage::SetSelectedColorReflection(bool value)
{
	mIsSelectedColorReflection = value;
}

/// Ỉ摜ύXtO擾
bool FEMenuEntryImage::IsSelectedImageReflection() const
{
	return mIsSelectedImageReflection;
}

/// Ỉ摜ύXtOݒ
void FEMenuEntryImage::SetSelectedImageReflection(bool value)
{
	mIsSelectedImageReflection = value;
}
