#include "Blast/Frontend/FEMenu.h"

#include <iterator>
#include "Blast/Input/InputManager.h"
#include "Blast/Input/PadInputTag.h"

using namespace Blast::Base;
using namespace Blast::Frontend;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FEMenu::FEMenu()
{
	Construct();
}

/// fXgN^
FEMenu::~FEMenu()
{
	Destruct();
}


/// 
void FEMenu::Initialize()
{
	mItems.clear();

	mNameStr = _T("Missing");
	mIsInputable = true;
	mIsEnable = true;
	mIsVisible = true;
	mSelectedIndex = 0;

	mPosition = Vector3::Zero();

	mDisplayCount = 777; //< l͑Sĕ\̂ŁA傫ȒlɂĂ
	mDisplayStartIndex = 0;
	mLineSpacing = 0;

	mEInputResultTag = PadInputTag::eINPUT_RESULT_NONE;
}


/// 
void FEMenu::HandleInput(float delta)
{
	mEInputResultTag = PadInputTag::eINPUT_RESULT_NONE;

	if (!mIsInputable)
	{
		return;
	}

	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();
	IMouse* pMouse = pIM->GetMouse();

	// 肷
	if (pKB->IsJustDown(Keys::eKEY_RETURN) ||
		pKB->IsJustDown(Keys::eKEY_Z) ||
		pMouse->IsJustDown(Buttons::eBUTTON_LEFT))
	{
		mEInputResultTag = PadInputTag::eINPUT_RESULT_DECIDE;
	}

	// 
	if (pKB->IsJustDown(Keys::eKEY_X) ||
		pMouse->IsJustDown(Buttons::eBUTTON_RIGHT))
	{
		mEInputResultTag = PadInputTag::eINPUT_RESULT_CANCEL;
	}

	// ڂȂ炱return
	if (mItems.empty())
	{
		return;
	}

	// ڂI
	if (pKB->IsJustDown(Keys::eKEY_UP) ||
		pKB->IsJustDown(Keys::eKEY_W) ||
		pMouse->IsWheelUp())
	{
		SelectBack();
	}
	else if (pKB->IsJustDown(Keys::eKEY_DOWN) ||
		pKB->IsJustDown(Keys::eKEY_S) ||
		pMouse->IsWheelDown())
	{
		SelectNext();
	}

	// IԂݒ
	ItemList::iterator it;
	for (it = mItems.begin(); it != mItems.end(); ++it)
	{
		(*it)->SetSelected(false);
	}

	it = mItems.begin();
	std::advance(it, mSelectedIndex);
	(*it)->SetSelected(true);

	// IĂ鍀ڂ̓͏
	SP<IFEMenuEntry> pSelectedItem = GetSelectedItem();
	if (pSelectedItem)
	{
		pSelectedItem->HandleInput(delta);
	}
}

/// XV
void FEMenu::Update(float delta)
{
	if (!mIsEnable ||
		mItems.empty())
	{
		return;
	}

	// MEMO:XV͑SĂɍs܂B

	// eڂ̍XV
	ItemList::iterator it = mItems.begin();
	std::advance(it, mDisplayStartIndex);

	// ʒuBe퍀ڂŉZĂB
	Vector3 offset = mPosition;

	for (int i = 0; i < mDisplayCount; ++i)
	{
		(*it)->SetPosition(offset);

		//@ڂ̍XV
		(*it)->Update(delta);

		// HACK:̍ڂׁ̈AʒuZBڂ̑̈ŏI点ǂȂH
		offset.mY += (*it)->GetHeight();	//< ڂ̏c
		offset.mY += mLineSpacing;			//< s

		// ̍ڂ
		++it;
		if (it == mItems.end())
		{
			break;
		}
	}
}

/// `
void FEMenu::Render()
{
	if (!mIsVisible ||
		mItems.empty())
	{
		return;
	}

	// ڂ̕`Bw肵Ă鍀ڐ̕`悷B
	ItemList::iterator it = mItems.begin();
	std::advance(it, mDisplayStartIndex);
	for (int i = 0; i < mDisplayCount; ++i)
	{
		// ڂ`
		(*it)->Render();

		++it;

		// ͈͊O
		if (it == mItems.end())
		{
			break;
		}
	}
}


/// ڂǉ
void FEMenu::AddItem(SP<IFEMenuEntry> pItem)
{
	mItems.push_back(pItem);
}

/// ڂO
void FEMenu::RemoveItem(SP<IFEMenuEntry> pItem)
{
	ItemList::iterator it;
	for (it = mItems.begin(); it != mItems.end(); ++it)
	{
		if ((*it) == pItem)
		{
			mItems.erase(it);
		}
	}
}

/// ڂ̃Xg擾
const FEMenu::ItemList* FEMenu::GetItems() const
{
	return &mItems;
}

/// ڂ̃Xg擾
FEMenu::ItemList* FEMenu::GetItems()
{
	return &mItems;
}

/// ڂ擾BCfbNXwB
SP<IFEMenuEntry> FEMenu::GetItem(int index)
{
	// UNDONE:G[
	ItemList::iterator it = mItems.begin();
	std::advance(it, index);
	return (*it);
}

/// ڂ擾BOwB
SP<IFEMenuEntry> FEMenu::GetItem(const TCHAR* kPName)
{
	ItemList::iterator it;
	for (it = mItems.begin(); it != mItems.end(); ++it)
	{
		if ( _tcscmp(kPName, (*it)->GetName()) == 0 )
		{
			return (*it);
		}
	}

	return SP<IFEMenuEntry>();
}

/// IĂ鍀ڂ擾
SP<IFEMenuEntry> FEMenu::GetSelectedItem()
{
	return GetItem(mSelectedIndex);
}

/// ڂNA
void FEMenu::Clear()
{
	mItems.clear();
}

/// ڂ1ǂ擾
bool FEMenu::IsEmpty()
{
	return mItems.empty();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// O擾
const TCHAR* FEMenu::GetName() const
{
	return mNameStr.c_str();
}

/// Oݒ
void FEMenu::SetName(const TCHAR* pValue)
{
	mNameStr = pValue;
}

/// ͏tO擾
bool FEMenu::IsInputable() const
{
	return mIsInputable;
}

/// ͏tOݒ
void FEMenu::SetInputable(bool value)
{
	mIsInputable = value;
}

/// XVtO擾
bool FEMenu::IsEnable() const
{
	return mIsEnable;
}

/// XVtOݒ
void FEMenu::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `揈tO擾
bool FEMenu::IsVisible() const
{
	return mIsVisible;
}

/// `揈tOݒ
void FEMenu::SetVisible(bool value)
{
	mIsVisible = value;
}

/// IĂCfbNX擾
int FEMenu::GetSelectedIndex() const
{
	return mSelectedIndex;
}

/// IĂCfbNXݒ
void FEMenu::SetSelectedIndex(int value)
{
	mSelectedIndex = value;
}

/// ڂ̕`Jnʒu擾
const Vector3& FEMenu::GetPosition() const
{
	return mPosition;
}

/// ڂ̕`Jnʒuݒ
void FEMenu::SetPosition(const Vector3& value)
{
	mPosition = value;
}

/// xɕ\鍀ڐ擾
int FEMenu::GetDisplayCount() const
{
	return mDisplayCount;
}

/// xɕ\鍀ڐݒ
void FEMenu::SetDisplayCount(int value)
{
	mDisplayCount = value; 
}

/// \鍀ڂ̊JnCfbNX擾
int FEMenu::GetDisplayStartIndex() const
{
	return mDisplayStartIndex;
}

/// \鍀ڂ̊JnCfbNXݒ
void FEMenu::SetDisplayStartIndex(int value)
{
	mDisplayStartIndex = value;
}

/// sԂ擾
float FEMenu::GetLineSpacing() const
{
	return mLineSpacing;
}

/// sԂݒ
void FEMenu::SetLineSpacing(float value)
{
	mLineSpacing = value;
}

/// ͌ʂ擾
PadInputTag::EPadInputTag FEMenu::GetInputResultTag() const
{
	return mEInputResultTag;
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// 
void FEMenu::Construct()
{
	Initialize();
}

/// p
void FEMenu::Destruct()
{
}

/// O̍ڂI
void FEMenu::SelectBack()
{
	// UNDONE:[v
	--mSelectedIndex;

	// ͈͊O
	if (mSelectedIndex < 0)
	{
		mSelectedIndex = 0;
	}
	else
	{
		mEInputResultTag = PadInputTag::eINPUT_RESULT_SELECT;
	}
}

/// ̍ڂI
void FEMenu::SelectNext()
{
	// UNDONE:[v
	++mSelectedIndex;

	// ͈͊O
	int size = mItems.size();
	if (size <= mSelectedIndex)
	{
		mSelectedIndex = mItems.size() - 1;
	}
	else
	{
		mEInputResultTag = PadInputTag::eINPUT_RESULT_SELECT;
	}
}