#include "Blast/Graphic/Color.h"

using namespace Blast::Graphic;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ̐ԐF
const float Color::mStKInitialRed = 1.0f;

/// ̗ΐF
const float Color::mStKInitialGreen = 1.0f;

/// ̐F
const float Color::mStKInitialBlue = 1.0f;

/// ̃
const float Color::mStKInitialAlpha = 1.0f;


/// vZbgF擾
Color Color::GetPreset(ColorCode::EColor eColor)
{
	return ColorCode::ToCode(eColor);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Color::Color() :
mRed(mStKInitialRed),
mGreen(mStKInitialGreen),
mBlue(mStKInitialGreen),
mAlpha(mStKInitialAlpha)
{
}

/// RXgN^Be
Color::Color(const float& kRRed, const float& kRGreen, const float& kRBlue, const float& kRAlpha) :
mRed(kRRed),
mGreen(kRGreen),
mBlue(kRBlue),
mAlpha(kRAlpha)
{
}

/// RXgN^Be
Color::Color(const unsigned& kRARGB) :
mRed(0),
mGreen(0),
mBlue(0),
mAlpha(0)
{
	// 1oCgɕ
	u8 bytes[mStKColorFactorCount];
	SepareteUnsignedARGB(kRARGB, bytes);

	// eF֑
	mAlpha = ToFloat(bytes[0]);
	mRed = ToFloat(bytes[1]);
	mGreen = ToFloat(bytes[2]);
	mBlue = ToFloat(bytes[3]);
}

/// fXgN^
Color::~Color()
{
}

/// F𕄍32bitƂĎ擾
unsigned Color::GetARGB() const
{
	u8 r = ToByte(mRed);
	u8 g = ToByte(mGreen);
	u8 b = ToByte(mBlue);
	u8 a = ToByte(mAlpha);

	unsigned color = 0;
	color |= (a << 24);
	color |= (r << 16);
	color |= (g << 8);
	color |= (b << 0);

	return color;
}

/// F𕄍Ȃ32bitƂĐݒ
void Color::SetARGB(unsigned argb)
{
	// eFɕ
	u8 colorFactors[mStKColorFactorCount];

	SepareteUnsignedARGB(argb, colorFactors);

	// MEMO:z񉉎ZqI[o[[h΁Afor[vŕЂt܂B

	// eFPʉ
	int index = 0;
	float a = ToFloat(colorFactors[index++]);
	float r = ToFloat(colorFactors[index++]);
	float g = ToFloat(colorFactors[index++]);
	float b = ToFloat(colorFactors[index++]);

	// eFɐݒ
	mAlpha = a;
	mRed = r;
	mGreen = g;
	mBlue = b;
}
			

//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// 0.0f`1.0f0`2551oCgŕ\ł͈͂ɕϊ
u8 Color::ToByte(const float& kRValue) const
{
	// MEMO:e^IuWFNgƕ֗Ȃ̂낤H

	const unsigned kMax = 255;

	u8 b = static_cast<u8>(kMax * kRValue);

	return b;
}

/// 0`2550.0f`1.0f͈̔͂ŕ\ł͈͂ɕϊ
float Color::ToFloat(const u8& kRValue) const
{
	float f = kRValue / static_cast<float>(mStKMaxColorByte);

	return f;
}

/// 32bit^eF1oCgŎ擾
void Color::SepareteUnsignedARGB(const unsigned& color, u8 outBytes[mStKColorFactorCount])
{
	// o͕ϐ
	ZeroMemory(outBytes, sizeof(outBytes));

	outBytes[0] = (color & 0xff000000) >> 24;
	outBytes[1] = (color & 0x00ff0000) >> 16;
	outBytes[2] = (color & 0x0000ff00) >> 8;
	outBytes[3] = (color & 0x000000ff) >> 0;
}