#include "Blast/Graphic/CameraStandard.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CameraStandard::CameraStandard()
{
}

/// fXgN^
CameraStandard::~CameraStandard()
{
}


/// XV
void CameraStandard::Update(float delta)
{
	// r[sXV
	UpdateView();

	// ˉesXV
	UpdateProjection();
}


/// ʒu擾
const Vector3& CameraStandard::GetPosition() const
{
	return mPosition;
}

/// _擾
const Vector3& CameraStandard::GetLookAt() const
{
	return mLookAt;
}

/// [h̏ւ̒PʃxNg擾
const Vector3& CameraStandard::GetWorldUpUnit() const
{
	return mWorldUpUnit;
}

/// ]l擾
const Vector3& CameraStandard::GetRotation() const
{
	return mRotation;
}

/// ˉe@擾
Projection::EProjection CameraStandard::GetEProjection() const
{
	return mEProjection;
}

/// p擾
float CameraStandard::GetFieldOfViewY() const
{
	return mFieldOfViewY;
}

/// jANbv擾
float CameraStandard::GetNearClip() const
{
	return mNearClip;
}

/// t@[Nbv擾
float CameraStandard::GetFarClip() const
{
	return mFarClip;
}


/// r[s擾
const Matrix& CameraStandard::GetViewMatrixRef() const
{
	return mViewMatrix;
}

/// ˉes擾
const Matrix& CameraStandard::GetProjectionMatrixRef() const
{
	return mProjectionMatrix;
}


/// O̒PʃxNg擾
Vector3 CameraStandard::GetFrontUnit() const
{
	// ̒PʃxNgZo
	Vector3 eye = mLookAt - mPosition;
	Vector3 eyeUnit = eye.Normalize();

	return eyeUnit;
}

/// E̒PʃxNg擾
Vector3 CameraStandard::GetRightUnit() const
{
	// O̒PʃxNgZo
	Vector3 frontUnit = GetFrontUnit();

	// MEMO:OɌĎZo܂B
	// ̃xNgƂ̊OςZo
	Vector3 rightUnit = Vector3::Cross(frontUnit, mWorldUpUnit);

	return rightUnit;
}

/// ̒PʃxNg擾
Vector3 CameraStandard::GetUpUnit() const
{
	// E̒PʃxNg擾
	Vector3 rightUnit = GetRightUnit();

	// O̒PʃxNg擾
	Vector3 frontUnit = GetFrontUnit();

	// MEMO:EOɌĎZo܂B
	// Oς擾
	Vector3 upUnit = Vector3::Cross(rightUnit, frontUnit);

	return upUnit;
}


/// ʒuݒ
void CameraStandard::SetPosition(float x, float y, float z, bool isLookAtWith)
{
	/// _Ȃ
	if (isLookAtWith)
	{
		// ݂̈ʒu̒_̈ʒu擾
		Vector3 sub = mLookAt - mPosition;

		// VʒȗΈʒuŐݒ
		SetLookAt(x + sub.mX, y + sub.mY, z + sub.mZ);
	}

	mPosition.mX = x;
	mPosition.mY = y;
	mPosition.mZ = z;
}

/// ʒuݒ
void CameraStandard::SetPosition(const Vector3& kRPos, bool isLookAtWith)
{
	SetPosition(kRPos.mX, kRPos.mY, kRPos.mZ, isLookAtWith);
}


/// _ݒ
void CameraStandard::SetLookAt(float x, float y, float z)
{
	mLookAt.mX = x;
	mLookAt.mY = y;
	mLookAt.mZ = z;
}

/// _ݒ
void CameraStandard::SetLookAt(const Vector3& kRLookAt)
{
	mLookAt = kRLookAt;
}


/// [h̏̒PʃxNgݒ
void CameraStandard::SetWorldUpUnit(float x, float y, float z)
{
	mWorldUpUnit.mX = x;
	mWorldUpUnit.mY = y;
	mWorldUpUnit.mZ = z;
}

/// [h̏̒PʃxNgݒ
void CameraStandard::SetWorldUpUnit(const Vector3& kRUpUnit)
{
	mWorldUpUnit = kRUpUnit;
}


/// ]ݒ
void CameraStandard::SetRotationZXY(float x, float y, float z)
{
	// ʒu璍_ւ̃xNg擾
	Vector3 toLookAt = mLookAt - mPosition;

	// ʒuƒ_Ƃ̋擾
	float distance = toLookAt.Length();

	// MEMO:]lS0̏ꍇA_Zɂ܂B
	// Z+̒PʃxNgɏZ
	Vector3 rotZeroLookAt = Vector3::UnitZ() * distance;


	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(x, y, z);

	// ]
	Vector3 rotated = rotZeroLookAt;
	rotated.Multiply(rotMat);


	// ]̒SʒuZ
	Vector3 result = rotated + mPosition;


	// _ɑ
	mLookAt = result;


	// ]l͒ڑ
	mRotation.mX = x;
	mRotation.mY = y;
	mRotation.mZ = z;
}

/// ]ݒ
void CameraStandard::SetRotationZXY(const Vector3& kRRotation)
{
	SetRotationZXY(kRRotation.mX, kRRotation.mY, kRRotation.mZ);
}


/// ˉe@ݒ
void CameraStandard::SetEProjection(Projection::EProjection eProjection)
{
	mEProjection = eProjection;
}


/// pݒ
void CameraStandard::SetFieldOfViewY(float fovy)
{
	mFieldOfViewY = fovy;
}

/// ݒ
void CameraStandard::SetWidth(float width)
{
	mWidth = width;
}

/// cݒ
void CameraStandard::SetHeight(float height)
{
	mHeight = height;
}


/// ʒuړ
void CameraStandard::Move(float x, float y, float z, bool isLookAtWith)
{
	// _Ȃ
	if (isLookAtWith)
	{
		// _ړ
		MoveLookAt(x, y, z);
	}

	// ړʂZo
	Vector3 move;
	move += GetRightUnit() * x;
	move += GetUpUnit() * y;
	move += GetFrontUnit() * z;

	// ʒuɈړʂZ
	mPosition += move;
}

/// ʒuړ
void CameraStandard::Move(const Vector3& kRMove, bool isLookAtWith)
{
	Move(kRMove.mX, kRMove.mY, kRMove.mZ, isLookAtWith);
}


/// ʒuɉĈړ
void CameraStandard::MoveAxis(float x, float y, float z, bool isLookAtWith)
{
	mPosition.mX += x;
	mPosition.mY += y;
	mPosition.mZ += z;

	// _ړȂ
	if (isLookAtWith)
	{
		MoveLookAtAxis(x, y, z);
	}
}

/// ʒuɉĈړ
void CameraStandard::MoveAxis(const Vector3& kRPos, bool isLookAtWith)
{
	mPosition += kRPos;

	// _ړȂ
	if (isLookAtWith)
	{
		MoveLookAtAxis(kRPos);
	}
}


/// _ړ
void CameraStandard::MoveLookAt(float x, float y, float z)
{
	// ړʂZo
	Vector3 move;
	move += GetRightUnit() * x;
	move += GetUpUnit() * y;
	move += GetFrontUnit() * z;

	// _ɈړʂZ
	mLookAt += move;
}

/// _ړ
void CameraStandard::MoveLookAt(const Vector3& kRMove)
{
	MoveLookAt(kRMove.mX, kRMove.mY, kRMove.mZ);
}


/// _ɉĈړ
void CameraStandard::MoveLookAtAxis(float x, float y, float z)
{
	mLookAt.mX += x;
	mLookAt.mY += y;
	mLookAt.mZ += z;
}

/// _ɉĈړ
void CameraStandard::MoveLookAtAxis(const Vector3& kRLookAt)
{
	mLookAt += kRLookAt;
}


/// ]
void CameraStandard::RotateZXY(float x, float y, float z)
{
	// ʒu璍_ւ̃xNg擾
	Vector3 toLookAt = mLookAt - mPosition;


	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(x, y, z);

	// ]
	Vector3 rotated = toLookAt;
	rotated.Multiply(rotMat);


	// ]̒SʒuZ
	Vector3 result = rotated + mPosition;


	// _Ɍʂ
	mLookAt = result;


	// ]lXV
	UpdateRotation();
}

/// ]
void CameraStandard::RotateZXY(const Vector3& kRRotate)
{
	RotateZXY(kRRotate.mX, kRRotate.mY, kRRotate.mZ);
}


/// _𒆐SɌ]
void CameraStandard::RevolveZXY(float x, float y, float z)
{
	// _ʒuւ̃xNg擾
	Vector3 toPosition = mPosition - mLookAt;


	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(x, y, z);

	// ]
	Vector3 rotated = toPosition;
	rotated.Multiply(rotMat);


	// ]̒SS̈ʒuZ
	Vector3 result = rotated + mLookAt;


	// ʒuɌʂ
	mPosition = result;
	

	// ]lXV
	UpdateRotation();
}

/// _𒆐SɌ]
void CameraStandard::RevolveZXY(const Vector3& kRRevolve)
{
	RevolveZXY(kRRevolve.mX, kRRevolve.mY, kRRevolve.mZ);
}


/// ]lXV
void CameraStandard::UpdateRotation()
{
	// MEMO:ُ퐔lΉłB


	// Oւ̒PʃxNg擾
	const Vector3 kFrontUnit = GetFrontUnit();

	// YW0ɐݒ
	Vector3 zxPlane = kFrontUnit;
	zxPlane.mY = 0;

	// Pʉ
	Vector3 zxPlaneUnit = zxPlane.Normalize();

	// Z+X+ւ̌łY]p擾
	float radY = atan2(zxPlaneUnit.mX, zxPlaneUnit.mZ);


	// Y̋t]s쐬
	Matrix invRotY;
	invRotY.CreateRotationY(-radY);

	// Oւ̒PʃxNgYŋt]
	Vector3 zyPlane = kFrontUnit;
	zyPlane.Multiply(invRotY);

	// Pʉ
	Vector3 zyPlaneUnit = zyPlane.Normalize();

	// Z+Y+ւ̌łX]p擾
	float radX = atan2(zyPlaneUnit.mY, zyPlaneUnit.mZ);


	// MEMO:Z]lɂ͎oȂł܂B
	// ]p
	mRotation.mX = radX;
	mRotation.mY = radY;
}


#ifdef _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// \
void CameraStandard::DebugRender(int x, int y)
{
	// s
	const int kMatrixSpacing = 70;

	// os
	const int kSubheadSpacing = 12;

	// sCfbNX
	int dataIndex = 0;


	// ʒu
	int posX = x;
	int posY = y;


	// r[s\
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("r[s"));
	mViewMatrix.DebugRender(posX, posY + kSubheadSpacing);

	// ˉes\
	++dataIndex;
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("ˉes"));
	mProjectionMatrix.DebugRender(posX, posY + kSubheadSpacing);
}

#endif // _DEBUG


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// r[sXV
void CameraStandard::UpdateView()
{
	mViewMatrix.CreateView(mPosition, mLookAt, mWorldUpUnit);
}

/// ˉesXV
void CameraStandard::UpdateProjection()
{
	// ˉe@ŕ
	switch (mEProjection)
	{
		/// plϊ
		case Projection::ePROJECTION_PARSEPECTIVE_FOV:

			mProjectionMatrix.CreateParsepectiveFovLH(mFieldOfViewY, mAspectRatio, mNearClip, mFarClip);

			break;

		//// ϊsȂ
		//case Projection::ePROJECTION_PARSEPECTIVE:
		//	
		//	// TODO:
		//	
		//	break;

		// ˉesȂ
		case Projection::ePROJECTION_ORTHOGRAPHIC:

			mProjectionMatrix.CreateOrthoGraphicLH(mWidth, mHeight, mNearClip, mFarClip);

			break;

		// P[XOȂ
		default:

			HALT(_T("ˉe@ɂ镪򏈗łB"));

			break;
	}
}