#include "Blast/IO/CSVVariant.h"

#include "Blast/String/FormattingHelper.h"

using namespace Blast::IO;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// ftHgRXgN^
CSVVariant::CSVVariant() :
mValueStr(_T(""))
{
}

/// RXgN^
CSVVariant::CSVVariant(const TCHAR* kPValue) :
mValueStr(kPValue)
{
}


/// fXgN^
CSVVariant::~CSVVariant()
{
}


/// l擾
const tstring& CSVVariant::GetValueStrRef() const
{
	return mValueStr;
}

/// lݒ
void CSVVariant::SetValue(const TCHAR* pData)
{
	mValueStr = pData;
}


/// lTCHAR^Ŏ擾
const TCHAR* CSVVariant::ToCharacter() const
{
	return mValueStr.c_str();
}

/// ltstring^Ŏ擾
const tstring& CSVVariant::ToString() const
{
	return mValueStr;
}

/// lint^Ŏ擾
int CSVVariant::ToInteger() const
{
	int outData = ToValue<int>();

	return outData;
}

/// lfloat^Ŏ擾
float CSVVariant::ToFloat() const
{
	float outData = ToValue<float>();

	return outData;
}

/// lbool^Ŏ擾
bool CSVVariant::ToBoolean() const
{
	const int kTrueValue = 1;
	return (kTrueValue == ToValue<int>());
}


/// lLǂ擾
bool CSVVariant::IsValid() const
{
	// f[^Ȃ
	if (mValueStr.empty())
	{
		return false;
	}
	else
	{
		return true;
	}
}


//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

/// ̑e
void CSVVariant::operator= (const TCHAR* const pString)
{
	mValueStr = pString;
}

/// tstring^ւ̃LXgs
CSVVariant::operator const tstring&() const
{
	return mValueStr;
}

/// int^ւ̃LXgs
CSVVariant::operator int() const
{
	return ToInteger();
}

/// float^ւ̃LXgs
CSVVariant::operator float() const
{
	return ToFloat();
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// 񂩂^ϊs
template <class T>
T CSVVariant::ToValue() const
{
	// ^ɉtH[}bgwq擾
	TCHAR buffer[32] = _T("%");
	const TCHAR* const kPFormatSpecifier = FormattingHelper::ToFormatString<T>();
	_tcscat_s(buffer, kPFormatSpecifier);

	// l擾
	T value;
	_stscanf_s(mValueStr.c_str(), buffer, &value);

	return value;
}