#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CSVTable::CSVTable() :
mRecordList()
{
}

/// fXgN^
CSVTable::~CSVTable()
{
}


/// R[hǉ
void CSVTable::AddRecord(const SP<CSVRecord> rRecord)
{
	mRecordList.push_back(rRecord);
}


/// R[hXg
void CSVTable::ClearRecord()
{
	mRecordList.clear();
}


/// R[h擾
const SP<CSVRecord> CSVTable::GetRecord(int index) const
{
	// CfbNXXg͈͓̔ǂ
	bool isInList = IsIndexInList(index);

	// CfbNX͈͊OĂȂ玀
	ASSERT(isInList);

	// CfbNX͈͊OĂȂ
	if (!isInList)
	{
		return SP<CSVRecord>();
	}


	// Ce[^[̈ʒu𑀍
	RecordList::const_iterator it = mRecordList.begin();
	std::advance(it, index);


	return *it;
}


/// R[h擾
int CSVTable::GetRecordCount() const
{
	int count = mRecordList.size();

	return count;
}

//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

// z񉉎ZqŃANZX\ɂ
const SP<CSVRecord> CSVTable::operator[] (int index) const
{
	// ASSERT:CfbNX͈͊OȂ玀
	ASSERT_PF(IsIndexInList(index), _T("CfbNX͈͊OłBvf=%d, index=%d"), GetRecordCount(), index);


	// R[h擾
	const SP<CSVRecord> kPRecord = GetRecord(index);

	return kPRecord;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

// CfbNXR[hXgɎ܂Ă邩ǂ
bool CSVTable::IsIndexInList(int index) const
{
	// R[h擾
	const int kCount = mRecordList.size();

	// CfbNX͈͓Ȃ
	if (0 < kCount && index < kCount)
	{
		return true;
	}
	// CfbNX͈͊OȂ
	else
	{
		return false;
	}
}