#include "Blast/Graphic/DirectX9/BtModelDX9.h"

#include "Blast/Base/ResourceManager.h"
#include "Blast/Graphic/DirectX9/MeshObjDX9.h"
#include "Blast/Graphic/DirectX9/MeshXDX9.h"
#include "Blast/Graphic/DirectX9/MeshFbxDX9.h"
#include "Blast/Graphic/DirectX9/MeshHierarchyFbxDX9.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Storage/Directory.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Storage;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
BtModelDX9::BtModelDX9()
{
}

/// fXgN^
BtModelDX9::~BtModelDX9()
{
}


/// XV
void BtModelDX9::Update(float delta)
{
	// ̍XV
	RenderableGameComponent::Update(delta);


	/// MEMO:bVXVȂ̂CO
	//// bVȂ
	//if (mPMesh)
	//{
	//	// bVXV
	//	mPMesh->Update(delta);
	//}

	// XPgRei̐Ń[v
	for (int i = 0; i < mSkeletons.GetCount(); ++i)
	{
		// MEMO:ŃAj[V̕ϊs񂪐i݂܂B
		// XPgXV
		SP<ISkeleton> pSkeleton = mSkeletons[i];
		pSkeleton->Update(delta);
	}
	
	//// MEMO:f邩mF邽߂ɉ]܂B
	//mWorldProperty.Rotate(Vector3::UnitY() * MathHelper::ToRadian(90.0f) * delta);


	// MEMO:`撼OɋLڂ̂͂ǂł傤B
	// [hXV
	mWorldProperty.UpdateMatrix();
}

/// `
void BtModelDX9::Render()
{
	// ̕`揈
	RenderableGameComponent::Render();


	// MEMO:bV̋@\Oꂽ̂Ǝv̂CO
	//// bVȂ
	//if (mPMesh)
	//{
	//	// [hsݒ
	//	const Matrix& kRWorld = mWorldProperty.GetSRTMatrixRef();
	//	mPMesh->SetWorld(kRWorld);


	//	// WARNING:JȂx
	//	WARNING(mPCamera, _T("Jݒ肳Ă܂B`悳Ȃ\܂B"));

	//	// JȂ
	//	if (mPCamera)
	//	{
	//		// r[sݒ
	//		const Matrix& kRView = mPCamera->GetViewMatrixRef();
	//		mPMesh->SetView(kRView);

	//		// vWFNVs
	//		const Matrix& kRProjection = mPCamera->GetProjectionMatrixRef();
	//		mPMesh->SetProjection(kRProjection);


	//		// MEMO:r[|[gs͕KvɂȂ鎞ł傤B
	//	}


	//	// bV`
	//	mPMesh->Render();
	//}
}


/// gk擾
const Vector3& BtModelDX9::GetScaleRef() const
{
	return mWorldProperty.GetScale();
}

/// gkݒ
void BtModelDX9::SetScale(const Vector3& kRScale)
{
	mWorldProperty.SetScale(kRScale);
}

/// gk
void BtModelDX9::Scaling(const Vector3& kRValue)
{
	mWorldProperty.Scaling(kRValue);
}


/// ʒu擾
const Vector3& BtModelDX9::GetPositionRef() const
{
	return mWorldProperty.GetPosition();
}

/// ʒuݒ
void BtModelDX9::SetPosition(const Vector3& kRPosition)
{
	mWorldProperty.SetPosition(kRPosition);
}

/// ړ
void BtModelDX9::Move(const Vector3& kRValue)
{
	mWorldProperty.Translate(kRValue);
}


/// ]擾
const Vector3& BtModelDX9::GetRotationRef() const
{
	return mWorldProperty.GetRotation();
}

/// ]ݒ
void BtModelDX9::SetRotation(const Vector3& kRRotation)
{
	mWorldProperty.SetRotation(kRRotation);
}

/// ]
void BtModelDX9::Rotate(const Vector3& kRValue)
{
	mWorldProperty.Rotate(kRValue);
}


/// J擾
SP<ICamera> BtModelDX9::GetCamera()
{
	return mPCamera;
}

/// Jݒ
void BtModelDX9::SetCamera(SP<ICamera> pCamera)
{
	mPCamera = pCamera;
}


/// eNjbNݒ
void BtModelDX9::SetTechnique(int index)
{
	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// bVȂ
	//if (mPMesh)
	//{
	//	// Ϗ
	//	mPMesh->SetTechnique(index);
	//}
}

/// eNjbNݒ
void BtModelDX9::SetTechnique(const TCHAR* kPName)
{
	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// bVȂ
	//if (mPMesh)
	//{
	//	// Ϗ
	//	mPMesh->SetTechnique(kPName);
	//}
}


/// Aj[VύX
void BtModelDX9::ChangeAnimation(int index)
{
	// svȈׁA
	//// CfbNX͈͊Oǂ
	//bool isOutOfRange = mSkeletons.IsOutOfRange(index);
	//isOutOfRange &= mAnimations.IsOutOfRange(index);


	//// ASSERT:͈͊OȂ玀
	//ASSERT_PF(!isOutOfRange, _T("CfbNX͈͊OłBindex=%d, Rei=%d"), index, mSkeletons.GetCount());

	//// ͈͊OȂ
	//if (isOutOfRange)
	//{
	//	return;
	//}


	///// MEMO:bV̂ł͂ȂƎv̂CO
	////// XPgύX
	////SP<ISkeleton> pSkeleton = mSkeletons[index];
	////mPMesh->SetSkeleton(pSkeleton);

	///// MEMO:bV̂ł͂ȂƎv̂CO
	////// Aj[VύX
	////SP<IAnimation> pAnimation = mAnimations[index];
	////mPMesh->SetAnimation(pAnimation);

	///// MEMO:COƊY
	////// ԂZbg
	////pAnimation->ResetCurrentTime();
}

/// Aj[VύX
void BtModelDX9::ChangeAnimation(const TCHAR* kPAnimationName)
{
	// HALT:łB
	HALT(_T("w̃Aj[VύX͖łB"));
}


/// ǂݍ
bool BtModelDX9::LoadMesh(const TCHAR* kPFullPath)
{
	// gq擾
	TCHAR extentionName[Directory::mStKMaxExtention];
	Directory::GetExtention(kPFullPath, extentionName);


	// gq".obj"Ȃ
	if (_tcsicmp(extentionName, _T(".obj")) == 0)
	{
		// OBJt@CpbV쐬
		MeshObjDX9* pMesh(NEW MeshObjDX9());
		pMesh->Load(kPFullPath);

		mPMesh.SetPointer(pMesh);
	}
	// gq".x"Ȃ
	else if (_tcsicmp(extentionName, _T(".x")) == 0)
	{
		// Xt@CpbV쐬
		MeshXDX9* pMesh(NEW MeshXDX9());
		pMesh->Load(kPFullPath);

		mPMesh.SetPointer(pMesh);
	}
	// gq".fbx"Ȃ
	else if (_tcsicmp(extentionName, _T(".fbx")) == 0)
	{
		// FBXt@CpbV쐬
		ResourceManager* pRM = ResourceManager::GetInstance();
		mPMesh = pRM->Load<MeshFbxDX9>(kPFullPath);
	}
	// YȂgqȂ
	else
	{
		// HALT:T|[gĂȂgqȂ玀
		HALT(_T("T|[gĂȂgqłB\npX=%s"), kPFullPath);

		return false;
	}


	return true;
}

/// Aj[Vǂݍ
bool BtModelDX9::LoadAnimation(const TCHAR* kPFullPath)
{
	// XPgǂݍ
	SP<SkeletonFbx> pSkeleton(NEW SkeletonFbx());

	// ǂݍ߂ȂReiɒǉ
	bool isLoadSkeletonSucceeded = pSkeleton->Load(kPFullPath);
	if (isLoadSkeletonSucceeded)
	{
		mSkeletons.PushBack(pSkeleton);
	}
	else
	{
		return false;
	}


	//// svȂ߁A
	//// Aj[Vǂݍ
	//SP<AnimationFbx> pAnimation(NEW AnimationFbx());

	//// ǂݍ߂ȂReiɒǉ
	//bool isLoadAnimationSucceeded = pAnimation->Load(kPFullPath);
	//if (isLoadAnimationSucceeded)
	//{
	//	mAnimations.PushBack(pAnimation);
	//}
	//else
	//{
	//	return false;
	//}


	return true;
}

/// Aj[VJ
void BtModelDX9::ReleaseAnimation()
{
	mSkeletons.Clear();

	// svȂ߁A
	//mAnimations.Clear();
}