#include "Blast/Audio/AudioPCMPlayerDX8.h"
#include <process.h>
#include <stdio.h>

using namespace Blast::Audio;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	// vC
	unsigned int playTime_g = 1;	// 1 sec.
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------


/// RXgN^
AudioPCMPlayerDX8::AudioPCMPlayerDX8() :
mIsReadyOk(false),
mStreamThreadHandle(0),
mIsTerminating(false),
mIsLoop(true),
mEState(eSTATE_NONE)
{
	Clear();
}

/// RXgN^
AudioPCMPlayerDX8::AudioPCMPlayerDX8(CSP<IDirectSound8> pDS8) :
mPDirectSound8(pDS8),
mIsReadyOk(false),
mStreamThreadHandle(0),
mIsTerminating(false),
mIsLoop(true),
mEState(eSTATE_NONE)
{
	Clear();
}

/// RXgN^
AudioPCMPlayerDX8::AudioPCMPlayerDX8(CSP<IDirectSound8> pDS8, SP<IAudioDecoder> pDecoder) :
mPDirectSound8(pDS8),
mIsReadyOk(false),
mStreamThreadHandle(0),
mIsTerminating(false),
mIsLoop(true),
mEState(eSTATE_NONE)
{
	Clear();

	SetDecoder(pDecoder);
}

/// fXgN^
AudioPCMPlayerDX8::~AudioPCMPlayerDX8()
{
	TerminateThread();
}

/// NA
void AudioPCMPlayerDX8::Clear()
{
	TerminateThread();

	ZeroMemory(&mSDSBufferDesc, sizeof(mSDSBufferDesc));
	ZeroMemory(&mSWaveFormat, sizeof(mSWaveFormat));

	mPDSBuffer.SetInterfacePtr(NULL);
	mIsReadyOk = false;
	mEState = eSTATE_NONE;
}

/// foCXݒ
void AudioPCMPlayerDX8::SetDevice(CSP<IDirectSound8> pDS8)
{
	mPDirectSound8 = pDS8;
}


/// Đ̃Xbh~
void AudioPCMPlayerDX8::TerminateThread()
{
	// Xbh~
	mIsTerminating = true;

	// XbhLȂ
	if (mStreamThreadHandle)
	{
		// CAUTION:I܂Ń[v
		bool isEnd = false;
		while(!isEnd)
		{
			// Xbh̒~s
			DWORD flag = WaitForSingleObject((HANDLE)(__int64)mStreamThreadHandle, 100);

			switch(flag)
			{
				// Xbh~
				case WAIT_OBJECT_0:
					isEnd = true;
					break;

				// Xbh܂~ĂȂ
				case WAIT_TIMEOUT:
					isEnd = false;
					break;

				// Xbh̒~Ɏs
				case WAIT_FAILED:
					HALT(_T("Xbh̒~Ɏs܂B"));
					isEnd = true;
					break;

				// ̑
				default:
					WARNING(NULL, _T("Xbh̒~sہAӐ}Ȃʂ󂯎܂B"));
					break;
			}
		}
	}

	// Xbhnh𖳌
	mStreamThreadHandle = 0;

	// Xbh~tO낷
	mIsTerminating = false;
}

/// obt@
bool AudioPCMPlayerDX8::InitializeBuffer()
{
	// fR[_[Ȃ
	if (!mPPCMDecoder)
	{
		return false;
	}


	// 擪փV[N
	mPPCMDecoder->SeekStart();
	mPDSBuffer->SetCurrentPosition( 0 );

	// obt@bN
	void* AP1 = 0, *AP2 = 0;
	DWORD AB1 = 0, AB2  = 0;
	HRESULT hr = mPDSBuffer->Lock(0, 0, &AP1, &AB1, &AP2, &AB2, DSBLOCK_ENTIREBUFFER);

	// bNɐȂ
	if (SUCCEEDED(hr))
	{
		// f[^
		mPPCMDecoder->ReadNextSegment((CHAR*)AP1, AB1, NULL, NULL);
		mPDSBuffer->Unlock(AP1, AB1, AP2, AB2);
	}
	// bNɎsȂ
	else
	{
		Clear();

		return false;
	}


	return true;
}

/// Xg[ĐXbh
void AudioPCMPlayerDX8::StreamThread(void* pPlayerPtr)
{
	// LXg
	AudioPCMPlayerDX8* pPlayer = (AudioPCMPlayerDX8*)pPlayerPtr;

	// Xg[ĐɕKvȕϐ錾
	unsigned size = pPlayer->mSDSBufferDesc.dwBufferBytes / 2;
	unsigned flag = 0;
	DWORD point = 0;
	void* AP1 = 0, *AP2 = 0;
	DWORD AB1 = 0, AB2  = 0;
	unsigned writeSize = 0;
	bool isLastWrite = false;
	unsigned endPoint = 0;
	HRESULT hr = S_OK;

	// CAUTION:XbhjȂ胋[v
	while(!pPlayer->mIsTerminating)
	{
		// Ԃŕ
		switch (pPlayer->GetState())
		{
			// Đ
			case eSTATE_PLAY:
				// ݈ʒu`FbN
				pPlayer->mPDSBuffer->GetCurrentPosition(&point, 0);
				if ( flag == 0 && point >= size )
				{
					// Oɏ
					hr = pPlayer->mPDSBuffer->Lock(0, size, &AP1, &AB1, &AP2, &AB2, 0);
					if (SUCCEEDED(hr))
					{
						pPlayer->mPPCMDecoder->ReadNextSegment((CHAR*)AP1, AB1, &writeSize, &isLastWrite);
						pPlayer->mPDSBuffer->Unlock(AP1, AB1, AP2, AB2);
						flag = 1;

						// Ō݂̏Ȃ
						if (0 < writeSize && isLastWrite)
						{
							// In_}[N
							endPoint = writeSize;
						}
					}
				}
				else if (flag == 1 && point < size)
				{
					// 㔼ɏ
					hr = pPlayer->mPDSBuffer->Lock(size, size * 2, &AP1, &AB1, &AP2, &AB2, 0);
					if (SUCCEEDED(hr))
					{
						pPlayer->mPPCMDecoder->ReadNextSegment((CHAR*)AP1, AB1, &writeSize, &isLastWrite);
						pPlayer->mPDSBuffer->Unlock(AP1, AB1, AP2, AB2);
						flag = 0;
						
						// Ō݂̏Ȃ
						if (0 < writeSize && isLastWrite)
						{
							// In_}[N
							endPoint = size + writeSize;
						}

					}
				}

				// Ō܂ōĐȂ
				if (isLastWrite && endPoint <= point)
				{
					pPlayer->mEState = eSTATE_STOP;

					PFL(_T("TEhĐIB"));
				}

				break;

			// ~
			case eSTATE_STOP:
				// MEMO:O݂n߂邽߂łB
				flag = 0;
				break;

			// ꎞ~
			case eSTATE_PAUSE:
				break;

			default:
				break;
		}


		// ҋ@
		const unsigned long kSleepMillSeconds = 100;
		Sleep(kSleepMillSeconds);
	}
}

/// Đ
bool AudioPCMPlayerDX8::Play(bool isLoop)
{
	// łĂȂȂ
	if (!IsReadyOk())
	{
		return false;
	}

	// [vtOݒ
	mIsLoop = isLoop;
	mPPCMDecoder->SetIsLoop(isLoop);

	// Đ
	mPDSBuffer->Play(0, 0, DSBPLAY_LOOPING);
	mEState = eSTATE_PLAY;

	return true;
}

/// ꎞ~
void AudioPCMPlayerDX8::Pause()
{
	// ĐȂ
	if (mEState == eSTATE_PLAY)
	{
		mEState = eSTATE_PAUSE;

		// ~߂
		mPDSBuffer->Stop();
	}
	// ꎞ~Ȃ
	else if (mEState == eSTATE_PAUSE)
	{
		mEState = eSTATE_PLAY;

		// Đ
		Play(mIsLoop);
	}
}

/// ~
void AudioPCMPlayerDX8::Stop()
{
	// ĂȂȂ
	if (!IsReadyOk())
	{
		return;
	}

	// ~
	mEState = eSTATE_STOP;
	mPDSBuffer->Stop();

	// obt@̏
	InitializeBuffer();
}


/// Đǂ擾
bool AudioPCMPlayerDX8::IsPlaying() const
{
	return (mEState == eSTATE_PLAY);
}

/// ꎞ~ǂ
bool AudioPCMPlayerDX8::IsPause() const
{
	return (mEState == eSTATE_PAUSE);
}

/// Ō܂ōĐ
bool AudioPCMPlayerDX8::IsEnd() const
{
	// TODO:

	return false;
}

/// [v邩ǂ
bool AudioPCMPlayerDX8::IsLoop() const
{
	return mIsLoop;
}


/// PCMfR[_ݒ
bool AudioPCMPlayerDX8::SetDecoder(SP<IAudioDecoder> pDecoder)
{
	if (!mPDirectSound8 || !pDecoder || !pDecoder->IsReadyOk())
	{
		mIsReadyOk = false;

		return false;
	}

	// fR[_[ݒ
	mPPCMDecoder = pDecoder->Clone();

	// ~Ԃɐݒ
	mEState = eSTATE_STOP;


	// WAVEݒ
	ZeroMemory(&mSWaveFormat, sizeof(WAVEFORMATEX));

	mSWaveFormat.wFormatTag			= WAVE_FORMAT_PCM;
	mSWaveFormat.nChannels			= pDecoder->GetAudioResource()->GetChannelCount();
	mSWaveFormat.nSamplesPerSec		= pDecoder->GetAudioResource()->GetSamplingRate();
	mSWaveFormat.wBitsPerSample		= pDecoder->GetAudioResource()->GetBitRate();
	mSWaveFormat.nBlockAlign		= mSWaveFormat.nChannels * mSWaveFormat.wBitsPerSample / 8;
	mSWaveFormat.nAvgBytesPerSec	= mSWaveFormat.nSamplesPerSec * mSWaveFormat.nBlockAlign;
	mSWaveFormat.cbSize				= 0;


	// ZJ_obt@쐬
	mSDSBufferDesc.dwSize = sizeof( DSBUFFERDESC );
	mSDSBufferDesc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_GLOBALFOCUS;
	mSDSBufferDesc.dwBufferBytes = mSWaveFormat.nAvgBytesPerSec * playTime_g;
	mSDSBufferDesc.dwReserved = 0;
	mSDSBufferDesc.lpwfxFormat = &mSWaveFormat;
	mSDSBufferDesc.guid3DAlgorithm = GUID_NULL;


	// ZJ_obt@܂ꍇ͍쐬
	if (!mPDSBuffer)
	{
		// ZJ_obt@쐬
		CSP<IDirectSoundBuffer>	pTempBuffer;
		HRESULT hr = (mPDirectSound8->CreateSoundBuffer(&mSDSBufferDesc, pTempBuffer.ToCreator(), NULL));

		// 쐬ɐȂ
		if (SUCCEEDED(hr))
		{
			// IDirectSound8փLXg
			pTempBuffer->QueryInterface(IID_IDirectSoundBuffer8 , (LPVOID*)mPDSBuffer.ToCreator());
		}
		// 쐬ɎsȂ
		else
		{
			Clear();

			return false;
		}
	}


	// obt@
	if (!InitializeBuffer())
	{
		return false;
	}


	// obt@Rs[Xbh
	if (!mStreamThreadHandle)
	{
		mStreamThreadHandle = (unsigned)_beginthread(AudioPCMPlayerDX8::StreamThread, 0, (void*)this);
	}


	// tO𗧂Ă
	mIsReadyOk = true;

	return true;
}


/// ʂݒ
void AudioPCMPlayerDX8::SetVolume(int volume)
{
	// ĂȂ
	if (IsReadyOk()) 
	{
		mPDSBuffer->SetVolume(volume);
	}
}

/// p̈ʒuς
void AudioPCMPlayerDX8::SetPan(int pan)
{
	// ĂȂ
	if (IsReadyOk())
	{
		mPDSBuffer->SetPan(pan);
	}
}

/// ǂ擾
bool AudioPCMPlayerDX8::IsReadyOk() const
{
	return mIsReadyOk;
}

/// Ԃ擾
AudioPCMPlayerDX8::EState AudioPCMPlayerDX8::GetState() const
{
	return mEState;
}
