#include <memory.h>
#include <crtdbg.h>

#include "Blast/Audio/AudioOggDecoder.h"
#include "Blast/String/StringHelper.h"

using namespace Blast::Audio;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// ǂݍݒP
	const unsigned int requestSize_g = 4096;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AudioOggDecoder::AudioOggDecoder()
{
}

/// fXgN^
AudioOggDecoder::~AudioOggDecoder()
{
	Clear();
}


/// ̃obt@Xg[ǂݍ
bool AudioOggDecoder::ReadNextSegment(CHAR* pBuffer, unsigned bufferSize, unsigned* pOutWriteSize, bool* pOutIsEnd)
{
	// łĂȂȂ
	if (!IsReadyOk())
	{
		return false;
	}

	// obt@Ȃ
	if (!pBuffer)
	{
		// ItȌo͕ϐLȂ
		if (pOutIsEnd)
		{
			*pOutIsEnd = true;
		}

		// ݃TCY̏o͕ϐLȂ
		if (pOutWriteSize)
		{
			*pOutWriteSize = 0;
		}

		return false;
	}


	// ItȌo͕ϐLȂ
	if (pOutIsEnd)
	{
		*pOutIsEnd = false;
	}

	// obt@
	ZeroMemory(pBuffer, bufferSize);


	unsigned requestSize = requestSize_g;
	int bitstream = 0;
	int readSize = 0;
	unsigned int comSize = 0;
	bool isAdjust = false;


	// obt@TCYvTCYȂ
	if (bufferSize < requestSize)
	{
		// vTCYobt@TCYɂ
		requestSize = bufferSize;

		// iKłtO𗧂Ă
		isAdjust = true;
	}


	// OggVorbisɃLXgĎ擾
	AudioOggResource* pOggVorbisResource = GetOggResource();

	// LXgɎsȂ
	if (!pOggVorbisResource)
	{
		return false;
	}


	// CAUTION:[v
	while (true)
	{
		// ǂݍ
		readSize = ov_read(&pOggVorbisResource->GetOggVorbisFileRef(), (CHAR*)(pBuffer + comSize), requestSize, 0, 2, 1, &bitstream);
		
		// EOFȂ
		if (readSize == 0)
		{
			// [vȂ
			if (IsLoop())
			{
				// ǂݍ݈ʒuŏɖ߂
				ov_time_seek(&pOggVorbisResource->GetOggVorbisFileRef(), 0.0);
			}
			// [vȂȂ
			else
			{
				// ItȌo͕ϐLȂ
				if (pOutIsEnd)
				{
					*pOutIsEnd = true;
				}

				// ݃TCY̏o͕ϐLȂ
				if (pOutWriteSize)
				{
					*pOutWriteSize = comSize;
				}

				// I
				return true;
			}
		}

		// TCYZ
		comSize += readSize;

		// ASSERT:obt@I[o[玀B
		ASSERT_PF(comSize <= bufferSize, _T("obt@I[o[܂B\ncomSize=%u, bufferSize=%u"), comSize, bufferSize);


		// obt@𖄂ߐs
		if (bufferSize <= comSize)
		{
			// ݃TCY̏o͕ϐLȂ
			if (pOutWriteSize)
			{
				*pOutWriteSize = comSize;
			}

			return true;
		}

		// cobt@vobt@ȓȂ
		if (bufferSize - comSize < requestSize_g)
		{
			// iK
			isAdjust = true;
			
			// vTCYcobt@̃TCYɐݒ
			requestSize = bufferSize - comSize;
		}
	}


	// ݃TCY̏o͕ϐLȂ
	if (pOutWriteSize)
	{
		*pOutWriteSize = comSize;
	}
	
	// HALT:̃G[Ă̂ŎB
	HALT(_T("̃G[܂B"));


	return false;	
}


/// 擪ɃV[N
void AudioOggDecoder::SeekStart()
{
	// OggVorbisɃLXgĎ擾
	AudioOggResource* pOggResource = GetOggResource();

	// LXgɎsȂ
	if (!pOggResource)
	{
		return;
	}


	// Ϗ
	pOggResource->SeekStart();
}


/// N[쐬
SP<IAudioDecoder> AudioOggDecoder::Clone()
{
	// ĂȂȂ
	if (!mIsReadyOk)
	{
		// NULL̃|C^Ԃ
		return SP<IAudioDecoder>();
	}


	// N[pCX^X쐬
	AudioOggDecoder* pClone = NEW AudioOggDecoder();
	pClone->SetAudioResource(mPAudioResource);


	return SP<IAudioDecoder>(pClone);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// AudioOggResourceɃLXg
AudioOggResource* AudioOggDecoder::GetOggResource()
{
	AudioOggResource* pOggResource = dynamic_cast<AudioOggResource*>(mPAudioResource.GetSource());

	// ASSERT:LXgɎsȂ玀B
	ASSERT_PF(pOggResource, _T("AudioOggResourceւ̃LXgɎs܂B"));

	return pOggResource;
}