#include "Blast/Application/ApplicationBase.h"

#include <tchar.h>
#include "Blast/Utility/Assert.h"

using namespace Blast::Application;
using namespace Blast::Utility;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// NX
	const TCHAR stKPClassName[ApplicationBase::mStKClassNameBufferSize] = _T("lpszClassName");
}


//====================================================================================================
// Global
//----------------------------------------------------------------------------------------------------

/// AvP[Vւ̃|C^
Blast::Application::ApplicationBase* gPApplication = NULL;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

// vV[W
LRESULT CALLBACK ApplicationBase::StWindowProcedural(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	// AvP[VNXCWindowBaseIuWFNgzւ̃|C^擾
	if(gPApplication)
	{
		WindowBases& rWBs = gPApplication->GetWindowBasesRef();

		// EBhE̐擾
		int count = rWBs.size();

		// EBhE1ȏ゠Ȃ
		if (0 < count)
		{
			// EBhE̐Ń[v
			for(int i = 0; i < count; ++i)
			{
				// EBhE擾
				WindowBase* pWB = rWBs.at(i).GetSource();

				// EBhEnhvȂ
				if(pWB->GetWindowHandleRef() == hWnd)
				{
					// [JEBhEvV[WR[
					LRESULT lResult = pWB->WindowProcedural(hWnd, message, wParam, lParam);

					return lResult;
				}
			}
		}
		// EBhEȂ
		else
		{
			// bZ[Wŕ
			switch (message)
			{
				// EBhE
				case WM_CLOSE:
					// XbhIv
					PostQuitMessage(0);

					break;

				default:

					// ftHg̏
					LRESULT lResult = DefWindowProc(hWnd, message, wParam, lParam);

					return lResult;
			}
		}
	}

	// IԂ
	return 0;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ApplicationBase::ApplicationBase() :
mHInstance(NULL),
mCommandShow(-1),
mWindowClassEx()
{
	// O[oɂ|C^ϐ֎т
	gPApplication = this;
}

/// fXgN^
ApplicationBase::~ApplicationBase() { }

/// AvP[V̎sJn
int ApplicationBase::Run(HINSTANCE hInstance, int cmdShow)
{
	// CX^Xnhێ
	mHInstance = hInstance;

	// R}hێ
	mCommandShow = cmdShow;

	// EBhEo^
	bool isRegisterWindowOk = RegisterWindowClass();
	
	// ASSERT:EBhE̓o^ɎsȂ玀
	ASSERT(isRegisterWindowOk);

	// EBhE쐬
	bool isCreateWindowOk = CreateMainWindow();

	// ASSERT:EBhE̓o^ɎsȂ玀
	ASSERT(isCreateWindowOk);

	// EBhE\
	bool isShowWindowOk = ShowMainWindow();

	// ASSERT:EBhE̕\ɎsȂ玀
	ASSERT(isShowWindowOk);

	// 
	bool isInitializeOk = Initialize();

	// ASSERT:ɎsȂ玀
	ASSERT(isInitializeOk);

	// C[v
	Loop();

	// 
	Release();

	return TRUE;
}

/// EBhE̓o^
bool ApplicationBase::RegisterWindowClass()
{
	// EBhENX̏
	ZeroMemory(&mWindowClassEx, sizeof(WNDCLASSEX));

	// \̂̃TCY
	mWindowClassEx.cbSize = sizeof(WNDCLASSEX);

	// EBhẼX^C
	mWindowClassEx.style = CS_HREDRAW | CS_VREDRAW;

	// svV[Wݒ
	mWindowClassEx.lpfnWndProc = StWindowProcedural;

	// ???:ł傤
	mWindowClassEx.cbClsExtra = 0;

	// ???:ł傤
	mWindowClassEx.cbWndExtra = 0;

	// CX^Xnhw
	mWindowClassEx.hInstance = mHInstance;

	// ACRݒ
	mWindowClassEx.hIcon = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));

	// J[\ݒ
	mWindowClassEx.hCursor = LoadCursor(NULL, IDC_ARROW);

	// ???:wi̕`Fݒ
	mWindowClassEx.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);

	// ???:j[ݒ
	mWindowClassEx.lpszMenuName = NULL;

	// MEMO:ꎞϐł͋@\܂
	// NXݒ
	mWindowClassEx.lpszClassName = stKPClassName;

	// ???:ACR̃TlCݒ
	mWindowClassEx.hIconSm = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));

	// EBhEo^
	BOOL isRegisterClassExOk = RegisterClassEx(&mWindowClassEx);

	// EBhE̓o^Ɏs
	if (!isRegisterClassExOk)
	{
		OutputDebugString(_T("EBhE̓o^Ɏs܂\n"));

		return false;
    }

	return true;
}

/// EBhE̍쐬
bool ApplicationBase::CreateMainWindow()
{
	// EBhE쐬
	WindowBase::SProperty sProperty;
	sProperty.Initialize(mHInstance, stKPClassName);

	// X}[g|C^ŕێ
	SP<WindowBase> pWB(new WindowBase());
	bool isOk = pWB->Create(sProperty);

	// 쐬̌ʂsȂ
	if (!isOk)
	{
		OutputDebugString(_T("EBhE̍쐬Ɏs܂\n"));

		return false;
	}

	// EBhEzɒǉ
	mWindowBases.push_back(pWB);
	
	// EBhETCYNCAgTCYƂăTCY
	ChangeToCliantSize(pWB->GetWindowHandleRef(), sProperty.mWidth, sProperty.mHeight);

	return true;
}

/// EBhE̕\
bool ApplicationBase::ShowMainWindow()
{
	// MEMO:[vKv͂܂񂪁AzȂ̂ŔÔ
	// EBhE̐Ń[v
	int windowBaseCount = mWindowBases.size();
	for (int i = 0; i < windowBaseCount; ++i)
	{
		// EBhEnhQ
		HWND& rHWND = mWindowBases.at(i)->GetWindowHandleRef();

		// EBhE\
		ShowWindow(rHWND, GetCommandShow());
		UpdateWindow(rHWND);
	}

	return true;
}

/// 
bool ApplicationBase::Initialize()
{
	// MEMO:C[vOɍsƂ͂

	return true;
}

/// bZ[W[v̎s
int ApplicationBase::Loop()
{
	// bZ[W
	MSG msg; 
	ZeroMemory(&msg, sizeof(MSG));

	// IbZ[W󂯎܂Ń[v
	while(msg.message != WM_QUIT)
	{
		// bZ[W擾
		GetMessage(&msg, NULL, 0, 0);

		// bZ[Wϊ
		TranslateMessage(&msg); 

		// bZ[WBvV[Wɓ
		DispatchMessage(&msg); 
	}

	return static_cast<int>(msg.wParam);
}

/// I
void ApplicationBase::Release()
{
	// MEMO:C[vɍsƂ͂
}

/// EBhETCYNCAgTCYɕύX
void ApplicationBase::ChangeToCliantSize(HWND& rHWND, int width, int height)
{
	// MEMO:擾͍̂ƉE̓_̈ʒułA傫ł͂܂B
	// EBhE̔zuƃNCAg̔zu擾
	RECT wRect, cRect;
	GetWindowRect(rHWND, &wRect);
	GetClientRect(rHWND, &cRect);

	// EBhẼTCY擾
	int wWidth = wRect.right - wRect.left;
	int wHeight = wRect.bottom - wRect.top;

	// NCAg̃TCY擾
	int cWidth = cRect.right - cRect.left;
	int cHeight = cRect.bottom - cRect.top;

	// ]Șg̃TCY擾
	int extraWidth = wWidth - cWidth;
	int extraHeight = wHeight - cHeight;

	// VKɓKpTCYZo
	int newWindowWidth = extraWidth + width;
	int newWindowHeight = extraHeight + height;


	// EBhETCYݒ
	SetWindowPos(rHWND, NULL, 0, 0, newWindowWidth, newWindowHeight, SWP_NOMOVE | SWP_NOZORDER);
}