#include "Blast/Graphic/AnimationSet.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Graphic;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AnimationSet::AnimationSet()
	: mNameStr(_T(""))
	, mFrameTime(0)
	, mPSkinDeformer(NULL)
	, mClusterCount(0)
{
}

/// fXgN^
AnimationSet::~AnimationSet()
{
}


/// 
void AnimationSet::Initialize(KFbxScene* pScene)
{
    // Aj[V̍XVɕKvȃt[Ԃ̑xێ
	mFrameTime.SetTime(0, 0, 0, 1, 0, pScene->GetGlobalSettings().GetTimeMode());

	// X^bN̈ꗗLbV
	KArrayTemplate<KString*> pStackNameArray;
    pScene->FillAnimStackNameArray(pStackNameArray);
	for (int i = 0; i < pStackNameArray.GetCount(); ++i)
	{
		TCHAR buffer[64] = { '\0' };
		StringHelper::ToWideChar(buffer, SIZE_OF_ARRAY(buffer), pStackNameArray.GetAt(i)->Buffer());

		mStackNameArray.push_back(buffer);
	}
	
	// eCNLbV
	for (int i = 0; i < pStackNameArray.GetCount(); ++i)
	{
		KFbxTakeInfo* pTakeInfo = pScene->GetTakeInfo( *(pStackNameArray[i]) );
		mTakeInfoArray.push_back(pTakeInfo);
	}

	// bVToăAj[VɕKvȏLbV
	CacheData(pScene->GetRootNode());
}


/// Aj[VZbg̖O擾
const TCHAR* AnimationSet::GetName() const
{
	return mNameStr.c_str();
}

/// Aj[ṼCfbNX𖼑O擾
void AnimationSet::GetAnimationIndexByName(const TCHAR* const kPName, int* pOut) const
{
	int value = -1;

	for (int i = 0; i < (int)mStackNameArray.size(); ++i)
	{
		const TCHAR* const kPAnimName = mStackNameArray.at(i).c_str();
		if ( _tcscmp(kPAnimName, kPName) == 0)
		{
			value = i;
			break;
		}
	}

	// o
	if (pOut)
	{
		*pOut = value;
	}
}

/// Aj[V̖OCfbNX擾
void AnimationSet::GetAnimationNameByIndex(TCHAR* pOutValue, int charaCount, int index) const
{
	// o
	if (pOutValue)
	{
		const TCHAR* const kPAnimName = mStackNameArray.at(index).c_str();
		memcpy(pOutValue, kPAnimName, sizeof(TCHAR) * charaCount);
	}
}

/// Aj[V̐擾
int AnimationSet::GetAnimationCount() const
{
	return (int)mStackNameArray.size();
}

/// Aj[VZbg̊Ԃ擾
double AnimationSet::GetPeriod() const
{
	// 擪ĂĂ邪̂낤B_ȂŎw肷@낤B
	return mTakeInfoArray.at(0)->mLocalTimeSpan.GetDuration().GetSecondDouble();
}

/// Aj[VZbg̃[J^Ct[ɂ鎞Ԉʒu擾
double AnimationSet::GetPeriodicPosition(double position) const
{
	return GetPeriod() * position;
}


/// SRTs擾
void AnimationSet::GetSRT(double periodicPosition, int animationIndex) const
{
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Aj[VLbV
void AnimationSet::CacheData(fbxsdk_2012_2::KFbxNode* pParent)
{
	// Aj[VɕKvȃftH[}[T
	const int kAttCount = pParent->GetNodeAttributeCount();
	for (int i = 0; i < kAttCount; ++i)
	{
		KFbxNodeAttribute* pAtt = pParent->GetNodeAttributeByIndex(i);
		if (pAtt->GetAttributeType() == KFbxNodeAttribute::eMESH)
		{
			KFbxMesh* pMesh = pParent->GetMesh();
			const int kDeformerCount = pMesh->GetDeformerCount(KFbxDeformer::eSKIN);
			if (0 < kDeformerCount)
			{
				// 擪Deformer擾B܂AT|[gȂB
				mPSkinDeformer = KFbxCast<KFbxSkin>(pMesh->GetDeformer(0, KFbxDeformer::eSKIN));
				
				// NX^̐擾
				mClusterCount = mPSkinDeformer->GetClusterCount();
				ASSERT_PF(mClusterCount <= MAX_BONE_MATRICES, _T("dlݒ\ȃ{[𒴂Ă܂Bf\[X̃{[炵ĂB\ngp\ȃ{[=%d\nf\[X̃{[%d"), MAX_BONE_MATRICES, mClusterCount);

				//// s񎩑̂AnimationSet͕̂sȋĈCO
				//// ϊs͕KvȐmۂ
				//mPClusterDeformations.SetPointer(NEW KFbxXMatrix[mClusterCount], true);
				//ZeroMemory(mPClusterDeformations.GetSource(), mClusterCount * sizeof(KFbxXMatrix));

				return;
			}
		}
	}

	// q̐Ń[v
	for (int i = 0; i < pParent->GetChildCount(); ++i)
	{
		KFbxNode* pChild = pParent->GetChild(i);
		CacheData(pChild);
	}
}