#include "Blast/Graphic/AnimationController.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Graphic;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	
	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// Get the matrix of the given pose
	/// |[Yϊs擾
	KFbxXMatrix GetPoseMatrix(KFbxPose* pPose, int pNodeIndex)
	{
		KFbxXMatrix oseMatrix;
		KFbxMatrix lMatrix = pPose->GetMatrix(pNodeIndex);

		memcpy((double*)oseMatrix, (double*)lMatrix, sizeof(lMatrix.mData));

		return oseMatrix;
	}

	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// m[h̃O[oȈʒuA܂胍[Jł͂Ȃʒu擾B
	KFbxXMatrix GetGlobalPosition(
		KFbxNode* pNode,
		const KTime& rTime,
		KFbxPose* pPose,
		KFbxXMatrix* pParentGlobalPosition
		)
	{
		KFbxXMatrix globalPosition;
		bool isPositionFound = false;

		if (pPose)
		{
			const int kNodeIndex = pPose->Find(pNode);

			if (-1 < kNodeIndex)
			{
				// The bind pose is always a global matrix.
				// If we have a rest pose, we need to check if it is
				// stored in global or local space.
				if (pPose->IsBindPose() || !pPose->IsLocalMatrix(kNodeIndex))
				{
					globalPosition = GetPoseMatrix(pPose, kNodeIndex);
				}
				else
				{
					// We have a local matrix, we need to convert it to
					// a global space matrix.
					KFbxXMatrix lParentGlobalPosition;

					if (pParentGlobalPosition)
					{
						lParentGlobalPosition = *pParentGlobalPosition;
					}
					else
					{
						if (pNode->GetParent())
						{
							lParentGlobalPosition = GetGlobalPosition(pNode->GetParent(), rTime, pPose, NULL);
						}
					}

					KFbxXMatrix lLocalPosition = GetPoseMatrix(pPose, kNodeIndex);
					globalPosition = lParentGlobalPosition * lLocalPosition;
				}

				isPositionFound = true;
			}
		}

		if (!isPositionFound)
		{
			globalPosition = pNode->EvaluateGlobalTransform(rTime);
		
#if CONFIRM || 1
			static int stCount = 0;
			if (stCount < 10)
			{
				++stCount;

				KFbxVector4 fbxS = globalPosition.GetS();
				KFbxVector4 fbxR = globalPosition.GetR();
				/* WA\ɂȂRgO */
				//for (int i = 0; i < 4; ++i)
				//{
				//	fbxR[i] = MathHelper::ToRadian(fbxR[i]);
				//}
				KFbxVector4 fbxT = globalPosition.GetT();
				#if 0	//< _vp
				PFL(_T("m[hu%svEvaluateGlobalTransform()̓(S%d/10):\n\tS(%lf, %lf, %lf)\n\tR(%lf, %lf, %lf)\n\tT(%lf, %lf, %lf)"),
					StringHelper::ToWideChar(pNode->GetName()).c_str(),
					stCount,
					fbxS[0], fbxS[1], fbxS[2],
					fbxR[0], fbxR[1], fbxR[2],
					fbxT[0], fbxT[1], fbxT[2]
					);
				#endif
			}
#endif // CONFIRM
		}

		return globalPosition;
	}

	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// WIgɕۑꂽό`擾
	KFbxXMatrix GetGeometry(KFbxNode* kPNode)
	{
		return KFbxXMatrix();

		// MEMO:ԂFBX̗xNgɍ킹č珇ɑǂł傤H
		// KFbxMatrix̃RXgN^TRS̏Ŏ󂯎낤ƂĂ̂łɍ킹܂B
		KFbxVector4 geoT = kPNode->GetGeometricTranslation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoR = kPNode->GetGeometricRotation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoS = kPNode->GetGeometricScaling(KFbxNode::eSOURCE_SET);

		return KFbxXMatrix(geoT, geoR, geoS);
	}
	
	//Compute the transform matrix that the cluster will transform the vertex.
	// NX^̏ɉĒ_ό`BNX^Ƃ͂{[Ɠ`B
	void ComputeClusterDeformation(
		KFbxXMatrix& rGlobalPosition, 
		KFbxMesh* pMesh,
		KFbxCluster* pCluster, 
		KFbxXMatrix& rVertexTransformMatrix,
		KTime& rTime, 
		KFbxPose* pPose)
	{
		KFbxCluster::ELinkMode dClusterMode = pCluster->GetLinkMode();

		KFbxXMatrix lReferenceGlobalInitPosition;
		KFbxXMatrix lReferenceGlobalCurrentPosition;
		KFbxXMatrix lAssociateGlobalInitPosition;
		KFbxXMatrix lAssociateGlobalCurrentPosition;
		KFbxXMatrix lClusterGlobalInitPosition;
		KFbxXMatrix lClusterGlobalCurrentPosition;

		KFbxXMatrix lReferenceGeometry;
		KFbxXMatrix lAssociateGeometry;
		KFbxXMatrix lClusterGeometry;

		KFbxXMatrix lClusterRelativeInitPosition;
		KFbxXMatrix lClusterRelativeCurrentPositionInverse;
		
		if (dClusterMode == KFbxLink::eADDITIVE && pCluster->GetAssociateModel())
		{
			pCluster->GetTransformAssociateModelMatrix(lAssociateGlobalInitPosition);
			// Geometric transform of the model
			lAssociateGeometry = GetGeometry(pCluster->GetAssociateModel());
			lAssociateGlobalInitPosition *= lAssociateGeometry;
			lAssociateGlobalCurrentPosition = GetGlobalPosition(pCluster->GetAssociateModel(), rTime, pPose, NULL);

			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;
			lReferenceGlobalCurrentPosition = rGlobalPosition;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			// Multiply lClusterGlobalInitPosition by Geometric Transformation
			lClusterGeometry = GetGeometry(pCluster->GetLink());
			lClusterGlobalInitPosition *= lClusterGeometry;
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), rTime, pPose, NULL);

			// Compute the shift of the link relative to the reference.
			//ModelM-1 * AssoM * AssoGX-1 * LinkGX * LinkM-1*ModelM
			rVertexTransformMatrix =
				lReferenceGlobalInitPosition.Inverse()
				* lAssociateGlobalInitPosition * lAssociateGlobalCurrentPosition.Inverse()
				* lClusterGlobalCurrentPosition * lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;
		}
		else
		{
			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			lReferenceGlobalCurrentPosition = rGlobalPosition;
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), rTime, pPose, NULL);

			// Compute the initial position of the link relative to the reference.
			lClusterRelativeInitPosition = lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;

			// Compute the current position of the link relative to the reference.
			lClusterRelativeCurrentPositionInverse = lReferenceGlobalCurrentPosition.Inverse() * lClusterGlobalCurrentPosition;

			// Compute the shift of the link relative to the reference.
			rVertexTransformMatrix =
				lClusterRelativeCurrentPositionInverse
				* lClusterRelativeInitPosition;
		}
	}

	/// KFbxXMatrix̑SvfPɉZ
	KFbxXMatrix SimpleSumMatrix(const KFbxXMatrix& kRA, const KFbxXMatrix& kRB)
	{
		KFbxXMatrix result;
		result.mData[0][0] = kRA.mData[0][0] + kRB.mData[0][0];
		result.mData[0][1] = kRA.mData[0][1] + kRB.mData[0][1];
		result.mData[0][2] = kRA.mData[0][2] + kRB.mData[0][2];
		result.mData[0][3] = kRA.mData[0][3] + kRB.mData[0][3];
		result.mData[1][0] = kRA.mData[1][0] + kRB.mData[1][0];
		result.mData[1][1] = kRA.mData[1][1] + kRB.mData[1][1];
		result.mData[1][2] = kRA.mData[1][2] + kRB.mData[1][2];
		result.mData[1][3] = kRA.mData[1][3] + kRB.mData[1][3];
		result.mData[2][0] = kRA.mData[2][0] + kRB.mData[2][0];
		result.mData[2][1] = kRA.mData[2][1] + kRB.mData[2][1];
		result.mData[2][2] = kRA.mData[2][2] + kRB.mData[2][2];
		result.mData[2][3] = kRA.mData[2][3] + kRB.mData[2][3];
		result.mData[3][0] = kRA.mData[3][0] + kRB.mData[3][0];
		result.mData[3][1] = kRA.mData[3][1] + kRB.mData[3][1];
		result.mData[3][2] = kRA.mData[3][2] + kRB.mData[3][2];
		result.mData[3][3] = kRA.mData[3][3] + kRB.mData[3][3];

		return result;
	}

	/// KFbxXMatrix̑SvfPɏZ
	KFbxXMatrix SimpleMultipleMatrix(const KFbxXMatrix& kRA, double multiple)
	{
		KFbxXMatrix result;
		result.mData[0][0] = kRA.mData[0][0] * multiple;
		result.mData[0][1] = kRA.mData[0][1] * multiple;
		result.mData[0][2] = kRA.mData[0][2] * multiple;
		result.mData[0][3] = kRA.mData[0][3] * multiple;
		result.mData[1][0] = kRA.mData[1][0] * multiple;
		result.mData[1][1] = kRA.mData[1][1] * multiple;
		result.mData[1][2] = kRA.mData[1][2] * multiple;
		result.mData[1][3] = kRA.mData[1][3] * multiple;
		result.mData[2][0] = kRA.mData[2][0] * multiple;
		result.mData[2][1] = kRA.mData[2][1] * multiple;
		result.mData[2][2] = kRA.mData[2][2] * multiple;
		result.mData[2][3] = kRA.mData[2][3] * multiple;
		result.mData[3][0] = kRA.mData[3][0] * multiple;
		result.mData[3][1] = kRA.mData[3][1] * multiple;
		result.mData[3][2] = kRA.mData[3][2] * multiple;
		result.mData[3][3] = kRA.mData[3][3] * multiple;

		return result;
	}

} // namespace Nameless


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// gbNBRXgN^
AnimationController::STrack::STrack()
{
	// Aj[VύXɏ鏈ƕ֗Ȃ̂œ
	Initialize();
}

/// gbNB
void AnimationController::STrack::Initialize()
{
	mPAnimationSet.SetPointer(NULL);
	mIsAnimationBlend = false;
	mSpeedRatio = 1.0f;
	mElapsedTime = 0;
	mShiftTime = 0;
	mWeightTime = 0;
	mIsLoop = true;
	mWeight = 0;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AnimationController::AnimationController()
	: mGlobalTime(0)
{
	/// UNDONE:XL̕ϊs̔z𓮓ImہB[ŏȂPʉꂽ܂܂ɂȂH
	mPClusterDeformations.SetPointer(NEW KFbxXMatrix[MAX_BONE_MATRICES], true);
}

/// fXgN^
AnimationController::~AnimationController()
{
}

/// O[oԂi߂
void AnimationController::AdvanceTime(double deltaTime)
{
	// UNDONE:Aj[VƂFPSɑΉĂȂB
	// HACK:̂܂܂ł͐Vł܂ƂɂȂB
	mGlobalTime.SetSecondDouble( mGlobalTime.GetSecondDouble() + deltaTime );

	// Aj[V֘AXV
	for (int i = 0; i < stKMaxTrackCount; ++i)
	{
		STrack* pSTrack = &mSTracks[i];
		ASSERT_PF(pSTrack, _T("gbNf[^݂܂I"));
		if (!pSTrack)
		{
			continue;
		}

		// Aj[VȂ
		if (!pSTrack->mPAnimationSet)
		{
			continue;
		}
		
		// UNDONE:deltaTime̒lf
		pSTrack->mElapsedTime += pSTrack->mPAnimationSet->GetFrameTime();

		// ԂXVB
		// Aj[V̊Ԃ߂玞Ԃ̏ǉōsB
		// [vȂ玞Ԃ߂B
		if (pSTrack->mPAnimationSet->GetPeriod() < pSTrack->mElapsedTime.GetSecondDouble())
		{
			if (pSTrack->mIsLoop)
			{
				double t = pSTrack->mElapsedTime.GetSecondDouble() - pSTrack->mPAnimationSet->GetPeriod();
				pSTrack->mElapsedTime.SetSecondDouble(t);
			}
			else
			{
				double t = pSTrack->mPAnimationSet->GetPeriod();
				pSTrack->mElapsedTime.SetSecondDouble(t);
			}
		}
	}

	// Aj[Vuh̃EFCgZo
	STrack* pSCurTrack = &mSTracks[eTRACK_CURRENT];
	STrack* pSPreTrack = &mSTracks[eTRACK_BLEND_START];
	if (0 < pSCurTrack->mShiftTime.GetSecondDouble())	//< 鐔Ȃ̂0
	{
		pSCurTrack->mWeightTime.SetSecondDouble( pSCurTrack->mWeightTime.GetSecondDouble() + deltaTime );
		if (pSCurTrack->mWeightTime < pSCurTrack->mShiftTime)
		{
			double weight = pSCurTrack->mWeightTime.GetSecondDouble() / pSCurTrack->mShiftTime.GetSecondDouble();
			pSCurTrack->mWeight = weight;
			pSPreTrack->mWeight = 1 - weight;	//< ÕAj[Vɂ͋t̒l
		}
		else
		{
			pSCurTrack->mWeight = 1;
			pSPreTrack->mWeight = 0;
			pSCurTrack->mWeightTime = pSCurTrack->mShiftTime;
		}
	}
}

/// Aj[VύXB
/// Aj[VZbg\ߓo^ĂKvB
void AnimationController::ChangeAnimation(int index, double shiftTime)
{
	// ͈͊O
	const int kAnimSetCount = mPAnimationSets.size();
	if (0 <= index && index < kAnimSetCount)
	{
		// HACK:G[
		// Aj[Ṽ~LVOs߁A
		// ݂̃Aj[VڂɓāAڂɂ͎w肳ꂽAj[V
		mSTracks[eTRACK_BLEND_START] = mSTracks[eTRACK_CURRENT];

		mSTracks[eTRACK_CURRENT].Initialize();
		mSTracks[eTRACK_CURRENT].mPAnimationSet = mPAnimationSets.at(index);
		mSTracks[eTRACK_CURRENT].mShiftTime.SetSecondDouble(shiftTime);
	}
}

/// Aj[V̑xύXB
/// l͔{B
void AnimationController::SetSpeedRatio(float speedRatio)
{
	mSTracks[eTRACK_CURRENT].mSpeedRatio = speedRatio;
}

/// Aj[VZbg擾
void AnimationController::GetAnimationSet(int index, SP<AnimationSet>& pOut)
{
	pOut = mPAnimationSets.at(index);
}

/// Aj[VZbg𖼑OŎ擾
void AnimationController::GetAnimationSetByName(const TCHAR* const kPName, SP<AnimationSet> pOut)
{
	std::vector< SP<AnimationSet> >::iterator it;
	for (it = mPAnimationSets.begin(); it != mPAnimationSets.end(); ++it)
	{
		if ( _tcscmp((*it)->GetName(), kPName) == 0 )
		{
			pOut = *it;
		}
	}
}

/// Aj[VZbg̐擾
int AnimationController::GetAnimationSetCount() const
{
	return (int)mPAnimationSets.size();
}

/// Aj[VZbgǉ
void AnimationController::ResisterAnimationSet(SP<AnimationSet> pAnimationSet)
{
	mPAnimationSets.push_back(pAnimationSet);
}

/// Aj[VZbg폜
void AnimationController::UnresisterAnimationSet(SP<AnimationSet> pAnimationSet)
{
	std::vector< SP<AnimationSet> >::iterator it;
	for (it = mPAnimationSets.begin(); it != mPAnimationSets.end(); ++it)
	{
		if ( (*it) == pAnimationSet )
		{
			it = mPAnimationSets.erase(it);

			return;
		}
	}
}

/// O[oԂZbgB
void AnimationController::ResetTime()
{
	mGlobalTime = 0;
}

/// w肳ꂽgbNɃAj[VKp
/// Ŏw肳ꂽgbNɃAj[Ṽ~LVOs炵B
void AnimationController::SetTrackAnimationSet(int trackIndex, SP<AnimationSet> pAnimationSet)
{
	// ͈͊O
	if (0 < trackIndex && trackIndex <= stKMaxTrackCount)
	{
		return;
	}

	// gbNɐݒ
	STrack sTrack;
	sTrack.mPAnimationSet = pAnimationSet;

	mSTracks[trackIndex] = sTrack;
}


/// |[Ys̍XV
void AnimationController::UpdatePose(
	KFbxXMatrix& rGlobalPosition,
	KFbxMesh* pMesh,
	KTime& rTime,
	KFbxPose* pPose)
{
	// ĐΏۂ̃Aj[VZbgDeformer擾
	SP<AnimationSet> pAnimSet = mSTracks[eTRACK_CURRENT].mPAnimationSet;
	if (!pAnimSet)
	{
		return;
	}
	KFbxSkin* pSkin = pAnimSet->GetSkinDeformer();
	const int kClusterCount = pAnimSet->GetClusterCount();

	// Aj[ṼuhsȂAڂAnimationSetĂB
	SP<AnimationSet> pAnimSet2 = mSTracks[eTRACK_BLEND_START].mPAnimationSet;
	if (!pAnimSet2) { return; }
	KFbxSkin* pSkin2 = pAnimSet2->GetSkinDeformer();
	const int kClusterCount2 = pAnimSet2->GetClusterCount();


	// Z[hȂPʉĂ
	KFbxCluster::ELinkMode eClusterMode = pSkin->GetCluster(0)->GetLinkMode();
	if (eClusterMode == KFbxCluster::eADDITIVE)
	{
		for (int i = 0; i < kClusterCount; ++i)
		{
			mPClusterDeformations[i].SetIdentity();
		}
	}

	// Aj[ṼuhsȂAڂESkinningTypeł򂪕KvB
	// XLɂ^Cv̂ŁAʓrB
	KFbxSkin::ESkinningType eSkinningType = pSkin->GetSkinningType();
	KFbxSkin::ESkinningType eSkinningType2 = pSkin2->GetSkinningType();
	switch (eSkinningType)
	{
		// jA
		case KFbxSkin::eLINEAR:	///< tH[X[
		// Wbh
		case KFbxSkin::eRIGID:
		{
			// NX^ꂼ̕ϊsZoB
			SP<KFbxXMatrix> temp(NEW KFbxXMatrix[kClusterCount], true);
			for (int clusterIndex = 0; clusterIndex < kClusterCount; ++clusterIndex)
			{
				// ̃NX^ɃNȂ珈XLbv
				KFbxCluster* pCluster = pSkin->GetCluster(clusterIndex);
				if (!pCluster->GetLink())
				{
					continue;
				}

				// NX^̃ftH[s
				KFbxXMatrix vertexTransformMatrix;
				ComputeClusterDeformation(rGlobalPosition, pMesh, pCluster, vertexTransformMatrix, mSTracks[0].mElapsedTime, pPose);
				memcpy(&temp[clusterIndex], &vertexTransformMatrix, sizeof(vertexTransformMatrix));
			}

			// Aj[VuhpɂAnimationSet̕ϊsZoB
			SP<KFbxXMatrix> temp2(NEW KFbxXMatrix[kClusterCount], true);
			for (int clusterIndex = 0; clusterIndex < kClusterCount2; ++clusterIndex)
			{
				// ̃NX^ɃNȂ珈XLbv
				KFbxCluster* pCluster = pSkin2->GetCluster(clusterIndex);
				if (!pCluster->GetLink())
				{
					continue;
				}

				// NX^̃ftH[s
				KFbxXMatrix vertexTransformMatrix;
				ComputeClusterDeformation(rGlobalPosition, pMesh, pCluster, vertexTransformMatrix, mSTracks[1].mElapsedTime, pPose);
				memcpy(&temp2[clusterIndex], &vertexTransformMatrix, sizeof(vertexTransformMatrix));
			}

			// sZ
			for (int clusterIndex = 0; clusterIndex < kClusterCount; ++clusterIndex)
			{
				KFbxXMatrix a, b, result;

				// 
				double weight = mSTracks[eTRACK_CURRENT].mWeight;
				a = SimpleMultipleMatrix(temp[clusterIndex], weight);

				// 
				double weight2 = mSTracks[eTRACK_BLEND_START].mWeight;
				b = SimpleMultipleMatrix(temp2[clusterIndex], weight2);

				result = SimpleSumMatrix(a, b);
				mPClusterDeformations[clusterIndex] = result;
			}

			break;
		}
		// fANH[^jI
		case KFbxSkin::eDUALQUATERNION:
			HALT(_T("ueSkinningType == KFbxSkin::eDUALQUATERNIONv͖̏łB"));
			break;
		// uh
		case KFbxSkin::eBLEND:
			HALT(_T("ueSkinningType == KFbxSkin::eBLENDv͖̏łB"));
			break;

		default:
			HALT(_T("P[XȌs悤Ƃ܂B"));
			break;
	}
}
