#ifndef BLAST_TYPE_UINT8_H
#define BLAST_TYPE_UINT8_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// unsigned char^NX
		class UInt8 : public Blast::Type::TypeBase<unsigned char>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static char GetMax()
			{
				return 127;
			}

			/// ŏl擾
			static char GetMin()
			{
				return -127 - 1;
			}

			
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			UInt8(char value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (unsigned char a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_UINT8_H