#ifndef BLAST_TYPE_FLOAT64_H
#define BLAST_TYPE_FLOAT64_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// double^NX
		class Float64 : public Blast::Type::TypeBase<double>
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Float64(double value)
			{
				mValue = value;
			}


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (double a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_FLOAT64_H