#ifndef BLAST_TYPE_FLOAT32_H
#define BLAST_TYPE_FLOAT32_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// float^NX
		class Float32 : public Blast::Type::TypeBase<float>
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Float32(float value)
			{
				mValue = value;
			}


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (float a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_FLOAT32_H