#ifndef BLAST_MATH_WORLDPROPERTY_H
#define BLAST_MATH_WORLDPROPERTY_H

#include "Blast/Math/Vector3.h"
#include "Blast/Math/Matrix.h"


namespace Blast
{
	namespace Math
	{
		/// [hsɕKvȏێNX
		class WorldProperty
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			WorldProperty();

			/// fXgN^
			~WorldProperty();


			/// 
			void Initialize();

			/// [hsXV
			void UpdateMatrix();

			
			/// gk擾
			const Blast::Math::Vector3& GetScale() const;

			/// gk擾
			Blast::Math::Vector3& GetScale();

			/// gkݒ
			void SetScale(float x, float y, float z);

			/// gkݒ
			void SetScale(const Blast::Math::Vector3&);

			/// gk
			void Scaling(float x, float y, float z);

			/// gk
			void Scaling(const Vector3&);


			/// ]l擾
			const Blast::Math::Vector3& GetRotation() const;

			/// ]l擾
			Blast::Math::Vector3& GetRotation();

			/// ]lݒ
			void SetRotation(float x, float y, float z);

			/// ]lݒ
			void SetRotation(const Blast::Math::Vector3&);

			/// ]
			void Rotate(float x, float y, float z);

			/// ]
			void Rotate(const Vector3&);


			/// ʒu擾
			const Blast::Math::Vector3& GetPosition() const;

			/// ʒu擾
			Blast::Math::Vector3& GetPosition();

			/// ʒuݒ
			void SetPosition(float x, float y, float z);

			/// ʒuݒ
			void SetPosition(const Blast::Math::Vector3&);

			/// sړ
			void Translate(float x, float y, float z);

			/// sړ
			void Translate(const Vector3&);


			/// SRTs擾
			Blast::Math::Matrix& GetSRTMatrixRef();

			/// SRTs擾
			const Blast::Math::Matrix& GetSRTMatrixRef() const;
			

			/// O擾
			Vector3 GetForwardUnit() const;

			/// 擾
			Vector3 GetLeftUnit() const;

			/// E擾
			Vector3 GetRightUnit() const;

			/// 擾
			Vector3 GetBackUnit() const;

		private:
			/// gk
			Vector3 mScale;

			/// ]
			Vector3 mRotation;

			/// ʒu
			Vector3 mPosition;


			/// gks
			Matrix mScaleMatrix;

			/// X]s
			Matrix mRotateXMatrix;

			/// Y]s
			Matrix mRotateYMatrix;

			/// Z]s
			Matrix mRotateZMatrix;

			/// sړs
			Matrix mTranslateMatrix;


			/// SRTs
			Matrix mSRTMatrix;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// ړ𖳎s̒lŕϊPʃxNg擾
			Vector3 CalcUnitSRTransform(const Vector3&) const;

		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_WORLDPROPERTY_H