#ifndef BLAST_MATH_VECTOR2_H
#define BLAST_MATH_VECTOR2_H

namespace Blast
{
	namespace Math
	{
		/// 2̃xNgSNX
		class Vector2
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// (0, 0)擾
			static const Vector2& Zero();

			/// (1, 0)擾
			static const Vector2& UnitX();

			/// (0, 1)擾
			static const Vector2& UnitY();

			/// (1, 1)擾
			static const Vector2& One();


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// ftHgRXgN^
			Vector2();

			/// RXgN^BXYɓl
			Vector2(float);

			/// RXgN^BXYɒl
			Vector2(float, float);

			/// fXgN^
			~Vector2();


			/// eZ
			void Add(float, float);

			/// eZ
			void Add(const Vector2&);


			/// eZ
			void Subtract(float, float);

			/// eZ
			void Subtract(const Vector2&);


			/// eZ
			void Multiply(float, float);

			/// eZ
			void Multiply(float);

			/// eZ
			void Multiply(const Vector2&);


			/// eZ
			void Divide(float, float);

			/// eZ
			void Divide(const float);

			/// eZ
			void Divide(const Vector2&);



			/// ςZo
			float Dot(const Vector2&);

			/// OςZo
			float Cross(const Vector2&);

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// +Zqł̉Z\
			Vector2 operator+ (const Vector2&) const;

			/// -Zqł̌Z\
			Vector2 operator- (const Vector2&) const;

			/// *Zqł̏Z\
			Vector2 operator* (volatile const Vector2&) const;

			/// /Zqł̏Z\
			Vector2 operator/ (const Vector2&) const;

			/// +=Zqł̉Z\
			void operator+= (const Vector2&);

			/// -=Zqł̌Z\
			void operator-= (const Vector2&);

			/// *=Zqł̏Z\
			void operator*= (const Vector2&);

			/// /=Zqł̏Z\
			void operator/= (const Vector2&);

			/// YZq[]ł̒l擾\
			float& operator[] (int);

			// MEMO:񍀉ZqɑΉɂ́AfriendɂKv܂B

			/// *Zqł̏Z\
			friend Vector2 operator* (const float& n, const Vector2& a)
			{
				Vector2 v = a;

				v.Multiply(n);

				return v;
			}

			/// *Zqł̏Z\
			friend Vector2 operator* (const Vector2& a, const float& n)
			{
				Vector2 v = a;

				v.Multiply(n);

				return v;
			}

			/// /Zqł̏Z\
			friend Vector2 operator/ (const float& n, const Vector2& a)
			{
				Vector2 v = a;

				v.Divide(n);

				return v;
			}


#if _DEBUG

			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// o
			void DebugOutput() const;
			
			/// `
			void DebugRender(int x, int y) const;

#endif // _DEBUG


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// MEMO:pɂɈ̂publicɒuĂ܂B

			/// Xl
			float mX;

			/// Yl
			float mY;

		private:
			//====================================================================================================
			// PrivateStatic
			//----------------------------------------------------------------------------------------------------

			/// (0, 0)
			static const Vector2 mStKZero;

			/// (1, 0)
			static const Vector2 mStKUnitX;

			/// (0, 1)
			static const Vector2 mStKUnitY;

			/// (1, 1)
			static const Vector2 mStKOne;
		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_VECTOR2_H
