#ifndef BLAST_MATH_MATHHELPER
#define BLAST_MATH_MATHHELPER

// MEMO:M_PIgp邽߂ɂ_USE_MATH_DEFINES`Kv܂
#ifndef _USE_MATH_DEFINES
	#define _USE_MATH_DEFINES
#endif // _USE_MATH_DEFINES


#include <math.h>
#include "Blast/Design/Noncopyable.h"


namespace Blast
{
	namespace Math
	{
		/// ZpɊւ鏈NX
		class MathHelper : public Blast::Design::Noncopyable
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// xWAɕϊ
			template < class T >
			static T ToRadian(const T& degree)
			{
				T radian = static_cast<T>(degree / 180.0 * M_PI);

				return radian;
			}

			/// WAxɕϊ
			template < class T >
			static T ToDegree(const T& radian)
			{
				T degree = static_cast<T>(radian * 180.0 / M_PI);

				return degree;
			}


			/// l𒴂ŏ̔{擾
			static int GetOverMultiple(int border, int multiple);


			/// l͈͓ɃNv
			template < class T >
			static T Clamp(const T& kRValue, const T& kRMin, const T& kRMax)
			{
				// ŏlȂ
				if (kRValue < kRMin)
				{
					return kRMin;
				}
				// ől𒴂ĂȂ
				else if (kRMax < kRValue)
				{
					return kRMax;
				}
				// ͈͓Ȃ
				else
				{
					return kRValue;
				}
			}


			/// l͈͓ǂ
			template < class T >
			static bool IsInOfRange(const T& kRValue, const T& kRMin, const T& kRMax)
			{
				// ŏlőlȏȂfalse
				if (kRMax <= kRMin)
				{
					return false;
				}

				// ͈͓Ȃtrue
				if (kRMin <= kRValue && kRValue < kRMax)
				{
					return true;
				}
				else
				{
					return false;
				}
			}

			/// l͈͓ǂ
			template < class T >
			static bool IsInOfRange(const T& kRValue, const T& kRMax)
			{
				return IsInOfRange(kRValue, 0, kRMax);
			}

			/// l͈͊Oǂ
			template < class T >
			static bool IsOutOfRange(const T& kRValue, const T& kRMin, const T& kRMax)
			{
				// ŏlAől߂Ȃtrue
				if (kRValue < kRMin || kRMax < kRValue)
				{
					return true;
				}
				// ͈͓Ȃ
				else
				{
					return false;
				}
			}


			/// Βl擾
			template < class T >
			static T Absolute(const T& kRValue)
			{
				return abs(kRValue);
			}

			/// Pʉ
			template < class T >
			static T Normalize(const T& kRValue)
			{
				// 0Ȃ0Ԃ
				if (kRValue == 0)
				{
					return 0;
				}

				const T kValue = Absolute(kRValue);

				return (kRValue / kValue);
			}


			/// KFbxXMatrixMatrixɕϊ
			static Blast::Math::Matrix ToMatrix(const fbxsdk_2012_2::KFbxXMatrix& rIn, Blast::Math::Matrix* pOut = NULL);

			/// MatrixKFbxXMatrixɕϊ
			static fbxsdk_2012_2::KFbxXMatrix ToFbxXMatrix(const Blast::Math::Matrix& rIn, fbxsdk_2012_2::KFbxXMatrix* pOut = NULL);

			/// KFbxXMatrixdouble^̒lŏZ
			static void Multiple(fbxsdk_2012_2::KFbxXMatrix& rIO, double value);

			/// KFbxXMatrixdouble^̒lZ
			static void Add(fbxsdk_2012_2::KFbxXMatrix& rIO, const fbxsdk_2012_2::KFbxXMatrix& rIn);

			/// KFbxXMatrix̑Ίpvf݂̂double^̒lŉZ
			static void AddToDiagnoal(fbxsdk_2012_2::KFbxXMatrix& rIO, double value);


			/// 3DXMAXo͂f[^OŎꍇɎgp܂B
			/// Z]ׁA|Š]̂ŁACfbNXobt@JO̒KvłB
			/// EZ-UpWnY-UpWnɕϊs쐬
			static Blast::Math::Matrix CreateZUpRHToYUpLH(Blast::Math::Matrix* pOut = NULL);

			/// FBXSDKɂϊł͕sĂ镪UׂɎgp܂B
			/// FBXSDKDirectX̎ϊsۂɕsĂ镪Us쐬
			static Blast::Math::Matrix CreateConvertAxisFromFbxSdk(Blast::Math::Matrix* pOut = NULL);


			/// 񎟌z̃CfbNXꎟz̃CfbNXƂĎZo
			static int CalculateLinearIndex(int indexX, int indexY, int width);


			/// m
			static bool IsJudgment(int percent);

			
		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			// MEMO:CX^X֎~܂B錾̂ݍsĂ܂B

			/// RXgN^
			MathHelper();

			/// fXgN^
			~MathHelper();
		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_MATHHELPER