#ifndef BLAST_INPUT_KEYS_H
#define BLAST_INPUT_KEYS_H

namespace Blast
{
	namespace Input
	{
		/// L[^Cv̎ނێNX
		class Keys
		{
		public:
			///====================================================================================================
			/// Enumerate
			///----------------------------------------------------------------------------------------------------

			/// MEMO:񋓗vf̒ĺwdinput.hxƓĂ邽߁AAԂł͂܂B
			/// L[{[h̃L[̗񋓑
			enum EKey
			{
				eKEY_ESC			= 0x01,		 ///< Escape
				eKEY_1				= 0x02,		 ///< 1
				eKEY_2				= 0x03,		 ///< 2
				eKEY_3				= 0x04,		 ///< 3
				eKEY_4				= 0x05,		 ///< 4
				eKEY_5				= 0x06,		 ///< 5
				eKEY_6				= 0x07,		 ///< 6
				eKEY_7				= 0x08,		 ///< 7
				eKEY_8				= 0x09,		 ///< 8
				eKEY_9				= 0x0A,		 ///< 9
				eKEY_0				= 0x0B,		 ///< 10
				eKEY_MINUS			= 0x0C,		 ///< -
				eKEY_EQUALS			= 0x0D,		 ///< =
				eKEY_BACK			= 0x0E,		 ///< BackSpace
				eKEY_TAB			= 0x0F,		 ///< Tab
				eKEY_Q				= 0x10,		 ///< Q
				eKEY_W				= 0x11,		 ///< W
				eKEY_E				= 0x12,		 ///< E
				eKEY_R				= 0x13,		 ///< R
				eKEY_T				= 0x14,		 ///< T
				eKEY_Y				= 0x15,		 ///< Y
				eKEY_U				= 0x16,		 ///< U
				eKEY_I				= 0x17,		 ///< I
				eKEY_O				= 0x18,		 ///< O
				eKEY_P				= 0x19,		 ///< P
				eKEY_LBRACKET		= 0x1A,		 ///< {
				eKEY_RBRACKET		= 0x1B,		 ///< }
				eKEY_RETURN			= 0x1C,		 ///< Enter
				eKEY_LCONTROL		= 0x1D,		 ///< Ctrl
				eKEY_A				= 0x1E,		 ///< A
				eKEY_S				= 0x1F,		 ///< S
				eKEY_D				= 0x20,		 ///< D
				eKEY_F				= 0x21,		 ///< F
				eKEY_G				= 0x22,		 ///< G
				eKEY_H				= 0x23,		 ///< H
				eKEY_J				= 0x24,		 ///< J
				eKEY_K				= 0x25,		 ///< K
				eKEY_L				= 0x26,		 ///< L
				eKEY_SEMICOLON		= 0x27,		 ///< ;
				eKEY_APOSTROPHE		= 0x28,		 ///< '
				eKEY_GRAVE			= 0x29,		 ///< `
				eKEY_LSHIFT			= 0x2A,		 ///< Shift
				eKEY_BACKSLASH		= 0x2B,		 ///< _
				eKEY_Z				= 0x2C,		 ///< Z
				eKEY_X				= 0x2D,		 ///< X
				eKEY_C				= 0x2E,		 ///< C
				eKEY_V				= 0x2F,		 ///< V
				eKEY_B				= 0x30,		 ///< B
				eKEY_N				= 0x31,		 ///< N
				eKEY_M				= 0x32,		 ///< M
				eKEY_COMMA			= 0x33,		 ///< ,
				eKEY_PERIOD			= 0x34,		 ///< .
				eKEY_SLASH			= 0x35,		 ///< /
				eKEY_RSHIFT			= 0x36,		 ///< EShift
				eKEY_MULTIPLY		= 0x37,		 ///< *
				eKEY_LMENU			= 0x38,		 ///< j[
				eKEY_SPACE			= 0x39,		 ///< Xy[X
				eKEY_CAPITAL		= 0x3A,		 ///< CapsLock
				eKEY_F1				= 0x3B,		 ///< F1
				eKEY_F2				= 0x3C,		 ///< F2
				eKEY_F3				= 0x3D,		 ///< F3
				eKEY_F4				= 0x3E,		 ///< F4
				eKEY_F5				= 0x3F,		 ///< F5
				eKEY_F6				= 0x40,		 ///< F6
				eKEY_F7				= 0x41,		 ///< F7
				eKEY_F8				= 0x42,		 ///< F8
				eKEY_F9				= 0x43,		 ///< F9
				eKEY_F10			= 0x44,		 ///< F10
				eKEY_NUMLOCK		= 0x45,		 ///< NumLock
				eKEY_SCROLL			= 0x46,		 ///< ScrollLock
				eKEY_NUMPAD7		= 0x47,		 ///< eL[7
				eKEY_NUMPAD8		= 0x48,		 ///< eL[8
				eKEY_NUMPAD9		= 0x49,		 ///< eL[9
				eKEY_SUBTRACT		= 0x4A,		 ///< eL[-
				eKEY_NUMPAD4		= 0x4B,		 ///< eL[4
				eKEY_NUMPAD5		= 0x4C,		 ///< eL[5
				eKEY_NUMPAD6		= 0x4D,		 ///< eL[6
				eKEY_ADD			= 0x4E,		 ///< eL[+
				eKEY_NUMPAD1		= 0x4F,		 ///< eL[1
				eKEY_NUMPAD2		= 0x50,		 ///< eL[2
				eKEY_NUMPAD3		= 0x51,		 ///< eL[3
				eKEY_NUMPAD0		= 0x52,		 ///< eL[0
				eKEY_DECIMAL		= 0x53,		 ///< eL[.
				eKEY_OEM_102		= 0x56,		 ///< OEM_102
				eKEY_F11			= 0x57,		 ///< F11
				eKEY_F12			= 0x58,		 ///< F12
				eKEY_F13			= 0x64,		 ///< F13
				eKEY_F14			= 0x65,		 ///< F14
				eKEY_F15			= 0x66,		 ///< F15
				eKEY_KANA			= 0x70,		 ///< J^JiЂ炪
				eKEY_ABNT_C1		= 0x73,		 ///< ABNT_C1
				eKEY_CONVERT		= 0x79,		 ///< Convert 
				eKEY_NOCONVERT		= 0x7B,		 ///< NoConvert
				eKEY_YEN			= 0x7D,		 ///< \L[
				eKEY_ABNT_C2		= 0x7E,		 ///< ABNT_C2
				eKEY_NUMPADEQUALS	= 0x8D,		 ///< eL[=
				eKEY_PREVTRACK		= 0x90,		 ///< PrevTrack
				eKEY_AT				= 0x91,		 ///< AT
				eKEY_COLON			= 0x92,		 ///< :
				eKEY_UNDERLINE		= 0x93,		 ///< _
				eKEY_KANJI			= 0x94,		 ///< 
				eKEY_STOP			= 0x95,		 ///< Stop
				eKEY_AX				= 0x96,		 ///< Ax
				eKEY_UNLABELED		= 0x97,		 ///< UnLabeled
				eKEY_NEXTTRACK		= 0x99,		 ///< NextTrack
				eKEY_NUMPADENTER	= 0x9C,		 ///< eL[Enter
				eKEY_RCONTROL		= 0x9D,		 ///< ECtrl
				eKEY_MUTE			= 0xA0,		 ///< Mute
				eKEY_CALCULATOR		= 0xA1,		 ///< Calculator
				eKEY_PLAYPAUSE		= 0xA2,		 ///< PlayPause
				eKEY_MEDIASTOP		= 0xA4,		 ///< MediaStop
				eKEY_VOLUMEDOWN		= 0xAE,		 ///< VolumeDown
				eKEY_VOLUMEUP		= 0xB0,		 ///< VolumeUp
				eKEY_WEBHOME		= 0xB2,		 ///< WebHome
				eKEY_NUMPADCOMMA	= 0xB3,		 ///< eL[,
				eKEY_DIVIDE			= 0xB5,		 ///< eL[/
				eKEY_SYSRQ			= 0xB7,		 ///< SysRQ
				eKEY_RMENU			= 0xB8,		 ///< Ej[
				eKEY_PAUSE			= 0xC5,		 ///< Pause
				eKEY_HOME			= 0xC7,		 ///< Home
				eKEY_UP				= 0xC8,		 ///< A[
				eKEY_PRIOR			= 0xC9,		 ///< Prior
				eKEY_LEFT			= 0xCB,		 ///< A[
				eKEY_RIGHT			= 0xCD,		 ///< EA[
				eKEY_END			= 0xCF,		 ///< End
				eKEY_DOWN			= 0xD0,		 ///< A[
				eKEY_NEXT			= 0xD1,		 ///< Next
				eKEY_INSERT			= 0xD2,		 ///< Insert
				eKEY_DELETE			= 0xD3,		 ///< Delete
				eKEY_LWIN			= 0xDB,		 ///< Windows
				eKEY_RWIN			= 0xDC,		 ///< EWindows
				eKEY_APPS			= 0xDD,		 ///< Apps
				eKEY_POWER			= 0xDE,		 ///< Power
				eKEY_SLEEP			= 0xDF,		 ///< Sleep
				eKEY_WAKE			= 0xE3,		 ///< Wake
				eKEY_WEBSEARCH		= 0xE5,		 ///< WebSearch
				eKEY_WEBFAVORITES	= 0xE6,		 ///< WebFavorites
				eKEY_WEBREFRESH		= 0xE7,		 ///< WebRefresh
				eKEY_WEBSTOP		= 0xE8,		 ///< WebStop
				eKEY_WEBFORWARD		= 0xE9,		 ///< WebForward
				eKEY_WEBBACK		= 0xEA,		 ///< WebBack
				eKEY_MYCOMPUTER		= 0xEB,		 ///< MyComputer
				eKEY_MAIL			= 0xEC,		 ///< Mail
				eKEY_MEDIASELECT	= 0xED,		 ///< MediaSelect

				eKEY_BACKSPACE		= eKEY_BACK,		 ///< BackSpace
				eKEY_NUMPADSTAR		= eKEY_MULTIPLY,	 ///< eL[*
				eKEY_LALT			= eKEY_LMENU,		 ///< Alt
				eKEY_CAPSLOCK		= eKEY_CAPITAL,		 ///< CapsLock
				eKEY_NUMPADMINUS	= eKEY_SUBTRACT,	 ///< eL[-
				eKEY_NUMPADPLUS		= eKEY_ADD,			 ///< eL[+
				eKEY_NUMPADPERIOD	= eKEY_DECIMAL,		 ///< eL[.
				eKEY_NUMPADSLASH	= eKEY_DIVIDE,		 ///< eL[/
				eKEY_RALT			= eKEY_RMENU,		 ///< EAlt
				eKEY_UPARROW		= eKEY_UP,			 ///< A[
				eKEY_PGUP			= eKEY_PRIOR,		 ///< PageUp
				eKEY_LEFTARROW		= eKEY_LEFT,		 ///< A[
				eKEY_RIGHTARROW		= eKEY_RIGHT,		 ///< EA[
				eKEY_DOWNARROW		= eKEY_DOWN,		 ///< A[
				eKEY_PGDN			= eKEY_NEXT,		 ///< PageDown
			};
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_KEYS_H