#ifndef BLAST_INPUT_IMOUSE_H
#define BLAST_INPUT_IMOUSE_H

#include "Blast/Input/Buttons.h"


namespace Blast
{
	namespace Input
	{
		/// }EX̃C^[tF[X
		class IMouse
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// zfXgN^
			virtual ~IMouse() { }

			/// XV
			virtual void Update(const float& kRDelta) = 0;

			/// {^Ă邩擾
			virtual bool IsDown(Buttons::EButton) const = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Buttons::EButton) const  = 0;

			/// {^Ă邩擾
			virtual bool IsUp(Buttons::EButton) const  = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Buttons::EButton) const  = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Buttons::EButton, const float& kRInterval) = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Buttons::EButton, const float& kRInterval) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Buttons::EButton, const float& kRInterval, const float& kRDelay) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Buttons::EButton, const float& kRInterval, const float& kRDelay) = 0;

			/// J[\XW擾
			virtual int GetPositionX() const = 0;
			
			/// J[\YW擾
			virtual int GetPositionY() const = 0;

			/// J[\XẄړʂ擾
			virtual int GetDeltaPositionX() const = 0;

			/// J[\YẄړʂ擾
			virtual int GetDeltaPositionY() const = 0;

			/// zC[̑ʂ擾
			virtual long GetWheel() const = 0;

			/// zC[̏]sꂽǂ擾
			virtual bool IsWheelUp() const = 0;

			/// zC[̉]sꂽǂ擾
			virtual bool IsWheelDown() const = 0;

		private:
		};

	} // namespace Input
} // namespace Blast


#endif // BLAST_INPUT_IMOUSE_H
