#ifndef BLAST_INPUT_IKEYBOARD_H
#define BLAST_INPUT_IKEYBOARD_H

#include <vector>
#include "Blast/Input/Keys.h"


namespace Blast
{
	namespace Input
	{
		/// L[{[h̃C^[tF[X
		class IKeyboard
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~IKeyboard() { }
			
			/// XV
			virtual void Update(const float& kRDelta) = 0;

			/// {^Ă邩擾
			virtual bool IsDown(Keys::EKey) const = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Keys::EKey) const  = 0;

			/// ̃{^ꂽuԂ擾
			virtual bool IsJustDownAny() const = 0;

			/// {^Ă邩擾
			virtual bool IsUp(Keys::EKey) const  = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Keys::EKey) const  = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Keys::EKey, const float& kRInterval) = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Keys::EKey, const float& kRInterval) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Keys::EKey, const float& kRInterval, const float& kRDelay) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Keys::EKey, const float& kRInterval, const float& kRDelay) = 0;

			/// ĂL[擾
			virtual void GetDownKeys(std::vector<Keys::EKey>* pOut) const = 0;
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_IKEYBOARD_H