#ifndef BLAST_INPUT_IJOYSTICK_H
#define BLAST_INPUT_IJOYSTICK_H

#include "Blast/Input/Buttons.h"
#include "Blast/Input/Sticks.h"
#include "Blast/Input/PointOfViews.h"


namespace Blast
{
	namespace Input
	{
		/// WCXeBbÑC^[tF[X
		class IJoystick
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// zfXgN^
			virtual ~IJoystick() { }
			
			/// XV
			virtual void Update(const float& kRDelta) = 0;

			/// {^Ă邩擾
			virtual bool IsDown(Buttons::EButton) const = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Buttons::EButton) const  = 0;

			/// {^Ă邩擾
			virtual bool IsUp(Buttons::EButton) const  = 0;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Buttons::EButton) const  = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Buttons::EButton, const float& kRInterval) = 0;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Buttons::EButton, const float& kRInterval) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Buttons::EButton, const float& kRInterval, const float& kRDelay) = 0;

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Buttons::EButton, const float& kRInterval, const float& kRDelay) = 0;

			/// XeBbNX̌X|ʂ擾
			virtual int GetStickTiltX(Sticks::EStick) const = 0;

			/// XeBbNY̌X|ʂ擾
			virtual int GetStickTiltY(Sticks::EStick) const = 0;

			/// XeBbŃ{X̌X|ʂlĂ邩
			virtual bool IsStickTiltPlusX(Sticks::EStick, int tiltBorder) const = 0;

			/// XeBbŃ|X̌X|ʂlĂ邩
			virtual bool IsStickTiltMinusX(Sticks::EStick, int tiltBorder) const = 0;

			/// XeBbŃ{Y̌X|ʂlĂ邩
			virtual bool IsStickTiltPlusY(Sticks::EStick, int tiltBorder) const = 0;

			/// XeBbŃ|Y̌X|ʂlĂ邩
			virtual bool IsStickTiltMinusY(Sticks::EStick, int tiltBorder) const = 0;

			// MEMO:\L[̐Ƃ͌܂񂪁Awǂ̃Q[͈Ŗł傤

			/// \L[Ă邩擾
			virtual bool IsDownPOV(PointOfViews::EPointOfView, int index) const = 0;

			/// \L[Ă邩擾
			virtual bool IsUpPOV(PointOfViews::EPointOfView, int index) const = 0;

			/// \L[ꂽuԂ擾
			virtual bool IsJustDownPOV(PointOfViews::EPointOfView, int index) const = 0;

			/// \L[ꂽuԂ擾
			virtual bool IsJustUpPOV(PointOfViews::EPointOfView, int index) const = 0;

			/// \L[Ă邩ԊuŎ擾
			virtual bool IsRapidDownPOV(PointOfViews::EPointOfView, float interval, int index) = 0;

			/// \L[Ă邩ԊuŎ擾
			virtual bool IsRapidUpPOV(PointOfViews::EPointOfView, float interval, int index) = 0;

			/// \L[Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDownPOV(PointOfViews::EPointOfView, float interval, float delay, int index)  = 0;

			/// \L[Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUpPOV(PointOfViews::EPointOfView, float interval, float delay, int index) = 0;
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_IJOYSTICK_H
