#ifndef BLAST_IO_CSVRECORD_H
#define BLAST_IO_CSVRECORD_H

#include <list>
#include "CSVVariant.h"


namespace Blast
{
	namespace IO
	{
		/// CSV̈s̃f[^SNX
		class CSVRecord
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// tB[h
			struct SField
			{
			public:
				/// ftHgRXgN^
				SField();

				/// RXgN^
				SField(const TCHAR* kPName, const TCHAR* kPValue);

				/// fXgN^
				~SField();


				/// 񖼂擾
				const TCHAR* GetColumnName() const;

				/// 񖼂ݒ
				void SetColumnName(const TCHAR*);


				/// l擾
				const CSVVariant& GetValueRef() const;

				/// lݒ
				void SetValue(const CSVVariant&);

				/// lݒ
				void SetValue(const TCHAR*);


		#if _DEBUG

				/// DEBUG:_v
				void Dump() const;

		#endif // _DEBUG

			private:
				/// OB񖼂ɑ
				tstring mColumnNameStr;

				/// l
				CSVVariant mValue;
			};


			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// ľ^
			typedef std::list<SField> Items;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			CSVRecord();
			
			/// fXgN^
			~CSVRecord();


			/// ڂNA
			void ClearItems();


			/// ڂǉ
			int InsertItem(const SField&);

			/// ڐ擾
			int GetItemCount() const;


			/// ڏ擾
			const SField* GetItem(int index) const;

			/// ڏ𖼑OwŎ擾
			const SField* GetItem(const TCHAR* const pName) const;


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// z񉉎ZqŃANZX\ɂ
			const SField* operator[] (int) const;

			/// z񉉎Zqɗ񖼂邱ƂŃANZX\ɂ
			const SField* operator[] (const TCHAR* const) const;


		#if _DEBUG

			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// DEBUG:_v
			void Dump() const;

		#endif // _DEBUG

		private:
			/// tB[hXg
			Items mItemList;
		};
	} // namespace IO
} // namespace Blast

#endif // BLAST_IO_CSVRECORD_H