#ifndef BLAST_IO_CSVFILE_H
#define BLAST_IO_CSVFILE_H

#include "Blast/IO/File.h"
#include "Blast/IO/CSVTable.h"


namespace Blast
{
	namespace IO
	{
		/// CSV`t@CSNX
		class CSVFile
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			CSVFile(const TCHAR* kPDirectoryPath, const TCHAR* kPFileName);
			
			/// RXgN^
			CSVFile(const TCHAR* kPFullPath);
			
			/// fXgN^
			~CSVFile();


			/// f[^e[u\z
			bool Create();

			/// f[^e[u
			void Release();


			/// t@C擾
			SP<Blast::IO::File> GetFile();


			/// t@C擾
			const tstring& GetFileNameRef() const;

			/// t@Cݒ
			void SetFileName(const TCHAR*);


			/// t@C̃fBNgpX擾
			const tstring& GetDirectoryPathRef() const;

			/// t@C̃fBNgpXݒ
			void SetDirectoryPath(const TCHAR*);


			/// f[^̗񐔂擾
			int GetColumnCount() const;

			/// f[^̍s擾
			int GetRowCount() const;


			/// f[^e[u擾
			const SP<CSVTable> GetDataTable() const;

		private:
			/// t@C
			SP<Blast::IO::File> mPFile;


			/// t@C
			tstring mFileNameStr;

			/// t@C̃fBNgpX
			tstring mDirectoryPathStr;


			/// f[^̗
			int mDataColumnCount;

			/// f[^̍s
			int mDataRowCount;


			/// f[^e[u
			SP<CSVTable> mPDataTable;


			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// MEMO:錾݂̂łB
			/// Rs[RXgN^֎~
			CSVFile(const CSVFile&);

			/// MEMO:錾݂̂łB
			/// ֎~
			void operator= (const CSVFile&);
		};

	} // namespace IO
} // namespace Blast

#endif // BLAST_IO_CSVFILE_H