#ifndef BLAST_GRAPHIC_TEXTRENDERER_H
#define BLAST_GRAPHIC_TEXTRENDERER_H

#include <vector>
#include "Blast/Graphic/ITextRenderer.h"


namespace Blast
{
	namespace Graphic
	{
		/// tHggpĕ`悷NX
		class TextRendererColorTag : public Blast::Graphic::ITextRenderer
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// MEMO:̕ӂ̃R[hV{AǂɓZ߂ǂł傤B

			/// J[R[hƂ݂ȂL
			static const TCHAR mStKPColorCodeSymbol;

			/// CtB[hƂ݂Ȃ
			static const TCHAR mStKPLineFeed;


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// eLXg
			struct STextData
			{
			public:
				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				STextData();

				
				//====================================================================================================
				// Field
				//----------------------------------------------------------------------------------------------------

				/// MEMO:1Ȃ̂TCHAR̕ǂł傤B
				/// 
				tstring mTextStr;

				/// ʐFB
				/// 񒆂ɕFύXۂɎgpB
				Blast::Graphic::Color mPrivateColor;
				/// ʐFgp邩ǂB
				bool mIsUsePrivateColor;

				/// ʒȗΕ`ʒu
				Blast::Math::Vector3 mRelativePosition;
				/// ]l̑Ή]l
				Blast::Math::Vector3 mRotation;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			TextRendererColorTag(SP<IFont>);
			/// fXgN^
			~TextRendererColorTag();

			/// `
			virtual void Render() override;

			/// `ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const override;
			/// `ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) override;

			/// eLXg擾
			virtual const TCHAR* const GetText() const override;
			/// eLXgݒ
			virtual void SetText(const TCHAR* const) override;

			/// {F擾
			virtual const Blast::Graphic::Color& GetBasicColor() const override;
			/// {Fݒ
			virtual void SetBasicColor(const Blast::Graphic::Color&) override;

			/// tHg擾
			virtual const SP<Blast::Graphic::IFont> GetFont() const override;
			/// tHgݒ
			virtual void SetFont(const SP<Blast::Graphic::IFont>) override;

			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>) override;

		private:
			SP<IFont> mPFont;					///< tHg
			Blast::Math::Vector3 mPosition;		///< ʒu
			Blast::Math::Vector3 mRotation;		///< ]l
			tstring mOriginalTextStr;			///< 
			Blast::Graphic::Color mBasicColor;	///< WF
			std::vector<STextData> mSTextDatas;	///< eLXgQ
			
			/// eLXg̉̓tOBꂪtrueƕ`掞ɉ͂sB
			bool mIsNeedAnalyze;

			
			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

			/// ͂sB
			/// ͕͂̂񂪕ύXꂽA
			/// gp鑤炷Ε̐ݒ`OōsƂwǂȂ̂ŁA
			/// łvȋdB
			void AnalyzeText();
		};

	}// namespace Graphic
}// namespace Blast

#endif // BLAST_GRAPHIC_TEXTRENDERER_H