#ifndef BLAST_GRAPHIC_SKELETONFBX_H
#define BLAST_GRAPHIC_SKELETONFBX_H

#include "Blast/Graphic/ISkeleton.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"


namespace Blast
{
	namespace Graphic
	{
		/// Fbx̃XPgSNX
		class SkeletonFbx : public Blast::Graphic::ISkeleton
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// _obt@̎
			enum EVertexBuffer
			{
				/// {[CfbNX
				eVERTEXBUFFER_BONE_INDEX,

				/// {[EFCg
				eVERTEXBUFFER_BONE_WEIGHT,

				/// 񋓗vf̐
				eVERTEXBUFFER_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// {[̍ő吔
			static const int mStKMaxBoneCount = 255;


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// {[
			struct SBone
			{
			public:
				/// RXgN^
				SBone();

				/// oCh|[Ys
				Blast::Math::Matrix mBindPoseMatrix;

				/// Jg|[Ys
				Blast::Math::Matrix mCurrentPoseMatrix;
			};



			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			SkeletonFbx();

			/// fXgN^
			virtual ~SkeletonFbx();


			/// ǂݍ
			virtual bool Load(const TCHAR* kPFullPath);


			/// XV
			virtual void Update(float);

			
			/// {[CfbNXobt@擾
			SP<Blast::Graphic::VertexBufferDX9> GetBoneIndexVertexBuffer();

			/// {[CfbNXobt@擾
			const SP<Blast::Graphic::VertexBufferDX9> GetBoneIndexVertexBuffer() const;


			/// {[EFCgobt@擾
			SP<Blast::Graphic::VertexBufferDX9> GetBoneWeightVertexBuffer();

			/// {[EFCgobt@擾
			const SP<Blast::Graphic::VertexBufferDX9> GetBoneWeightVertexBuffer() const;


			/// {[̐擾
			int GetBoneCount() const;


			/// NX^z擾
			const SP<fbxsdk_2012_2::KFbxCluster*> GetClusters() const;

			/// NX^z擾
			SP<fbxsdk_2012_2::KFbxCluster*> GetClusters();


			/// NX^擾
			const fbxsdk_2012_2::KFbxCluster* GetClusterPtr(int index) const;

			/// NX^擾
			fbxsdk_2012_2::KFbxCluster* GetClusterPtr(int index);


			/// {[z擾
			const SBone* GetBones() const;

			/// {[z擾
			SBone* GetBones();


			/// {[擾
			const SBone& GetBone(int index) const;

			/// {[擾
			SBone& GetBone(int index);


		private:
			// FBXSDK
			fbxsdk_2012_2::KFbxSdkManager* mPFbxSdkManager;

			/// ftH[}[
			fbxsdk_2012_2::KFbxDeformer* mPDeformer;

			/// XL
			fbxsdk_2012_2::KFbxSkin* mPSkin;


			/// NX^z
			SP<fbxsdk_2012_2::KFbxCluster*> mPClusters;


			/// {[z
			SBone mSBones[mStKMaxBoneCount];

			/// {[̐
			int mBoneCount;


			/// o[ebNXobt@z
			SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];
			

			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// bVm[h擾
			void FindMeshNode(KFbxNode*, KFbxMesh** pOut);

		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_SKELETONFBX_H
