#ifndef BLAST_GRAPHIC_ITEXTRENDERER
#define BLAST_GRAPHIC_ITEXTRENDERER

#include "Blast/Graphic/IFont.h"
#include "Blast/Graphic/ICamera.h"


namespace Blast
{
	namespace Graphic
	{
		/// ̕`揈@\SC^[tF[X
		class ITextRenderer
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// fXgN^
			virtual ~ITextRenderer() { }


			/// `
			virtual void Render() = 0;


			/// `ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const = 0;

			/// `ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) = 0;


			/// eLXg擾
			virtual const TCHAR* const GetText() const = 0;

			/// eLXgݒ
			virtual void SetText(const TCHAR* const) = 0;


			/// {F擾
			virtual const Blast::Graphic::Color& GetBasicColor() const = 0;

			/// {Fݒ
			virtual void SetBasicColor(const Blast::Graphic::Color&) = 0;


			/// tHg擾
			virtual const SP<Blast::Graphic::IFont> GetFont() const = 0;

			/// tHgݒ
			virtual void SetFont(const SP<Blast::Graphic::IFont>) = 0;

			
			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>) = 0;
		};
	} // namespace Graphic
} // namespace Blast



#endif // BLAST_GRAPHIC_ITEXTRENDERER