#ifndef BLAST_GRAPHIC_FONT_H
#define BLAST_GRAPHIC_FONT_H

#include "Blast/Graphic/IFont.h"
#include "Blast/Graphic/ICamera.h"


namespace Blast
{
	namespace Graphic
	{
		/// tHg̏ێNX
		class Font : public Blast::Graphic::IFont
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ̃tHg
			static const TCHAR* const stKPFontName;

			/// ̃TCY
			static const int stKFontSize = 10;

			/// ̃EFCg
			static const int stKFontWeight = 500;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Font();

			/// fXgN^
			virtual ~Font();


			/// `
			virtual void Render();


			/// tHg擾
			virtual const TCHAR* const GetFaceName() const;

			/// |CgTCY擾
			virtual int GetPointSize() const;

			/// EFCg擾
			virtual int GetWeight() const;


			/// `悷ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const;

			/// `悷ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&);


			/// ]l擾
			virtual const Blast::Math::Vector3& GetRotation() const;

			/// ]lݒ
			virtual void SetRotation(const Blast::Math::Vector3&);


			/// F擾
			virtual Color& GetColor();

			/// F擾
			virtual const Color& GetColor() const;

			/// Fݒ
			virtual void SetColor(const Color&);


			/// `悷镶擾
			virtual const TCHAR* const GetText() const;

			/// `悷镶ݒ
			virtual void SetText(const TCHAR* const);


			/// Jݒ
			virtual void SetCamera(const SP<ICamera>);


			/// ̗̈̒擾
			virtual int MeasureString(const TCHAR* const) const;

		protected:
			/// tHg
			tstring mFaceNameStr;

			/// |CgTCY
			int mPointSize;

			/// EFCg
			int mWeight;


			/// ʒu
			Blast::Math::Vector3 mPosition;

			/// ]
			Blast::Math::Vector3 mRotation;

			/// F
			Color mColor;

			/// 
			tstring mTextStr;


			/// J
			SP<ICamera> mPCamera;
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_FONT_H