#ifndef BLAST_GRAPHIC_FADE_H
#define BLAST_GRAPHIC_FADE_H

#include "Blast/Base/RenderableGameComponent.h"
//#include "Blast/Graphic/IMeshPrimitive.h"
#include "Blast/Graphic/DirectX9/MeshSpriteDX9.h"
#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// tF[h̏SNX
		class Fade : public Blast::Base::RenderableGameComponent
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// Ԃ̗񋓑
			enum EState
			{
				/// tF[hJn
				eSTATE_START,

				/// tF[h
				eSTATE_FADING,

				/// tF[hI
				eSTATE_END,


				/// 񋓗vf̐
				eSTATE_COUNT,
			};

			/// tF[h̕
			enum EDirection
			{
				/// tF[hC
				eDIRECTION_IN,

				/// tF[hAEg
				eDIRECTION_OUT,


				/// 񋓗vf̐
				eDIRECTION_COUNT,
			};

			/// eNX`̎
			enum ETexture
			{
				/// fBt[Y
				eTEXTURE_DIFFUSE,

				/// [
				eTEXTURE_RULE,


				/// 񋓗vf̐
				eTEXTURE_COUNT,
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Fade();

			/// fXgN^
			~Fade();

			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// tF[hJn
			void StartFade();

			/// jo[TgWVJn
			void StartUniversal();

			/// I
			void End();

			/// ꎞ~
			void Pause();

			/// ĊJ
			void Resume();


			/// tF[hǂ
			bool IsFading() const;

			/// tF[hIĂ邩ǂ
			bool IsEnd() const;

			/// ꎞ~Ă邩ǂ
			bool IsPause() const;


			/// tF[h̕擾
			EDirection GetDirection() const;

			/// tF[h̕ݒ
			void SetDirection(EDirection);


			/// tF[hɂ鎞Ԃ擾
			double GetDurationTime() const;

			/// tF[hɂ鎞Ԃݒ
			void SetDurationTime(double);

			/// tF[hJňoߎԂ擾
			double GetElapsedTime() const;

			/// MEMO:0ōŏA1ŊłB
			/// tF[h̐iSŎ擾
			double GetPercentage() const;


			/// tF[hF擾
			const Blast::Graphic::Color& GetColorRef() const;

			/// tF[hFݒ
			void SetColor(const Blast::Graphic::Color&);


			/// fBt[YeNX`ݒ
			void SetDiffuseTexture(SP<Blast::Graphic::ITexture2D>);

			/// [eNX`ݒ
			void SetRuleTexture(SP<Blast::Graphic::ITexture2D>);

		private:
			/// 
			EState mEState;

			/// tF[h̕
			EDirection mEDirection;

			/// ꎞ~Ԃǂ
			bool mIsPause;

			/// tF[h܂łɂ鎞
			double mDurationTime;

			/// oߎ
			double mElapsedTime;

			/// jo[Tǂ
			bool mIsUniversal;

			/// tF[hF
			Blast::Graphic::Color mFadeColor;

			/// eNX`Q
			SP<Blast::Graphic::ITexture2D> mPTextures[eTEXTURE_COUNT];

			/// bV
			SP<Blast::Graphic::MeshSpriteDX9> mPMesh;

			/// VF[_[GtFNg
			SP<Blast::Graphic::ShaderEffectDX9> mPShaderEffect;

			
			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

			/// VF[_[ɃeNX`ݒ
			void SetTextureToShader();
		};
	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_FADE_H